/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.sink.AbstractSink;
import adams.flow.sink.redisaction.AbstractRedisAction;
import adams.flow.sink.redisaction.Null;
import adams.flow.standalone.RedisConnection;

public class RedisSink
extends AbstractSink {
    private static final long serialVersionUID = 1493888634513409037L;
    protected AbstractRedisAction m_Action;
    protected transient RedisConnection m_Connection;

    public String globalInfo() {
        return "Applies the specified action to the incoming object.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("action", "action", (Object)new Null());
    }

    public void setAction(AbstractRedisAction value) {
        this.m_Action = value;
        this.reset();
    }

    public AbstractRedisAction getAction() {
        return this.m_Action;
    }

    public String actionTipText() {
        return "The action to execute.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"action", (Object)((Object)this.m_Action), (String)"action: ");
    }

    public Class[] accepts() {
        return this.m_Action.accepts();
    }

    public String setUp() {
        Object result = super.setUp();
        if (result == null) {
            this.m_Connection = (RedisConnection)ActorUtils.findClosestType((Actor)this, RedisConnection.class);
            if (this.m_Connection == null) {
                result = "No " + Utils.classToString(RedisConnection.class) + " actor found!";
            }
        }
        return result;
    }

    protected String doExecute() {
        String result;
        try {
            result = this.m_Action.execute(this.m_Connection, this.m_InputToken.getPayload());
        }
        catch (Exception e) {
            result = this.handleException("Failed to execute action: " + this.m_Action, e);
        }
        return result;
    }
}

