/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink.redisaction;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.redis.RedisDataType;
import adams.flow.sink.redisaction.AbstractRedisAction;
import adams.flow.standalone.RedisConnection;

public class Publish
extends AbstractRedisAction {
    private static final long serialVersionUID = -5422044797578071875L;
    protected String m_Channel;
    protected RedisDataType m_Type;

    public String globalInfo() {
        return "Publishes the incoming message to the specified channel.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("channel", "channel", (Object)"");
        this.m_OptionManager.add("type", "type", (Object)RedisDataType.STRING);
    }

    public void setChannel(String value) {
        this.m_Channel = value;
        this.reset();
    }

    public String getChannel() {
        return this.m_Channel;
    }

    public String channelTipText() {
        return "The name of the channel to publish on.";
    }

    public void setType(RedisDataType value) {
        this.m_Type = value;
        this.reset();
    }

    public RedisDataType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of the data.";
    }

    @Override
    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"channel", (Object)(this.m_Channel.isEmpty() ? "-empty-" : this.m_Channel), (String)"channel: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)((Object)this.m_Type), (String)", type: ");
        return result;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{this.m_Type.getDataClass()};
    }

    @Override
    protected String doExecute(RedisConnection connection, Object o) {
        switch (this.m_Type) {
            case STRING: {
                connection.getConnection(this.m_Type.getCodecClass()).sync().publish((Object)this.m_Channel, o);
                return null;
            }
            case BYTE_ARRAY: {
                connection.getConnection(this.m_Type.getCodecClass()).sync().publish((Object)this.m_Channel.getBytes(), o);
                return null;
            }
        }
        return "Unhandled redis data type: " + this.m_Type;
    }
}

