/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink.redisaction;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.redis.RedisDataType;
import adams.flow.sink.redisaction.AbstractRedisAction;
import adams.flow.standalone.RedisConnection;

public class Set
extends AbstractRedisAction {
    private static final long serialVersionUID = 719961140137073707L;
    protected String m_Key;
    protected RedisDataType m_Type;

    public String globalInfo() {
        return "Sets the incoming data under the specified key.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("key", "key", (Object)"");
        this.m_OptionManager.add("type", "type", (Object)RedisDataType.STRING);
    }

    public void setKey(String value) {
        this.m_Key = value;
        this.reset();
    }

    public String getKey() {
        return this.m_Key;
    }

    public String keyTipText() {
        return "The name of the Key.";
    }

    public void setType(RedisDataType value) {
        this.m_Type = value;
        this.reset();
    }

    public RedisDataType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of the data.";
    }

    @Override
    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"key", (Object)(this.m_Key.isEmpty() ? "-empty-" : this.m_Key), (String)"key: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)((Object)this.m_Type), (String)", type: ");
        return result;
    }

    @Override
    public Class[] accepts() {
        return new Class[]{this.m_Type.getDataClass()};
    }

    @Override
    protected String doExecute(RedisConnection connection, Object o) {
        switch (this.m_Type) {
            case STRING: {
                connection.getConnection(this.m_Type.getCodecClass()).sync().set((Object)this.m_Key, o);
                return null;
            }
            case BYTE_ARRAY: {
                connection.getConnection(this.m_Type.getCodecClass()).sync().set((Object)this.m_Key.getBytes(), o);
                return null;
            }
        }
        return "Unhandled redis data type: " + this.m_Type;
    }
}

