/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.Token;
import adams.flow.source.AbstractSimpleSource;
import adams.flow.source.redisaction.AbstractRedisAction;
import adams.flow.source.redisaction.Null;
import adams.flow.standalone.RedisConnection;

public class RedisSource
extends AbstractSimpleSource {
    private static final long serialVersionUID = -1587605471834549505L;
    protected AbstractRedisAction m_Action;
    protected transient RedisConnection m_Connection;

    public String globalInfo() {
        return "Executes the specified action to generate output.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("action", "action", (Object)new Null());
    }

    public void setAction(AbstractRedisAction value) {
        this.m_Action = value;
        this.reset();
    }

    public AbstractRedisAction getAction() {
        return this.m_Action;
    }

    public String actionTipText() {
        return "The action to execute.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"action", (Object)((Object)this.m_Action), (String)"action: ");
    }

    public Class[] generates() {
        return new Class[]{this.m_Action.generates()};
    }

    public String setUp() {
        Object result = super.setUp();
        if (result == null) {
            this.m_Connection = (RedisConnection)ActorUtils.findClosestType((Actor)this, RedisConnection.class);
            if (this.m_Connection == null) {
                result = "No " + Utils.classToString(RedisConnection.class) + " actor found!";
            }
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        MessageCollection errors = new MessageCollection();
        try {
            Object output = this.m_Action.execute(this.m_Connection, errors);
            if (!errors.isEmpty()) {
                result = errors.toString();
            } else if (output != null) {
                this.m_OutputToken = new Token(output);
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to execute action: " + this.m_Action, e);
        }
        return result;
    }
}

