/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.MessageCollection;
import adams.core.PasswordPrompter;
import adams.core.QuickInfoHelper;
import adams.core.base.BasePassword;
import adams.core.io.ConsoleHelper;
import adams.core.option.OptionHandler;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.core.OptionalPasswordPrompt;
import adams.flow.core.StopHelper;
import adams.flow.core.StopMode;
import adams.flow.standalone.AbstractStandalone;
import adams.gui.dialog.PasswordDialog;
import io.lettuce.core.RedisClient;
import io.lettuce.core.RedisURI;
import io.lettuce.core.SslVerifyMode;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.codec.ByteArrayCodec;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.codec.StringCodec;
import java.awt.Dialog;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class RedisConnection
extends AbstractStandalone
implements OptionalPasswordPrompt,
PasswordPrompter {
    private static final long serialVersionUID = -1726172998200420556L;
    public static final int DEFAULT_PORT = 6379;
    protected String m_Host;
    protected int m_Port;
    protected int m_Database;
    protected boolean m_UseSSL;
    protected boolean m_StartTLS;
    protected SslVerifyMode m_SSLVerifyMode;
    protected BasePassword m_Password;
    protected BasePassword m_ActualPassword;
    protected boolean m_PromptForPassword;
    protected boolean m_StopFlowIfCanceled;
    protected StopMode m_StopMode;
    protected String m_CustomStopMessage;
    protected transient RedisClient m_Client;
    protected transient Map<Class, StatefulRedisConnection> m_Connections;

    public String globalInfo() {
        return "Defines a connection to a Redis server.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("host", "host", (Object)"localhost");
        this.m_OptionManager.add("port", "port", (Object)6379, (Number)1, (Number)65535);
        this.m_OptionManager.add("database", "database", (Object)0, (Number)0, (Number)65535);
        this.m_OptionManager.add("use-ssl", "useSSL", (Object)false);
        this.m_OptionManager.add("start-tls", "startTLS", (Object)false);
        this.m_OptionManager.add("ssl-verify-mode", "SSLVerifyMode", (Object)SslVerifyMode.NONE);
        this.m_OptionManager.add("password", "password", (Object)new BasePassword(""), false);
        this.m_OptionManager.add("prompt-for-password", "promptForPassword", (Object)false);
        this.m_OptionManager.add("stop-if-canceled", "stopFlowIfCanceled", (Object)false);
        this.m_OptionManager.add("custom-stop-message", "customStopMessage", (Object)"");
        this.m_OptionManager.add("stop-mode", "stopMode", (Object)StopMode.GLOBAL);
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"host", (Object)this.m_Host);
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"port", (Object)this.m_Port, (String)":");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"database", (Object)this.m_Database, (String)"/");
        ArrayList options = new ArrayList();
        if (QuickInfoHelper.hasVariable((OptionHandler)this, (String)"promptForPassword") || this.m_PromptForPassword) {
            QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"promptForPassword", (boolean)this.m_PromptForPassword, (String)"prompt for password"));
            QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"stopFlowIfCanceled", (boolean)this.m_StopFlowIfCanceled, (String)"stop flow"));
        }
        if (QuickInfoHelper.hasVariable((OptionHandler)this, (String)"useSSL") || this.m_UseSSL) {
            QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"useSSL", (boolean)this.m_UseSSL, (String)"SSL"));
            QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"startTLS", (boolean)this.m_StartTLS, (String)"TLS"));
            result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"SSLVerifyMode", (Object)this.m_SSLVerifyMode, (String)", ssl-verify-mode: ");
        }
        result = (String)result + QuickInfoHelper.flatten(options);
        return result;
    }

    public String getHost() {
        return this.m_Host;
    }

    public void setHost(String value) {
        this.m_Host = value;
        this.reset();
    }

    public String hostTipText() {
        return "The host (name/IP address) to connect to.";
    }

    public int getPort() {
        return this.m_Port;
    }

    public void setPort(int value) {
        if (this.getOptionManager().isValid("port", (Number)value)) {
            this.m_Port = value;
            this.reset();
        }
    }

    public String portTipText() {
        return "The port to connect to.";
    }

    public int getDatabase() {
        return this.m_Database;
    }

    public void setDatabase(int value) {
        this.m_Database = value;
        this.reset();
    }

    public String databaseTipText() {
        return "The database to use (usually 0).";
    }

    public boolean getUseSSL() {
        return this.m_UseSSL;
    }

    public void setUseSSL(boolean value) {
        this.m_UseSSL = value;
        this.reset();
    }

    public String useSSLTipText() {
        return "If enabled, SSL is used for the connection.";
    }

    public boolean getStartTLS() {
        return this.m_StartTLS;
    }

    public void setStartTLS(boolean value) {
        this.m_StartTLS = value;
        this.reset();
    }

    public String startTLSTipText() {
        return "If enabled, StartTLS is used with SSL connections.";
    }

    public SslVerifyMode getSSLVerifyMode() {
        return this.m_SSLVerifyMode;
    }

    public void setSSLVerifyMode(SslVerifyMode value) {
        this.m_SSLVerifyMode = value;
        this.reset();
    }

    public String SSLVerifyModeTipText() {
        return "How to verify SSL peers.";
    }

    public void setPassword(BasePassword value) {
        this.m_Password = value;
        this.reset();
    }

    public BasePassword getPassword() {
        return this.m_Password;
    }

    public String passwordTipText() {
        return "The password to use for connecting.";
    }

    public void setPromptForPassword(boolean value) {
        this.m_PromptForPassword = value;
        this.reset();
    }

    public boolean getPromptForPassword() {
        return this.m_PromptForPassword;
    }

    public String promptForPasswordTipText() {
        return "If enabled, the user gets prompted for enter a password if none has been provided in the setup.";
    }

    public void setStopFlowIfCanceled(boolean value) {
        this.m_StopFlowIfCanceled = value;
        this.reset();
    }

    public boolean getStopFlowIfCanceled() {
        return this.m_StopFlowIfCanceled;
    }

    public String stopFlowIfCanceledTipText() {
        return "If enabled, the flow gets stopped in case the user cancels the dialog.";
    }

    public void setCustomStopMessage(String value) {
        this.m_CustomStopMessage = value;
        this.reset();
    }

    public String getCustomStopMessage() {
        return this.m_CustomStopMessage;
    }

    public String customStopMessageTipText() {
        return "The custom stop message to use in case a user cancelation stops the flow (default is the full name of the actor)";
    }

    public void setStopMode(StopMode value) {
        this.m_StopMode = value;
        this.reset();
    }

    public StopMode getStopMode() {
        return this.m_StopMode;
    }

    public String stopModeTipText() {
        return "The stop mode to use.";
    }

    public StatefulRedisConnection<String, String> newConnection(MessageCollection errors) {
        try {
            return this.m_Client.connect();
        }
        catch (Exception e) {
            errors.add("Failed to create new connection!", (Throwable)e);
            return null;
        }
    }

    public RedisClient getClient() {
        return this.m_Client;
    }

    public StatefulRedisConnection getConnection(Class codec) {
        if (this.m_Connections.containsKey(codec)) {
            return this.m_Connections.get(codec);
        }
        if (codec == ByteArrayCodec.class) {
            this.m_Connections.put(codec, this.m_Client.connect((RedisCodec)new ByteArrayCodec()));
            return this.m_Connections.get(codec);
        }
        if (codec == StringCodec.class) {
            this.m_Connections.put(codec, this.m_Client.connect((RedisCodec)StringCodec.UTF8));
            return this.m_Connections.get(codec);
        }
        throw new IllegalStateException("Unhandled codec!");
    }

    public String doInteract() {
        PasswordDialog dlg = new PasswordDialog((Dialog)null, Dialog.ModalityType.DOCUMENT_MODAL);
        dlg.setLocationRelativeTo(this.getParentComponent());
        ((Flow)this.getRoot()).registerWindow((Window)dlg, dlg.getTitle());
        dlg.setVisible(true);
        ((Flow)this.getRoot()).deregisterWindow((Window)dlg);
        String result = dlg.getOption() == 0 ? null : "Interaction canceled!";
        if (result == null) {
            this.m_ActualPassword = dlg.getPassword();
        }
        return result;
    }

    public boolean supportsHeadlessInteraction() {
        return true;
    }

    public String doInteractHeadless() {
        String result = "Interaction canceled!";
        BasePassword password = ConsoleHelper.enterPassword((String)("Please enter password (" + this.getName() + "):"));
        if (password != null) {
            result = null;
            this.m_ActualPassword = password;
        }
        return result;
    }

    protected String connect() {
        String result = null;
        try {
            RedisURI.Builder builder = RedisURI.Builder.redis((String)this.m_Host, (int)this.m_Port).withDatabase(this.m_Database);
            if (!this.m_ActualPassword.isEmpty()) {
                builder.withPassword(this.m_ActualPassword.getValue().toCharArray());
            }
            if (this.m_UseSSL) {
                builder.withSsl(true);
                if (this.m_StartTLS) {
                    builder.withStartTls(true);
                }
                builder.withVerifyPeer(this.m_SSLVerifyMode);
            }
            this.m_Client = RedisClient.create((RedisURI)builder.build());
        }
        catch (Exception e) {
            result = this.handleException("Failed to create Redis client: " + this.m_Host + ":" + this.m_Port + "/" + this.m_Database, e);
        }
        this.m_Connections = new HashMap<Class, StatefulRedisConnection>();
        return result;
    }

    protected String doExecute() {
        String result = null;
        if (this.m_Client == null) {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Starting new session");
            }
            this.m_ActualPassword = this.m_Password;
            if (this.m_PromptForPassword && this.m_Password.getValue().length() == 0) {
                String msg;
                if (!this.isHeadless()) {
                    String msg2 = this.doInteract();
                    if (msg2 != null && this.m_StopFlowIfCanceled) {
                        if (this.m_CustomStopMessage == null || this.m_CustomStopMessage.trim().length() == 0) {
                            StopHelper.stop((Actor)this, (StopMode)this.m_StopMode, (String)("Flow canceled: " + this.getFullName()));
                        } else {
                            StopHelper.stop((Actor)this, (StopMode)this.m_StopMode, (String)this.m_CustomStopMessage);
                        }
                        result = this.getStopMessage();
                    }
                } else if (this.supportsHeadlessInteraction() && (msg = this.doInteractHeadless()) != null && this.m_StopFlowIfCanceled) {
                    if (this.m_CustomStopMessage == null || this.m_CustomStopMessage.trim().length() == 0) {
                        StopHelper.stop((Actor)this, (StopMode)this.m_StopMode, (String)("Flow canceled: " + this.getFullName()));
                    } else {
                        StopHelper.stop((Actor)this, (StopMode)this.m_StopMode, (String)this.m_CustomStopMessage);
                    }
                    result = this.getStopMessage();
                }
            }
            if (result == null) {
                result = this.connect();
            }
        } else if (this.isLoggingEnabled()) {
            this.getLogger().info("Re-using current session");
        }
        return result;
    }

    public void wrapUp() {
        if (this.m_Connections != null) {
            for (Class codec : this.m_Connections.keySet()) {
                this.m_Connections.get(codec).close();
            }
            this.m_Connections = null;
        }
        if (this.m_Client != null) {
            this.m_Client.shutdown();
            this.m_Client = null;
        }
        super.wrapUp();
    }
}

