/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.redisaction;

import adams.core.MessageCollection;
import adams.core.QuickInfoSupporter;
import adams.core.StoppableWithFeedback;
import adams.core.option.AbstractOptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.FlowContextHandler;
import adams.flow.standalone.RedisConnection;

public abstract class AbstractRedisAction
extends AbstractOptionHandler
implements QuickInfoSupporter,
StoppableWithFeedback,
FlowContextHandler {
    private static final long serialVersionUID = 1092502634722311323L;
    protected boolean m_Stopped;
    protected transient Actor m_FlowContext;

    protected void initialize() {
        super.initialize();
        this.m_Stopped = false;
    }

    public void setFlowContext(Actor value) {
        this.m_FlowContext = value;
    }

    public Actor getFlowContext() {
        return this.m_FlowContext;
    }

    public String getQuickInfo() {
        return null;
    }

    public abstract Class[] accepts();

    public abstract Class generates();

    public String check(RedisConnection connection, Object o) {
        if (this.m_FlowContext == null) {
            return "No flow context set!";
        }
        if (connection == null) {
            return "No Redis connection provided!";
        }
        if (o == null) {
            return "No object provided!";
        }
        return null;
    }

    protected abstract Object doExecute(RedisConnection var1, Object var2, MessageCollection var3);

    public Object execute(RedisConnection connection, Object o, MessageCollection errors) {
        Object result = null;
        this.m_Stopped = false;
        String msg = this.check(connection, o);
        if (msg == null) {
            result = this.doExecute(connection, o, errors);
        } else {
            errors.add(msg);
        }
        return result;
    }

    public boolean isStopped() {
        return this.m_Stopped;
    }

    public void stopExecution() {
        this.m_Stopped = true;
    }
}

