/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.rest;

import adams.core.Utils;
import adams.core.logging.LoggingLevelHandler;
import adams.core.net.ProxyHelper;
import adams.flow.core.Actor;
import adams.flow.rest.RESTPlugin;
import adams.flow.rest.interceptor.InterceptorWithActor;
import adams.flow.rest.interceptor.incoming.AbstractInInterceptorGenerator;
import adams.flow.rest.interceptor.outgoing.AbstractOutInterceptorGenerator;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.xml.ws.BindingProvider;
import org.apache.cxf.configuration.security.ProxyAuthorizationPolicy;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.ConnectionType;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.transports.http.configuration.ProxyServerType;

public class RESTUtils {
    public static final String MIMETYPE_APPLICATION_OCTETSTREAM = "application/octet-stream";
    public static final String MIMETYPE_PLAIN_TEXT = "plain/text";

    public static void configureClient(Actor owner, Object servicePort, int connection, int receive, String url) {
        Client client = ClientBuilder.newClient();
        HTTPConduit http = WebClient.getConfig((Object)client).getHttpConduit();
        HTTPClientPolicy clPolicy = new HTTPClientPolicy();
        clPolicy.setConnectionTimeout((long)connection);
        clPolicy.setReceiveTimeout((long)receive);
        clPolicy.setAllowChunking(false);
        clPolicy.setAutoRedirect(false);
        clPolicy.setConnection(ConnectionType.KEEP_ALIVE);
        ProxyAuthorizationPolicy proxyPolicy = null;
        switch (ProxyHelper.getSingleton().getProxyType()) {
            case DIRECT: {
                break;
            }
            case HTTP: {
                clPolicy.setProxyServerType(ProxyServerType.HTTP);
                clPolicy.setProxyServer(ProxyHelper.getSingleton().getHost(Proxy.Type.HTTP));
                clPolicy.setProxyServerPort(Integer.valueOf(ProxyHelper.getSingleton().getPort(Proxy.Type.HTTP)));
                clPolicy.setNonProxyHosts(Utils.flatten((Object[])ProxyHelper.getSingleton().getNoProxy(Proxy.Type.HTTP), (String)"|"));
                if (!ProxyHelper.getSingleton().getAuthentication(Proxy.Type.HTTP)) break;
                proxyPolicy = new ProxyAuthorizationPolicy();
                proxyPolicy.setUserName(ProxyHelper.getSingleton().getUser(Proxy.Type.HTTP));
                proxyPolicy.setPassword(ProxyHelper.getSingleton().getPassword(Proxy.Type.HTTP).getValue());
                proxyPolicy.setAuthorizationType("Basic");
                break;
            }
            case SOCKS: {
                clPolicy.setProxyServerType(ProxyServerType.SOCKS);
                clPolicy.setProxyServer(ProxyHelper.getSingleton().getHost(Proxy.Type.SOCKS));
                clPolicy.setProxyServerPort(Integer.valueOf(ProxyHelper.getSingleton().getPort(Proxy.Type.SOCKS)));
                clPolicy.setNonProxyHosts(Utils.flatten((Object[])ProxyHelper.getSingleton().getNoProxy(Proxy.Type.SOCKS), (String)"|"));
                if (!ProxyHelper.getSingleton().getAuthentication(Proxy.Type.SOCKS)) break;
                proxyPolicy = new ProxyAuthorizationPolicy();
                proxyPolicy.setUserName(ProxyHelper.getSingleton().getUser(Proxy.Type.SOCKS));
                proxyPolicy.setPassword(ProxyHelper.getSingleton().getPassword(Proxy.Type.SOCKS).getValue());
                proxyPolicy.setAuthorizationType("Basic");
                break;
            }
            default: {
                throw new IllegalStateException("Proxy type not supported by CXF clients: " + (Object)((Object)ProxyHelper.getSingleton().getProxyType()));
            }
        }
        http.setClient(clPolicy);
        if (proxyPolicy != null) {
            http.setProxyAuthorization(proxyPolicy);
        }
        if (url != null) {
            BindingProvider bindingProvider = (BindingProvider)servicePort;
            bindingProvider.getRequestContext().put("javax.xml.ws.service.endpoint.address", url);
        }
    }

    public static void configureFactoryInterceptors(Actor owner, JAXRSServerFactoryBean factory, AbstractInInterceptorGenerator inInterceptor, AbstractOutInterceptorGenerator outInterceptor) {
        Object in = inInterceptor.generate();
        Object out = outInterceptor.generate();
        if (owner.isLoggingEnabled()) {
            if (in != null && in instanceof LoggingLevelHandler) {
                ((LoggingLevelHandler)in).setLoggingLevel(owner.getLoggingLevel());
            }
            if (out != null && out instanceof LoggingLevelHandler) {
                ((LoggingLevelHandler)out).setLoggingLevel(owner.getLoggingLevel());
            }
        }
        if (in != null && in instanceof InterceptorWithActor) {
            ((InterceptorWithActor)in).setActor(owner);
        }
        if (out != null && out instanceof InterceptorWithActor) {
            ((InterceptorWithActor)out).setActor(owner);
        }
        if (in != null) {
            factory.getInInterceptors().add(in);
        }
        if (out != null) {
            factory.getOutInterceptors().add(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadWsdl(URL location) {
        StringBuilder result = new StringBuilder();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(location.openStream()));
            while ((line = reader.readLine()) != null) {
                result.append(line);
                result.append("\n");
            }
        }
        catch (Exception e) {
            System.err.println("Failed to load WSDL from " + location + ": ");
            e.printStackTrace();
            result = null;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        if (result != null) {
            return result.toString();
        }
        return null;
    }

    protected static String getAdditionalInformation(Class cls) {
        Path annotation;
        StringBuilder result = new StringBuilder();
        if (cls.isAnnotationPresent(Path.class)) {
            annotation = cls.getAnnotation(Path.class);
            result.append("- Path: " + annotation + "\n");
        }
        if (cls.isAnnotationPresent(Consumes.class)) {
            annotation = cls.getAnnotation(Consumes.class);
            result.append("- Consumes: " + annotation + "\n");
        }
        if (cls.isAnnotationPresent(Produces.class)) {
            annotation = cls.getAnnotation(Produces.class);
            result.append("- Produces: " + annotation + "\n");
        }
        if (result.length() == 0) {
            return null;
        }
        return result.toString();
    }

    protected static String getAdditionalInformation(Method method) {
        Path annotation;
        StringBuilder result = new StringBuilder();
        if (method.isAnnotationPresent(Path.class)) {
            annotation = method.getAnnotation(Path.class);
            result.append("- Path: " + annotation + "\n");
        }
        if (method.isAnnotationPresent(Consumes.class)) {
            annotation = method.getAnnotation(Consumes.class);
            result.append("- Consumes: " + annotation + "\n");
        }
        if (method.isAnnotationPresent(Produces.class)) {
            annotation = method.getAnnotation(Produces.class);
            result.append("- Produces: " + annotation + "\n");
        }
        int index = 0;
        for (Object[] objectArray : method.getParameterAnnotations()) {
            ++index;
            if (objectArray.length <= 0) continue;
            result.append("- Parameter #" + index + ": " + Utils.flatten((Object[])objectArray, (String)", ") + "\n");
        }
        ArrayList<String> methods = new ArrayList<String>();
        if (method.isAnnotationPresent(GET.class)) {
            methods.add("GET");
        }
        if (method.isAnnotationPresent(POST.class)) {
            methods.add("POST");
        }
        if (methods.size() > 0) {
            result.append("- Method(s): " + Utils.flatten(methods, (String)", ") + "\n");
        }
        if (result.length() == 0) {
            return null;
        }
        return result.toString();
    }

    public static String getAdditionalInformation(RESTPlugin plugin) {
        StringBuilder result = new StringBuilder();
        String info = RESTUtils.getAdditionalInformation(plugin.getClass());
        if (info != null) {
            result.append("REST Class\n").append(info);
        }
        for (Method method : plugin.getClass().getDeclaredMethods()) {
            info = RESTUtils.getAdditionalInformation(method);
            if (info == null) continue;
            if (result.length() > 0) {
                result.append("\n");
            }
            result.append("REST Method '" + method.getName() + "'\n");
            result.append(info);
        }
        if (result.length() == 0) {
            return null;
        }
        return result.toString();
    }
}

