/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.rest.echo;

import adams.core.base.BaseURL;
import adams.core.net.HttpRequestHelper;
import adams.flow.container.HTMLRequestResult;
import adams.flow.rest.AbstractRESTClientSink;
import adams.flow.rest.echo.EchoServer;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.jsoup.Connection;

public class EchoClientSink
extends AbstractRESTClientSink<String> {
    private static final long serialVersionUID = -4005180585673812548L;
    protected String m_RequestData;

    public String globalInfo() {
        return "Client (sink) for Echo REST service. Check console for result of webservice.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class};
    }

    @Override
    public void setRequestData(String value) {
        this.m_RequestData = value;
    }

    @Override
    protected void doQuery() throws Exception {
        String url = this.getUseAlternativeURL() ? this.getAlternativeURL() : new EchoServer().getDefaultURL();
        HTMLRequestResult result = HttpRequestHelper.send((BaseURL)new BaseURL(url = url + "echo/" + URLEncoder.encode(this.m_RequestData, "UTF-8")), (Connection.Method)Connection.Method.GET, null, null);
        if ((Integer)result.getValue("Status code", Integer.class) == 200) {
            this.getLogger().info(URLDecoder.decode((String)result.getValue("Body", String.class), "UTF-8"));
        } else {
            this.m_LastError = result.getValue("Status code") + ": " + result.getValue("Status message");
        }
    }
}

