/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.flow.core.AbstractRESTClient;
import adams.flow.core.InputConsumer;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;
import adams.flow.rest.RESTClient;
import adams.flow.rest.RESTClientConsumer;
import adams.flow.rest.RESTClientProducer;
import adams.flow.rest.echo.EchoClientTransformer;

public class RESTTransformer
extends AbstractRESTClient
implements InputConsumer,
OutputProducer {
    private static final long serialVersionUID = 3217721167611538066L;
    protected Token m_InputToken;

    public String globalInfo() {
        return "Sends data to a REST webservice and forwards the response.";
    }

    @Override
    protected RESTClientConsumer getDefaultClient() {
        return new EchoClientTransformer();
    }

    @Override
    protected String checkClient(RESTClient value) {
        if (!(value instanceof RESTClientConsumer)) {
            return "Does not implement " + RESTClientConsumer.class.getName() + "!";
        }
        if (!(value instanceof RESTClientProducer)) {
            return "Does not implement " + RESTClientProducer.class.getName() + "!";
        }
        return null;
    }

    public Class[] accepts() {
        return ((RESTClientConsumer)this.m_Client).accepts();
    }

    public void input(Token token) {
        this.m_InputToken = token;
        ((RESTClientConsumer)this.m_Client).setRequestData(token.getPayload());
    }

    public boolean hasInput() {
        return this.m_InputToken != null;
    }

    public Token currentInput() {
        return this.m_InputToken;
    }

    public Class[] generates() {
        return ((RESTClientProducer)this.m_Client).generates();
    }

    protected String doExecute() {
        return this.query();
    }

    public boolean hasPendingOutput() {
        return ((RESTClientProducer)this.m_Client).hasResponseData();
    }

    public Token output() {
        this.m_InputToken = null;
        return new Token(((RESTClientProducer)this.m_Client).getResponseData());
    }

    public void wrapUp() {
        this.m_InputToken = null;
        super.wrapUp();
    }

    @Override
    public void cleanUp() {
        this.m_Client.cleanUp();
        super.cleanUp();
    }
}

