/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.rest;

import adams.core.MessageCollection;
import adams.core.VariablesHandler;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.flow.control.Flow;
import adams.flow.control.RunningFlowsRegistry;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.rest.AbstractRESTPlugin;
import java.io.File;

public abstract class AbstractRegisteredFlowRESTPlugin
extends AbstractRESTPlugin {
    private static final long serialVersionUID = -3741993388570979031L;

    protected Actor getFlow(int id, boolean loadFromDisk, MessageCollection errors) {
        Flow result = null;
        if (id == -1) {
            if (RunningFlowsRegistry.getSingleton().size() == 1) {
                result = RunningFlowsRegistry.getSingleton().flows()[0];
            } else {
                errors.add("Using ID '-1' is only allowed if there is just a single flow registered (registered: " + RunningFlowsRegistry.getSingleton().size() + ")");
            }
        } else {
            result = RunningFlowsRegistry.getSingleton().getFlow(id);
            if (result == null) {
                errors.add("Failed to retrieve flow for ID " + id + "!");
            }
        }
        if (errors.isEmpty() && loadFromDisk) {
            String flowFile = result.getVariables().get("flow_filename_long");
            if (flowFile == null) {
                errors.add("Variable 'flow_filename_long' not set, cannot load from disk!");
            } else if (FileUtils.fileExists((String)flowFile)) {
                result = ActorUtils.read((String)flowFile);
                if (result == null) {
                    errors.add("Failed to load flow from  '" + flowFile + "'!");
                } else {
                    ActorUtils.updateProgrammaticVariables((Actor)((VariablesHandler)((Actor)((VariablesHandler)result))), (File)new PlaceholderFile(flowFile));
                }
            } else {
                errors.add("Flow '" + flowFile + "' does not exist!");
            }
        }
        if (errors.isEmpty()) {
            return result;
        }
        return null;
    }
}

