/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.rest.flow;

import adams.core.MessageCollection;
import adams.core.Utils;
import adams.flow.control.LocalScopeTransformer;
import adams.flow.control.ScopeHandler;
import adams.flow.core.AbstractCallableActor;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.CallableActorUser;
import adams.flow.core.Token;
import adams.flow.core.actorfilter.ActorFilter;
import adams.flow.core.actorfilter.SuperclassOrInterface;
import adams.flow.rest.AbstractRESTPluginWithFlowContext;
import java.util.List;

public abstract class AbstractCallablePipeline<T>
extends AbstractRESTPluginWithFlowContext
implements CallableActorUser {
    private static final long serialVersionUID = -4960256014415499156L;
    protected CallableActorReference m_Pipeline;
    protected transient Actor m_PipelineActor;
    protected boolean m_PipelineActorInitialized;
    protected ScopeHandler.ScopeHandling m_ScopeHandlingVariables;
    protected ScopeHandler.ScopeHandling m_ScopeHandlingStorage;
    protected CallableActorHelper m_Helper;

    protected String globalInfoBase() {
        return "Uses the specified callable transformer as template for processing the incoming data and sending back the resulting data.\nA copy of the callable transformer gets created with each request. The transformer itself gets wrapped in a " + Utils.classToString(LocalScopeTransformer.class) + ", with the specified handling of variables and storage.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("pipeline", "pipeline", (Object)new CallableActorReference());
        this.m_OptionManager.add("scope-handling-variables", "scopeHandlingVariables", (Object)ScopeHandler.ScopeHandling.EMPTY);
        this.m_OptionManager.add("scope-handling-storage", "scopeHandlingStorage", (Object)ScopeHandler.ScopeHandling.EMPTY);
    }

    protected void initialize() {
        super.initialize();
        this.m_Helper = new CallableActorHelper();
    }

    protected void reset() {
        super.reset();
        this.m_PipelineActor = null;
    }

    public void setPipeline(CallableActorReference value) {
        this.m_Pipeline = value;
        this.reset();
    }

    public CallableActorReference getPipeline() {
        return this.m_Pipeline;
    }

    public String pipelineTipText() {
        return "The name of the callable actor to use as pipeline for processing data.";
    }

    public void setScopeHandlingVariables(ScopeHandler.ScopeHandling value) {
        this.m_ScopeHandlingVariables = value;
        this.reset();
    }

    public ScopeHandler.ScopeHandling getScopeHandlingVariables() {
        return this.m_ScopeHandlingVariables;
    }

    public String scopeHandlingVariablesTipText() {
        return "Defines how variables are handled in the local scope; whether to start with empty set, a copy of the outer scope variables or share variables with the outer scope.";
    }

    public void setScopeHandlingStorage(ScopeHandler.ScopeHandling value) {
        this.m_ScopeHandlingStorage = value;
        this.reset();
    }

    public ScopeHandler.ScopeHandling getScopeHandlingStorage() {
        return this.m_ScopeHandlingStorage;
    }

    public String scopeHandlingStorageTipText() {
        return "Defines how storage is handled in the local scope; whether to start with empty set, a (deep) copy of the outer scope storage or share the storage with the outer scope.";
    }

    public Actor getCallableActor() {
        return this.m_PipelineActor;
    }

    protected String checkCompatibility() {
        return null;
    }

    protected String initPipeline() {
        String result = null;
        if (!this.m_PipelineActorInitialized) {
            List callables;
            this.m_PipelineActor = this.m_Helper.findCallableActorRecursive(this.m_FlowContext, this.getPipeline());
            result = this.m_PipelineActor == null ? "Couldn't find pipeline actor '" + this.getPipeline() + "'!" : (!ActorUtils.isTransformer((Actor)this.m_PipelineActor) ? "Pipeline actor '" + this.getPipeline() + "' is not a transformer!" : this.checkCompatibility());
            if (result == null && (callables = ActorUtils.enumerate((Actor)this.m_PipelineActor, (ActorFilter)new SuperclassOrInterface(AbstractCallableActor.class))).size() > 0) {
                result = "Using callable actors is not permitted as part of the pipeline! The following callable actors were found:\n";
                for (Actor callable : callables) {
                    result = result + "\n" + callable.getFullName();
                }
            }
            this.m_PipelineActorInitialized = true;
        } else if (this.m_PipelineActor == null) {
            result = "No pipeline actor available!";
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doProcess(Object input, MessageCollection errors) {
        Object result = null;
        String msg = this.initPipeline();
        if (msg != null) {
            errors.add(msg);
            return null;
        }
        LocalScopeTransformer scope = null;
        try {
            Actor pipeline = this.m_PipelineActor.shallowCopy();
            scope = new LocalScopeTransformer();
            scope.removeAll();
            scope.add(pipeline);
            scope.setScopeHandlingVariables(this.m_ScopeHandlingVariables);
            scope.setScopeHandlingStorage(this.m_ScopeHandlingStorage);
            scope.setParent(this.getFlowContext());
            msg = scope.setUp();
            if (msg != null) {
                errors.add("Failed to setup pipeline (" + this.getPipeline() + "):\n" + msg);
                Object var7_7 = null;
                return var7_7;
            }
            scope.input(new Token(input));
            msg = scope.execute();
            if (msg != null) {
                errors.add("Failed to execute pipeline (" + this.getPipeline() + "):\n" + msg);
                Object var7_8 = null;
                return var7_8;
            }
            if (scope.hasPendingOutput()) {
                result = scope.output().getPayload();
            }
            if (result == null) {
                errors.add("Pipeline generated no output (" + this.getPipeline() + ")!");
            }
        }
        catch (Exception e) {
            errors.add("Failed to process data: " + input, (Throwable)e);
        }
        finally {
            if (scope != null) {
                scope.cleanUp();
            }
        }
        return result;
    }
}

