/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.rest.flow;

import adams.core.MessageCollection;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.CallableActorUser;
import adams.flow.core.InputConsumer;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;
import adams.flow.rest.AbstractRESTPluginWithFlowContext;

public abstract class AbstractCallableTransformer<T>
extends AbstractRESTPluginWithFlowContext
implements CallableActorUser {
    private static final long serialVersionUID = -4960256014415499156L;
    protected CallableActorReference m_Transformer;
    protected transient Actor m_TransformerActor;
    protected boolean m_TransformerActorInitialized;
    protected CallableActorHelper m_Helper;

    protected String globalInfoBase() {
        return "Uses the specified callable transformer for processing the incoming data and sending back the resulting data.\nPlease note, that a callable transformer is executed in synchronized fashion and no other calls can be processed in the meantime.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("transformer", "transformer", (Object)new CallableActorReference());
    }

    protected void initialize() {
        super.initialize();
        this.m_Helper = new CallableActorHelper();
    }

    protected void reset() {
        super.reset();
        this.m_TransformerActor = null;
    }

    public void setTransformer(CallableActorReference value) {
        this.m_Transformer = value;
        this.reset();
    }

    public CallableActorReference getTransformer() {
        return this.m_Transformer;
    }

    public String transformerTipText() {
        return "The name of the callable actor to use as transformer for processing data.";
    }

    public Actor getCallableActor() {
        return this.m_TransformerActor;
    }

    protected String checkCompatibility() {
        return null;
    }

    protected String initTransformer() {
        String result = null;
        if (!this.m_TransformerActorInitialized) {
            this.m_TransformerActor = this.m_Helper.findCallableActorRecursive(this.m_FlowContext, this.getTransformer());
            result = this.m_TransformerActor == null ? "Couldn't find transformer actor '" + this.getTransformer() + "'!" : (!ActorUtils.isTransformer((Actor)this.m_TransformerActor) ? "Transformer actor '" + this.getTransformer() + "' is not a transformer!" : this.checkCompatibility());
            this.m_TransformerActorInitialized = true;
        } else if (this.m_TransformerActor == null) {
            result = "No transformer actor available!";
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doProcess(Object input, MessageCollection errors) {
        Object result = null;
        String msg = this.initTransformer();
        if (msg != null) {
            errors.add(msg);
            return null;
        }
        Actor actor = this.m_TransformerActor;
        synchronized (actor) {
            try {
                ((InputConsumer)this.m_TransformerActor).input(new Token(input));
                msg = this.m_TransformerActor.execute();
                if (msg != null) {
                    errors.add("Failed to execute transformer (" + this.getTransformer() + "):\n" + msg);
                    return null;
                }
                if (((OutputProducer)this.m_TransformerActor).hasPendingOutput()) {
                    result = ((OutputProducer)this.m_TransformerActor).output().getPayload();
                }
                if (result == null) {
                    errors.add("Transformer generated no output (" + this.getTransformer() + ")!");
                }
            }
            catch (Exception e) {
                errors.add("Failed to process data: " + input, (Throwable)e);
            }
        }
        return result;
    }
}

