/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.AdditionalInformationHandler;
import adams.core.Properties;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.db.LogEntry;
import adams.event.VariableChangeListener;
import adams.flow.core.Actor;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.CallableActorUser;
import adams.flow.core.Compatibility;
import adams.flow.core.InputConsumer;
import adams.flow.core.Token;
import adams.flow.rest.RESTProvider;
import adams.flow.rest.echo.EchoServer;
import adams.flow.standalone.AbstractStandalone;
import java.util.HashSet;

public class RESTServer
extends AbstractStandalone
implements CallableActorUser {
    private static final long serialVersionUID = 7347507489169005088L;
    protected RESTProvider m_WebService;
    protected CallableActorReference m_Log;
    protected Actor m_LogActor;
    protected CallableActorHelper m_Helper;

    public String globalInfo() {
        return "Runs a REST webservice.";
    }

    public String getAdditionalInformation() {
        StringBuilder result = new StringBuilder(super.getAdditionalInformation());
        if (this.m_WebService instanceof AdditionalInformationHandler) {
            result.append("\n\n");
            result.append("REST Service details:\n\n");
            result.append(((AdditionalInformationHandler)this.m_WebService).getAdditionalInformation());
        }
        return result.toString();
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("web-service", "webService", (Object)new EchoServer());
        this.m_OptionManager.add("log", "log", (Object)new CallableActorReference("unknown"));
    }

    protected void initialize() {
        super.initialize();
        this.m_Helper = new CallableActorHelper();
    }

    public void setWebService(RESTProvider value) {
        this.m_WebService = value;
        this.m_WebService.setFlowContext((Actor)this);
        this.reset();
    }

    public RESTProvider getWebService() {
        return this.m_WebService;
    }

    public String webServiceTipText() {
        return "The webservice to provide.";
    }

    public void setLog(CallableActorReference value) {
        this.m_Log = value;
        this.reset();
    }

    public CallableActorReference getLog() {
        return this.m_Log;
    }

    public String logTipText() {
        return "The name of the callable log actor to use (logging disabled if actor not found).";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"webService", this.m_WebService.getClass());
        result = result + " on ";
        result = this.m_WebService instanceof OptionHandler ? result + QuickInfoHelper.toString((OptionHandler)((OptionHandler)this.m_WebService), (String)"URL", (Object)this.m_WebService.getURL()) : result + this.m_WebService.getURL();
        result = result + " [logging to '";
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"log", (Object)this.getLog());
        result = result + "']";
        return result;
    }

    protected Actor findCallableActor() {
        return this.m_Helper.findCallableActorRecursive((Actor)this, this.getLog());
    }

    public boolean hasCallableActor() {
        return this.m_LogActor != null;
    }

    public Actor getCallableActor() {
        return this.m_LogActor;
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_LogActor = this.findCallableActor();
            if (this.m_LogActor == null) {
                String msg = "Couldn't find callable log actor '" + this.getLog() + "' - logging disabled!";
                this.getLogger().warning(msg);
            } else {
                Compatibility comp = new Compatibility();
                if (!comp.isCompatible(new Class[]{LogEntry.class}, ((InputConsumer)this.m_LogActor).accepts())) {
                    result = "Log actor '" + this.getLog() + "' must accept " + LogEntry.class.getName() + "!";
                }
                if (result == null) {
                    HashSet variables = this.findVariables(this.m_LogActor);
                    this.m_DetectedVariables.addAll(variables);
                    if (this.m_DetectedVariables.size() > 0) {
                        this.getVariables().addVariableChangeListener((VariableChangeListener)this);
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String msg, String id) {
        if (id != null && id.trim().length() == 0) {
            id = null;
        }
        if (this.m_LogActor == null) {
            this.getLogger().severe("LOG: " + (id == null ? "" : id + " - ") + msg);
            return;
        }
        Properties props = new Properties();
        props.setProperty("Errors", msg);
        if (id != null) {
            props.setProperty("ID", id);
        }
        LogEntry log = new LogEntry();
        log.setType("WebService");
        log.setSource(this.getFullName());
        log.setStatus("New");
        log.setMessage(props);
        try {
            String result;
            Actor actor = this.m_LogActor;
            synchronized (actor) {
                ((InputConsumer)this.m_LogActor).input(new Token((Object)log));
                result = this.m_LogActor.execute();
            }
            if (result != null) {
                this.getLogger().severe("Failed to log message:\n" + log + "\n" + result);
            }
        }
        catch (Exception e) {
            this.handleException("Failed to log message:\n" + log, e);
        }
    }

    protected String doExecute() {
        this.m_WebService.setFlowContext((Actor)this);
        return this.m_WebService.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wrapUp() {
        this.m_WebService.stop();
        if (this.m_LogActor != null) {
            Actor actor = this.m_LogActor;
            synchronized (actor) {
                this.m_LogActor.wrapUp();
            }
        }
        super.wrapUp();
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_WebService.cleanUp();
        if (this.m_LogActor != null) {
            this.m_LogActor.cleanUp();
            this.m_LogActor = null;
        }
    }
}

