/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.rest.interceptor;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.flow.rest.interceptor.outgoing.BaseLogging;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.LoggingMessage;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.io.CachedWriter;
import org.apache.cxf.io.DelegatingInputStream;
import org.apache.cxf.message.Message;

@MixedCopyright(copyright="Apache CXF", license=License.APACHE2, note="org.apache.cxf.interceptor.LoggingOutInterceptor#setupBuffer and org.apache.cxf.interceptor.AbstractLoggingInterceptor#writePayload and org.apache.cxf.interceptor.LoggingInInterceptor#logging")
public class InterceptorHelper {
    public static final String OUTGOING_BINARY_CONTENT_MESSAGE = "--- Binary Content ---";
    public static final String OUTGOING_LOG_SETUP = BaseLogging.class.getName() + ".log-setup";

    public static LoggingMessage setupOutgoingBuffer(Message message) {
        Object headers;
        String ct;
        String address;
        String httpMethod;
        String encoding;
        String id = (String)message.getExchange().get((Object)LoggingMessage.ID_KEY);
        if (id == null) {
            id = LoggingMessage.nextId();
            message.getExchange().put((Object)LoggingMessage.ID_KEY, (Object)id);
        }
        LoggingMessage buffer = new LoggingMessage("Outbound Message\n---------------------------", id);
        Integer responseCode = (Integer)message.get((Object)Message.RESPONSE_CODE);
        if (responseCode != null) {
            buffer.getResponseCode().append(responseCode);
        }
        if ((encoding = (String)message.get((Object)Message.ENCODING)) != null) {
            buffer.getEncoding().append(encoding);
        }
        if ((httpMethod = (String)message.get((Object)"org.apache.cxf.request.method")) != null) {
            buffer.getHttpMethod().append(httpMethod);
        }
        if ((address = (String)message.get((Object)Message.ENDPOINT_ADDRESS)) != null) {
            buffer.getAddress().append(address);
        }
        if ((ct = (String)message.get((Object)"Content-Type")) != null) {
            buffer.getContentType().append(ct);
        }
        if ((headers = message.get((Object)Message.PROTOCOL_HEADERS)) != null) {
            buffer.getHeader().append(headers);
        }
        return buffer;
    }

    public static void writeOutgoingPayload(StringBuilder builder, Message message, CachedOutputStream cos, String encoding, String contentType) throws Exception {
        if (contentType != null && contentType.indexOf("xml") >= 0 && contentType.toLowerCase().indexOf("multipart/related") < 0 && cos.size() > 0L) {
            Transformer serializer = TransformerFactory.newInstance().newTransformer();
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StringWriter swriter = new StringWriter();
            serializer.transform(new StreamSource(cos.getInputStream()), new StreamResult(swriter));
            builder.append(swriter.toString());
        } else if (StringUtils.isEmpty((String)encoding)) {
            cos.writeCacheTo(builder);
        } else {
            cos.writeCacheTo(builder, encoding);
        }
    }

    public static void writeIncomingPayload(StringBuilder builder, CachedOutputStream cos, String encoding, String contentType) throws Exception {
        if (contentType != null && contentType.indexOf("xml") >= 0 && contentType.toLowerCase().indexOf("multipart/related") < 0 && cos.size() > 0L) {
            Transformer serializer = TransformerFactory.newInstance().newTransformer();
            serializer.setOutputProperty("indent", "yes");
            serializer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            StringWriter swriter = new StringWriter();
            serializer.transform(new StreamSource(cos.getInputStream()), new StreamResult(swriter));
            builder.append(swriter.toString());
        } else if (StringUtils.isEmpty((String)encoding)) {
            cos.writeCacheTo(builder);
        } else {
            cos.writeCacheTo(builder, encoding);
        }
    }

    public static LoggingMessage writeIncomingMessage(Message message) {
        InputStream is;
        String ct;
        if (message.containsKey((Object)LoggingMessage.ID_KEY)) {
            return null;
        }
        LoggingMessage buffer = InterceptorHelper.setupIncomingBuffer(message);
        String encoding = (String)message.get((Object)Message.ENCODING);
        if (encoding != null) {
            buffer.getEncoding().append(encoding);
        }
        if ((ct = (String)message.get((Object)"Content-Type")) != null) {
            buffer.getContentType().append(ct);
        }
        if ((is = (InputStream)message.getContent(InputStream.class)) != null) {
            CachedOutputStream bos = new CachedOutputStream();
            try {
                InputStream bis = is instanceof DelegatingInputStream ? ((DelegatingInputStream)is).getInputStream() : is;
                IOUtils.copyAndCloseInput((InputStream)bis, (OutputStream)bos);
                bos.flush();
                bis = bos.getInputStream();
                if (is instanceof DelegatingInputStream) {
                    ((DelegatingInputStream)is).setInputStream(bis);
                } else {
                    message.setContent(InputStream.class, (Object)bis);
                }
                if (bos.getTempFile() != null) {
                    buffer.getMessage().append("\nMessage (saved to tmp file):\n");
                    buffer.getMessage().append("Filename: " + bos.getTempFile().getAbsolutePath() + "\n");
                }
                InterceptorHelper.writeIncomingPayload(buffer.getPayload(), bos, encoding, ct);
                bos.close();
            }
            catch (Exception e) {
                throw new Fault((Throwable)e);
            }
        }
        Reader reader = (Reader)message.getContent(Reader.class);
        if (reader != null) {
            try {
                CachedWriter writer = new CachedWriter();
                IOUtils.copyAndCloseInput((Reader)reader, (Writer)writer);
                message.setContent(Reader.class, (Object)writer.getReader());
                if (writer.getTempFile() != null) {
                    buffer.getMessage().append("\nMessage (saved to tmp file):\n");
                    buffer.getMessage().append("Filename: " + writer.getTempFile().getAbsolutePath() + "\n");
                }
                writer.writeCacheTo(buffer.getPayload());
            }
            catch (Exception e) {
                throw new Fault((Throwable)e);
            }
        }
        return buffer;
    }

    public static LoggingMessage setupIncomingBuffer(Message message) {
        String uri;
        Object headers;
        String ct;
        String httpMethod;
        String encoding;
        String id = (String)message.getExchange().get((Object)LoggingMessage.ID_KEY);
        if (id == null) {
            id = LoggingMessage.nextId();
            message.getExchange().put((Object)LoggingMessage.ID_KEY, (Object)id);
        }
        message.put((Object)LoggingMessage.ID_KEY, (Object)id);
        LoggingMessage buffer = new LoggingMessage("Inbound Message\n----------------------------", id);
        Integer responseCode = (Integer)message.get((Object)Message.RESPONSE_CODE);
        if (responseCode != null) {
            buffer.getResponseCode().append(responseCode);
        }
        if ((encoding = (String)message.get((Object)Message.ENCODING)) != null) {
            buffer.getEncoding().append(encoding);
        }
        if ((httpMethod = (String)message.get((Object)"org.apache.cxf.request.method")) != null) {
            buffer.getHttpMethod().append(httpMethod);
        }
        if ((ct = (String)message.get((Object)"Content-Type")) != null) {
            buffer.getContentType().append(ct);
        }
        if ((headers = message.get((Object)Message.PROTOCOL_HEADERS)) != null) {
            buffer.getHeader().append(headers);
        }
        if ((uri = (String)message.get((Object)"org.apache.cxf.request.url")) != null) {
            buffer.getAddress().append(uri);
            String query = (String)message.get((Object)Message.QUERY_STRING);
            if (query != null) {
                buffer.getAddress().append("?").append(query);
            }
        }
        return buffer;
    }
}

