/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.rest.interceptor.incoming;

import adams.flow.control.StorageName;
import adams.flow.core.NullToken;
import adams.flow.rest.interceptor.incoming.AbstractInInterceptorGenerator;
import adams.flow.rest.interceptor.incoming.Enqueue;

public class EnqueueGenerator
extends AbstractInInterceptorGenerator<Enqueue> {
    private static final long serialVersionUID = -8109018608359183466L;
    protected StorageName m_StorageName;
    protected boolean m_EnqueueMessage;

    public String globalInfo() {
        return "Generates an " + Enqueue.class.getName() + " instance.\nEnqueues either the full message or just a " + NullToken.class.getName() + " in the specified queue.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", (Object)new StorageName("queue"));
        this.m_OptionManager.add("enqueue-message", "enqueueMessage", (Object)false);
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name of the queue to send data to.";
    }

    public void setEnqueueMessage(boolean value) {
        this.m_EnqueueMessage = value;
        this.reset();
    }

    public boolean getEnqueueMessage() {
        return this.m_EnqueueMessage;
    }

    public String enqueueMessageTipText() {
        return "If enabled, the complete message gets enqueued, otherwise just a " + NullToken.class.getName() + ".";
    }

    @Override
    protected Enqueue doGenerate() {
        Enqueue result = new Enqueue();
        result.setStorageName(this.getStorageName());
        result.setEnqueueMessage(this.getEnqueueMessage());
        return result;
    }
}

