/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.rest.interceptor.outgoing;

import adams.core.CleanUpHandler;
import adams.core.option.AbstractOptionHandler;
import adams.flow.rest.interceptor.outgoing.AbstractOutInterceptor;

public abstract class AbstractOutInterceptorGenerator<T extends AbstractOutInterceptor>
extends AbstractOptionHandler
implements CleanUpHandler {
    private static final long serialVersionUID = -8741445331354712393L;
    protected boolean m_Enabled;
    protected transient T m_LastInterceptor;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("enabled", "enabled", (Object)true);
    }

    public void setEnabled(boolean value) {
        this.m_Enabled = value;
        this.reset();
    }

    public boolean getEnabled() {
        return this.m_Enabled;
    }

    public String enabledTipText() {
        return "Interceptor gets only instantiated if the generator is enabled.";
    }

    protected void check() {
    }

    protected abstract T doGenerate();

    public T generate() {
        if (!this.m_Enabled) {
            return null;
        }
        this.m_LastInterceptor = null;
        this.check();
        T result = this.doGenerate();
        if (result != null) {
            ((AbstractOutInterceptor)((Object)result)).setLoggingLevel(this.getLoggingLevel());
        }
        this.m_LastInterceptor = result;
        return result;
    }

    public boolean hasLastInterceptor() {
        return this.m_LastInterceptor != null;
    }

    public T getLastInterceptor() {
        return this.m_LastInterceptor;
    }

    public void cleanUp() {
        this.m_LastInterceptor = null;
    }
}

