/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.rest.interceptor.outgoing;

import adams.flow.control.StorageName;
import adams.flow.core.Actor;
import adams.flow.core.NullToken;
import adams.flow.core.QueueHelper;
import adams.flow.rest.interceptor.InterceptorHelper;
import adams.flow.rest.interceptor.InterceptorWithActor;
import adams.flow.rest.interceptor.outgoing.AbstractOutInterceptor;
import adams.flow.rest.interceptor.outgoing.AbstractOutgoingCallback;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.LoggingMessage;
import org.apache.cxf.io.CacheAndWriteOutputStream;
import org.apache.cxf.io.CachedOutputStreamCallback;
import org.apache.cxf.message.Message;

public class Enqueue
extends AbstractOutInterceptor
implements InterceptorWithActor {
    protected StorageName m_StorageName;
    protected boolean m_EnqueueMessage;
    protected Actor m_Actor;

    public Enqueue() {
        super("send");
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_StorageName = new StorageName("queue");
        this.m_EnqueueMessage = false;
        this.m_Actor = null;
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public void setEnqueueMessage(boolean value) {
        this.m_EnqueueMessage = value;
    }

    public boolean getEnqueueMessage() {
        return this.m_EnqueueMessage;
    }

    @Override
    public void setActor(Actor value) {
        this.m_Actor = value;
    }

    @Override
    public Actor getActor() {
        return this.m_Actor;
    }

    public void handleMessage(Message message) throws Fault {
        if (this.m_Actor == null) {
            return;
        }
        boolean hasLogged = message.containsKey((Object)InterceptorHelper.OUTGOING_LOG_SETUP);
        if (hasLogged) {
            return;
        }
        if (this.m_EnqueueMessage) {
            OutputStream os = (OutputStream)message.getContent(OutputStream.class);
            Writer iowriter = (Writer)message.getContent(Writer.class);
            if (os == null && iowriter == null) {
                return;
            }
            message.put((Object)InterceptorHelper.OUTGOING_LOG_SETUP, (Object)Boolean.TRUE);
            if (os != null) {
                CacheAndWriteOutputStream newOut = new CacheAndWriteOutputStream(os);
                message.setContent(OutputStream.class, (Object)newOut);
                newOut.registerCallback((CachedOutputStreamCallback)new AbstractOutgoingCallback(message, os){

                    @Override
                    protected void write(LoggingMessage buffer) {
                        if (Enqueue.this.isLoggingEnabled()) {
                            Enqueue.this.getLogger().info(Enqueue.this.m_StorageName + ": " + buffer);
                        }
                        QueueHelper.enqueue((Actor)Enqueue.this.m_Actor, (StorageName)Enqueue.this.m_StorageName, (Object)("" + buffer));
                    }
                });
            }
        } else {
            if (this.isLoggingEnabled()) {
                this.getLogger().info(this.m_StorageName + ": null token");
            }
            QueueHelper.enqueue((Actor)this.m_Actor, (StorageName)this.m_StorageName, (Object)new NullToken());
        }
    }
}

