/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.rest;

import adams.core.AdditionalInformationHandler;
import adams.core.ObjectCopyHelper;
import adams.core.Utils;
import adams.flow.core.FlowContextHandler;
import adams.flow.rest.AbstractRESTProvider;
import adams.flow.rest.RESTPlugin;
import adams.flow.rest.RESTUtils;
import java.util.Arrays;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;

public class GenericServer
extends AbstractRESTProvider
implements AdditionalInformationHandler {
    private static final long serialVersionUID = 6759800194384027943L;
    protected RESTPlugin[] m_Plugins;

    public String globalInfo() {
        return "Generic REST service provider, which allows you to assemble the REST plugins that should make up the service.\nAutomatically sets the flow context of plugins, if they should implement the " + Utils.classToString(FlowContextHandler.class) + " interface.";
    }

    public String getAdditionalInformation() {
        if (this.m_Plugins.length == 0) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (RESTPlugin plugin : this.m_Plugins) {
            if (result.length() > 0) {
                result.append("\n");
            }
            result.append(RESTUtils.getAdditionalInformation(plugin));
        }
        return result.toString();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("plugin", "plugins", (Object)this.getDefaultPlugins());
    }

    protected RESTPlugin[] getDefaultPlugins() {
        return new RESTPlugin[0];
    }

    public void setPlugins(RESTPlugin[] value) {
        this.m_Plugins = value;
        this.reset();
    }

    public RESTPlugin[] getPlugins() {
        return this.m_Plugins;
    }

    public String pluginsTipText() {
        return "The plugins that make up the REST service.";
    }

    @Override
    public String getDefaultURL() {
        return "http://localhost:8080/";
    }

    protected void configurePlugins(RESTPlugin[] plugins) {
        for (int i = 0; i < plugins.length; ++i) {
            if (!(plugins[i] instanceof FlowContextHandler)) continue;
            ((FlowContextHandler)plugins[i]).setFlowContext(this.getFlowContext());
        }
    }

    @Override
    protected Server doStart() throws Exception {
        JAXRSServerFactoryBean factory = new JAXRSServerFactoryBean();
        this.configureInterceptors(factory);
        RESTPlugin[] plugins = (RESTPlugin[])ObjectCopyHelper.copyObject((Object)this.m_Plugins);
        this.configurePlugins(plugins);
        factory.setServiceBeans(Arrays.asList(plugins));
        factory.setAddress(this.getURL());
        this.configureTLS(factory);
        return factory.create();
    }
}

