/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.rest.echo;

import adams.flow.rest.AbstractRESTClientSink;
import adams.flow.rest.echo.EchoServer;
import com.github.fracpete.requests4j.Requests;
import com.github.fracpete.requests4j.response.BasicResponse;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class EchoClientSink
extends AbstractRESTClientSink<String> {
    private static final long serialVersionUID = -4005180585673812548L;
    protected String m_RequestData;

    public String globalInfo() {
        return "Client (sink) for Echo REST service. Check console for result of webservice.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String.class};
    }

    @Override
    public void setRequestData(String value) {
        this.m_RequestData = value;
    }

    @Override
    protected void doQuery() throws Exception {
        String url = this.getUseAlternativeURL() ? this.getAlternativeURL() : new EchoServer().getDefaultURL();
        BasicResponse r = Requests.get((String)(url = url + "echo/" + URLEncoder.encode(this.m_RequestData, "UTF-8"))).execute();
        if (r.statusCode() == 200) {
            this.getLogger().info(URLDecoder.decode(r.text(), "UTF-8"));
        } else {
            this.m_LastError = r.statusCode() + ": " + r.statusMessage();
        }
    }
}

