/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.rest.interceptor.incoming;

import adams.core.logging.Logger;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingLevel;
import adams.core.logging.LoggingLevelHandler;
import adams.core.logging.LoggingSupporter;
import java.util.logging.Level;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public abstract class AbstractInInterceptor
extends AbstractPhaseInterceptor<Message>
implements LoggingSupporter,
LoggingLevelHandler {
    protected LoggingLevel m_LoggingLevel;
    protected transient Logger m_Logger;

    protected AbstractInInterceptor(String phase) {
        super(phase);
        this.initializeLogging();
        this.initialize();
    }

    protected void initialize() {
    }

    protected void initializeLogging() {
        this.m_LoggingLevel = LoggingHelper.getLoggingLevel(((Object)((Object)this)).getClass());
    }

    protected void configureLogger() {
        this.m_Logger = LoggingHelper.getLogger(((Object)((Object)this)).getClass());
        this.m_Logger.setLevel(this.m_LoggingLevel.getLevel());
    }

    public synchronized Logger getLogger() {
        if (this.m_Logger == null) {
            this.configureLogger();
        }
        return this.m_Logger;
    }

    public synchronized void setLoggingLevel(LoggingLevel value) {
        this.m_LoggingLevel = value;
        this.m_Logger = null;
    }

    public LoggingLevel getLoggingLevel() {
        return this.m_LoggingLevel;
    }

    public boolean isLoggingEnabled() {
        return LoggingHelper.isAtLeast((Level)this.m_LoggingLevel.getLevel(), (Level)Level.CONFIG);
    }

    public boolean isInfoLoggingEnabled() {
        return LoggingHelper.isAtLeast((Level)this.m_LoggingLevel.getLevel(), (Level)Level.INFO);
    }
}

