/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.base.BaseObject;
import adams.core.base.BaseString;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.source.AbstractSimpleSource;
import com.github.fracpete.processoutput4j.output.CollectingProcessOutput;
import com.github.fracpete.rsync4j.RSync;
import com.github.fracpete.rsync4j.core.Binaries;
import java.util.List;

public class SimpleRSync
extends AbstractSimpleSource {
    private static final long serialVersionUID = -2922477251211046117L;
    protected String m_Source;
    protected String m_Destination;
    protected boolean m_OutputCommandline;
    protected boolean m_Verbose;
    protected boolean m_Quiet;
    protected boolean m_Checksum;
    protected boolean m_Archive;
    protected boolean m_Recursive;
    protected boolean m_Relative;
    protected boolean m_Perms;
    protected boolean m_Executability;
    protected boolean m_Times;
    protected boolean m_DryRun;
    protected String m_Rsh;
    protected String m_RsyncPath;
    protected boolean m_Delete;
    protected BaseString[] m_Exclude;
    protected PlaceholderFile m_ExcludeFrom;
    protected BaseString[] m_Include;
    protected PlaceholderFile m_IncludeFrom;
    protected PlaceholderFile m_FilesFrom;
    protected BaseString[] m_Filter;
    protected int m_MaxTime;

    public String globalInfo() {
        return "An rsync wrapper with a reduced set of options.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("source", "source", (Object)"");
        this.m_OptionManager.add("destination", "destination", (Object)"");
        this.m_OptionManager.add("outputCommandline", "outputCommandline", (Object)false);
        this.m_OptionManager.add("verbose", "verbose", (Object)false);
        this.m_OptionManager.add("quiet", "quiet", (Object)false);
        this.m_OptionManager.add("checksum", "checksum", (Object)false);
        this.m_OptionManager.add("archive", "archive", (Object)false);
        this.m_OptionManager.add("recursive", "recursive", (Object)false);
        this.m_OptionManager.add("relative", "relative", (Object)false);
        this.m_OptionManager.add("perms", "perms", (Object)false);
        this.m_OptionManager.add("executability", "executability", (Object)false);
        this.m_OptionManager.add("times", "times", (Object)false);
        this.m_OptionManager.add("dry_run", "dryRun", (Object)false);
        this.m_OptionManager.add("rsh", "rsh", (Object)"");
        this.m_OptionManager.add("rsync_path", "rsyncPath", (Object)"");
        this.m_OptionManager.add("delete", "delete", (Object)false);
        this.m_OptionManager.add("exclude", "exclude", (Object)new BaseString[0]);
        this.m_OptionManager.add("exclude_from", "excludeFrom", (Object)new PlaceholderFile());
        this.m_OptionManager.add("include", "include", (Object)new BaseString[0]);
        this.m_OptionManager.add("include_from", "includeFrom", (Object)new PlaceholderFile());
        this.m_OptionManager.add("files_from", "filesFrom", (Object)new PlaceholderFile());
        this.m_OptionManager.add("filter", "filter", (Object)new BaseString[0]);
        this.m_OptionManager.add("max_time", "maxTime", (Object)-1, (Number)-1, null);
    }

    public void setSource(String value) {
        this.m_Source = Binaries.convertPath((String)value);
        this.reset();
    }

    public String getSource() {
        return this.m_Source;
    }

    public String sourceTipText() {
        return "The local or remote source path (path or [user@]host:path)";
    }

    public void setDestination(String value) {
        this.m_Destination = Binaries.convertPath((String)value);
        this.reset();
    }

    public String getDestination() {
        return this.m_Destination;
    }

    public String destinationTipText() {
        return "The local or remote destination path (path or [user@]host:path)";
    }

    public void setOutputCommandline(boolean value) {
        this.m_OutputCommandline = value;
        this.reset();
    }

    public boolean getOutputCommandline() {
        return this.m_OutputCommandline;
    }

    public String outputCommandlineTipText() {
        return "output the command-line generated for the rsync binary";
    }

    public boolean isVerbose() {
        return this.m_Verbose;
    }

    public void setVerbose(boolean value) {
        this.m_Verbose = value;
        this.reset();
    }

    public String verboseTipText() {
        return "increase verbosity";
    }

    public boolean isQuiet() {
        return this.m_Quiet;
    }

    public void setQuiet(boolean value) {
        this.m_Quiet = value;
        this.reset();
    }

    public String quietTipText() {
        return "suppress non-error messages";
    }

    public boolean isChecksum() {
        return this.m_Checksum;
    }

    public void setChecksum(boolean value) {
        this.m_Checksum = value;
        this.reset();
    }

    public String checksumTipText() {
        return "skip based on checksum, not mod-time & size";
    }

    public boolean isArchive() {
        return this.m_Archive;
    }

    public void setArchive(boolean value) {
        this.m_Archive = value;
        this.reset();
    }

    public String archiveTipText() {
        return "archive mode; equals -rlptgoD (no -H,-A,-X)";
    }

    public boolean isRecursive() {
        return this.m_Recursive;
    }

    public void setRecursive(boolean value) {
        this.m_Recursive = value;
        this.reset();
    }

    public String recursiveTipText() {
        return "recurse into directories";
    }

    public boolean isRelative() {
        return this.m_Relative;
    }

    public void setRelative(boolean value) {
        this.m_Relative = value;
        this.reset();
    }

    public String relativeTipText() {
        return "use relative path names";
    }

    public boolean isPerms() {
        return this.m_Perms;
    }

    public void setPerms(boolean value) {
        this.m_Perms = value;
        this.reset();
    }

    public String permsTipText() {
        return "preserve permissions";
    }

    public boolean isExecutability() {
        return this.m_Executability;
    }

    public void setExecutability(boolean value) {
        this.m_Executability = value;
        this.reset();
    }

    public String executabilityTipText() {
        return "preserve the file's executability";
    }

    public boolean isTimes() {
        return this.m_Times;
    }

    public void setTimes(boolean value) {
        this.m_Times = value;
        this.reset();
    }

    public String timesTipText() {
        return "preserve modification times";
    }

    public boolean isDryRun() {
        return this.m_DryRun;
    }

    public void setDryRun(boolean value) {
        this.m_DryRun = value;
        this.reset();
    }

    public String dryRunTipText() {
        return "perform a trial run with no changes made";
    }

    public String getRsh() {
        return this.m_Rsh;
    }

    public void setRsh(String value) {
        this.m_Rsh = value;
        this.reset();
    }

    public String rshTipText() {
        return "specify the remote shell to use";
    }

    public String getRsyncPath() {
        return this.m_RsyncPath;
    }

    public void setRsyncPath(String value) {
        this.m_RsyncPath = value;
        this.reset();
    }

    public String rsyncPathTipText() {
        return "specify the rsync to run on the remote machine";
    }

    public boolean isDelete() {
        return this.m_Delete;
    }

    public void setDelete(boolean value) {
        this.m_Delete = value;
        this.reset();
    }

    public String deleteTipText() {
        return "delete extraneous files from destination dirs";
    }

    public BaseString[] getExclude() {
        return this.m_Exclude;
    }

    public void setExclude(BaseString[] value) {
        this.m_Exclude = value;
        this.reset();
    }

    public String excludeTipText() {
        return "exclude files matching PATTERN";
    }

    public PlaceholderFile getExcludeFrom() {
        return this.m_ExcludeFrom;
    }

    public void setExcludeFrom(PlaceholderFile value) {
        this.m_ExcludeFrom = value;
        this.reset();
    }

    public String excludeFromTipText() {
        return "read exclude patterns from FILE";
    }

    public BaseString[] getInclude() {
        return this.m_Include;
    }

    public void setInclude(BaseString[] value) {
        this.m_Include = value;
        this.reset();
    }

    public String includeTipText() {
        return "include files matching PATTERN";
    }

    public PlaceholderFile getIncludeFrom() {
        return this.m_IncludeFrom;
    }

    public void setIncludeFrom(PlaceholderFile value) {
        this.m_IncludeFrom = value;
        this.reset();
    }

    public String includeFromTipText() {
        return "read include patterns from FILE";
    }

    public PlaceholderFile getFilesFrom() {
        return this.m_FilesFrom;
    }

    public void setFilesFrom(PlaceholderFile value) {
        this.m_FilesFrom = value;
        this.reset();
    }

    public String filesFromTipText() {
        return "read list of source-file names from FILE";
    }

    public BaseString[] getFilter() {
        return this.m_Filter;
    }

    public void setFilter(BaseString[] value) {
        this.m_Filter = value;
        this.reset();
    }

    public String filterTipText() {
        return "add a file-filtering RULE";
    }

    public int getMaxTime() {
        return this.m_MaxTime;
    }

    public void setMaxTime(int value) {
        if (this.getOptionManager().isValid("maxTime", (Number)value)) {
            this.m_MaxTime = value;
            this.reset();
        }
    }

    public String maxTimeTipText() {
        return "time out in seconds, stopping rsync process once exceeded, ignored if less than 1";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"source", (Object)(this.m_Source.isEmpty() ? "-none-" : this.m_Source), (String)"src: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"destination", (Object)(this.m_Destination.isEmpty() ? "-none-" : this.m_Destination), (String)", dst: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"recursive", (boolean)this.m_Recursive, (String)"recursive", (String)", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"dryRun", (boolean)this.m_DryRun, (String)"dry-run", (String)", ");
        return result;
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            CollectingProcessOutput output;
            RSync rsync = new RSync();
            rsync.outputCommandline(this.m_OutputCommandline);
            rsync.verbose(this.m_Verbose);
            rsync.quiet(this.m_Quiet);
            rsync.checksum(this.m_Checksum);
            rsync.archive(this.m_Archive);
            rsync.recursive(this.m_Recursive);
            rsync.relative(this.m_Relative);
            rsync.perms(this.m_Perms);
            rsync.executability(this.m_Executability);
            rsync.times(this.m_Times);
            rsync.dryRun(this.m_DryRun);
            rsync.rsh(this.m_Rsh);
            rsync.rsyncPath(this.m_RsyncPath);
            rsync.delete(this.m_Delete);
            rsync.exclude(BaseObject.toStringArray((BaseObject[])this.m_Exclude));
            if (!this.m_ExcludeFrom.isDirectory()) {
                rsync.excludeFrom(new String[]{this.m_ExcludeFrom.getAbsolutePath()});
            }
            rsync.include(BaseObject.toStringArray((BaseObject[])this.m_Include));
            if (!this.m_IncludeFrom.isDirectory()) {
                rsync.includeFrom(new String[]{this.m_IncludeFrom.getAbsolutePath()});
            }
            if (!this.m_FilesFrom.isDirectory()) {
                rsync.filesFrom(this.m_FilesFrom.getAbsolutePath());
            }
            rsync.include(BaseObject.toStringArray((BaseObject[])this.m_Filter));
            rsync.maxTime(this.m_MaxTime);
            rsync.source(this.m_Source);
            rsync.destination(this.m_Destination);
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Rsync:\n" + Utils.flatten((List)rsync.commandLineArgs(), (String)" "));
            }
            this.m_OutputToken = (output = rsync.execute()).getExitCode() > 0 ? new Token((Object)output.getStdErr()) : new Token((Object)output.getStdOut());
        }
        catch (Exception e) {
            result = this.handleException("Failed to execute rsync!", e);
        }
        return result;
    }
}

