/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.base.BaseObject;
import adams.core.base.BaseString;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.source.AbstractBufferingSource;
import com.github.fracpete.processoutput4j.core.StreamingProcessOutputType;
import com.github.fracpete.processoutput4j.core.StreamingProcessOwner;
import com.github.fracpete.processoutput4j.output.StreamingProcessOutput;
import com.github.fracpete.rsync4j.core.Binaries;
import java.util.List;

public class RSync
extends AbstractBufferingSource
implements StreamingProcessOwner {
    private static final long serialVersionUID = 5033321049882638158L;
    protected String m_Source;
    protected String m_Destination;
    protected boolean m_OutputCommandline;
    protected boolean m_Verbose;
    protected String m_Info;
    protected String m_Debug;
    protected boolean m_Msgs2stderr;
    protected boolean m_Quiet;
    protected boolean m_NoMotd;
    protected boolean m_Checksum;
    protected boolean m_Archive;
    protected boolean m_Recursive;
    protected boolean m_Relative;
    protected boolean m_NoImpliedDirs;
    protected boolean m_Backup;
    protected String m_BackupDir;
    protected String m_Suffix;
    protected boolean m_Update;
    protected boolean m_Inplace;
    protected boolean m_Append;
    protected boolean m_AppendVerify;
    protected boolean m_Dirs;
    protected boolean m_Links;
    protected boolean m_CopyLinks;
    protected boolean m_CopyUnsafeLinks;
    protected boolean m_SafeLinks;
    protected boolean m_MungeLinks;
    protected boolean m_CopyDirlinks;
    protected boolean m_KeepDirlinks;
    protected boolean m_HardLinks;
    protected boolean m_Perms;
    protected boolean m_Executability;
    protected String m_Chmod;
    protected boolean m_Xattrs;
    protected boolean m_Owner;
    protected boolean m_Group;
    protected boolean m_Devices;
    protected boolean m_Specials;
    protected boolean m_Times;
    protected boolean m_OmitDirTimes;
    protected boolean m_OmitLinkTimes;
    protected boolean m_Super_;
    protected boolean m_FakeSuper;
    protected boolean m_Sparse;
    protected boolean m_Preallocate;
    protected boolean m_DryRun;
    protected boolean m_WholeFile;
    protected boolean m_OneFileSystem;
    protected String m_BlockSize;
    protected String m_Rsh;
    protected String m_RsyncPath;
    protected boolean m_Existing;
    protected boolean m_IgnoreExisting;
    protected boolean m_RemoveSourceFiles;
    protected boolean m_Delete;
    protected boolean m_DeleteBefore;
    protected boolean m_DeleteDuring;
    protected boolean m_DeleteDelay;
    protected boolean m_DeleteAfter;
    protected boolean m_DeleteExcluded;
    protected boolean m_IgnoreMissingArgs;
    protected boolean m_DeleteMissingArgs;
    protected boolean m_IgnoreErrors;
    protected boolean m_Force;
    protected int m_MaxDelete;
    protected String m_MaxSize;
    protected String m_MinSize;
    protected boolean m_Partial;
    protected String m_PartialDir;
    protected boolean m_DelayUpdates;
    protected boolean m_PruneEmptyDirs;
    protected boolean m_NumericIds;
    protected String m_Usermap;
    protected String m_Groupmap;
    protected String m_Chown;
    protected int m_Timeout;
    protected int m_Contimeout;
    protected boolean m_IgnoreTimes;
    protected String m_RemoteOption;
    protected boolean m_SizeOnly;
    protected int m_ModifyWindow;
    protected String m_TempDir;
    protected boolean m_Fuzzy;
    protected BaseString[] m_CompareDest;
    protected BaseString[] m_CopyDest;
    protected BaseString[] m_LinkDest;
    protected boolean m_Compress;
    protected int m_CompressLevel;
    protected String m_SkipCompress;
    protected boolean m_CvsExclude;
    protected BaseString[] m_Filter;
    protected BaseString[] m_Exclude;
    protected PlaceholderFile m_ExcludeFrom;
    protected BaseString[] m_Include;
    protected PlaceholderFile m_IncludeFrom;
    protected PlaceholderFile m_FilesFrom;
    protected boolean m_From0;
    protected boolean m_ProtectArgs;
    protected String m_Address;
    protected int m_Port;
    protected String m_Sockopts;
    protected boolean m_BlockingIO;
    protected boolean m_Stats;
    protected boolean m_EightBitOutput;
    protected boolean m_HumanReadable;
    protected boolean m_Progress;
    protected boolean m_ItemizeChanges;
    protected String m_OutFormat;
    protected PlaceholderFile m_LogFile;
    protected String m_LogFileFormat;
    protected String m_PasswordFile;
    protected boolean m_ListOnly;
    protected String m_Bwlimit;
    protected String m_Outbuf;
    protected PlaceholderFile m_WriteBatch;
    protected PlaceholderFile m_OnlyWriteBatch;
    protected PlaceholderFile m_ReadBatch;
    protected int m_Protocol;
    protected String m_Iconv;
    protected int m_ChecksumSeed;
    protected boolean m_Ipv4;
    protected boolean m_Ipv6;
    protected boolean m_Version;
    protected int m_MaxTime;
    protected String m_PrefixStdOut;
    protected String m_PrefixStdErr;

    public String globalInfo() {
        return "Supports synchronization using rsync.\nIn case of an error, the stderr output is forwarded, otherwise stdout output.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("source", "source", (Object)"");
        this.m_OptionManager.add("destination", "destination", (Object)"");
        this.m_OptionManager.add("outputCommandline", "outputCommandline", (Object)false);
        this.m_OptionManager.add("verbose", "verbose", (Object)false);
        this.m_OptionManager.add("info", "info", (Object)"");
        this.m_OptionManager.add("debug", "debug", (Object)"");
        this.m_OptionManager.add("msgs2stderr", "msgs2stderr", (Object)false);
        this.m_OptionManager.add("quiet", "quiet", (Object)false);
        this.m_OptionManager.add("no_motd", "noMotd", (Object)false);
        this.m_OptionManager.add("checksum", "checksum", (Object)false);
        this.m_OptionManager.add("archive", "archive", (Object)false);
        this.m_OptionManager.add("recursive", "recursive", (Object)false);
        this.m_OptionManager.add("relative", "relative", (Object)false);
        this.m_OptionManager.add("no_implied_dirs", "noImpliedDirs", (Object)false);
        this.m_OptionManager.add("backup", "backup", (Object)false);
        this.m_OptionManager.add("backup_dir", "backupDir", (Object)"");
        this.m_OptionManager.add("suffix", "suffix", (Object)"");
        this.m_OptionManager.add("update", "update", (Object)false);
        this.m_OptionManager.add("inplace", "inplace", (Object)false);
        this.m_OptionManager.add("append", "append", (Object)false);
        this.m_OptionManager.add("append_verify", "appendVerify", (Object)false);
        this.m_OptionManager.add("dirs", "dirs", (Object)false);
        this.m_OptionManager.add("links", "links", (Object)false);
        this.m_OptionManager.add("copy_links", "copyLinks", (Object)false);
        this.m_OptionManager.add("copy_unsafe_links", "copyUnsafeLinks", (Object)false);
        this.m_OptionManager.add("safe_links", "safeLinks", (Object)false);
        this.m_OptionManager.add("munge_links", "mungeLinks", (Object)false);
        this.m_OptionManager.add("copy_dirlinks", "copyDirlinks", (Object)false);
        this.m_OptionManager.add("keep_dirlinks", "keepDirlinks", (Object)false);
        this.m_OptionManager.add("hard_links", "hardLinks", (Object)false);
        this.m_OptionManager.add("perms", "perms", (Object)false);
        this.m_OptionManager.add("executability", "executability", (Object)false);
        this.m_OptionManager.add("chmod", "chmod", (Object)"");
        this.m_OptionManager.add("xattrs", "xattrs", (Object)false);
        this.m_OptionManager.add("owner", "owner", (Object)false);
        this.m_OptionManager.add("group", "group", (Object)false);
        this.m_OptionManager.add("devices", "devices", (Object)false);
        this.m_OptionManager.add("specials", "specials", (Object)false);
        this.m_OptionManager.add("times", "times", (Object)false);
        this.m_OptionManager.add("omit_dir_times", "omitDirTimes", (Object)false);
        this.m_OptionManager.add("omit_link_times", "omitLinkTimes", (Object)false);
        this.m_OptionManager.add("super_", "super_", (Object)false);
        this.m_OptionManager.add("fake_super", "fakeSuper", (Object)false);
        this.m_OptionManager.add("sparse", "sparse", (Object)false);
        this.m_OptionManager.add("preallocate", "preallocate", (Object)false);
        this.m_OptionManager.add("dry_run", "dryRun", (Object)false);
        this.m_OptionManager.add("whole_file", "wholeFile", (Object)false);
        this.m_OptionManager.add("one_file_system", "oneFileSystem", (Object)false);
        this.m_OptionManager.add("block_size", "blockSize", (Object)"");
        this.m_OptionManager.add("rsh", "rsh", (Object)"");
        this.m_OptionManager.add("rsync_path", "rsyncPath", (Object)"");
        this.m_OptionManager.add("existing", "existing", (Object)false);
        this.m_OptionManager.add("ignore_existing", "ignoreExisting", (Object)false);
        this.m_OptionManager.add("remove_source_files", "removeSourceFiles", (Object)false);
        this.m_OptionManager.add("delete", "delete", (Object)false);
        this.m_OptionManager.add("delete_before", "deleteBefore", (Object)false);
        this.m_OptionManager.add("delete_during", "deleteDuring", (Object)false);
        this.m_OptionManager.add("delete_delay", "deleteDelay", (Object)false);
        this.m_OptionManager.add("delete_after", "deleteAfter", (Object)false);
        this.m_OptionManager.add("delete_excluded", "deleteExcluded", (Object)false);
        this.m_OptionManager.add("ignore_missing_args", "ignoreMissingArgs", (Object)false);
        this.m_OptionManager.add("delete_missing_args", "deleteMissingArgs", (Object)false);
        this.m_OptionManager.add("ignore_errors", "ignoreErrors", (Object)false);
        this.m_OptionManager.add("force", "force", (Object)false);
        this.m_OptionManager.add("max_delete", "maxDelete", (Object)-1);
        this.m_OptionManager.add("max_size", "maxSize", (Object)"");
        this.m_OptionManager.add("min_size", "minSize", (Object)"");
        this.m_OptionManager.add("partial", "partial", (Object)false);
        this.m_OptionManager.add("partial_dir", "partialDir", (Object)"");
        this.m_OptionManager.add("delay_updates", "delayUpdates", (Object)false);
        this.m_OptionManager.add("prune_empty_dirs", "pruneEmptyDirs", (Object)false);
        this.m_OptionManager.add("numeric_ids", "numericIds", (Object)false);
        this.m_OptionManager.add("usermap", "usermap", (Object)"");
        this.m_OptionManager.add("groupmap", "groupmap", (Object)"");
        this.m_OptionManager.add("chown", "chown", (Object)"");
        this.m_OptionManager.add("timeout", "timeout", (Object)-1);
        this.m_OptionManager.add("contimeout", "contimeout", (Object)-1);
        this.m_OptionManager.add("ignore_times", "ignoreTimes", (Object)false);
        this.m_OptionManager.add("remote_option", "remoteOption", (Object)"");
        this.m_OptionManager.add("size_only", "sizeOnly", (Object)false);
        this.m_OptionManager.add("modify_window", "modifyWindow", (Object)-1);
        this.m_OptionManager.add("temp_dir", "tempDir", (Object)"");
        this.m_OptionManager.add("fuzzy", "fuzzy", (Object)false);
        this.m_OptionManager.add("compare_dest", "compareDest", (Object)new BaseString[0]);
        this.m_OptionManager.add("copy_dest", "copyDest", (Object)new BaseString[0]);
        this.m_OptionManager.add("link_dest", "linkDest", (Object)new BaseString[0]);
        this.m_OptionManager.add("compress", "compress", (Object)false);
        this.m_OptionManager.add("compress_level", "compressLevel", (Object)-1);
        this.m_OptionManager.add("skip_compress", "skipCompress", (Object)"");
        this.m_OptionManager.add("cvs_exclude", "cvsExclude", (Object)false);
        this.m_OptionManager.add("filter", "filter", (Object)new BaseString[0]);
        this.m_OptionManager.add("exclude", "exclude", (Object)new BaseString[0]);
        this.m_OptionManager.add("exclude_from", "excludeFrom", (Object)new PlaceholderFile());
        this.m_OptionManager.add("include", "include", (Object)new BaseString[0]);
        this.m_OptionManager.add("include_from", "includeFrom", (Object)new PlaceholderFile());
        this.m_OptionManager.add("files_from", "filesFrom", (Object)new PlaceholderFile());
        this.m_OptionManager.add("from0", "from0", (Object)false);
        this.m_OptionManager.add("protect_args", "protectArgs", (Object)false);
        this.m_OptionManager.add("address", "address", (Object)"");
        this.m_OptionManager.add("port", "port", (Object)-1);
        this.m_OptionManager.add("sockopts", "sockopts", (Object)"");
        this.m_OptionManager.add("blocking_io", "blockingIO", (Object)false);
        this.m_OptionManager.add("stats", "stats", (Object)false);
        this.m_OptionManager.add("eight_bit_output", "eightBitOutput", (Object)false);
        this.m_OptionManager.add("human_readable", "humanReadable", (Object)false);
        this.m_OptionManager.add("progress", "progress", (Object)false);
        this.m_OptionManager.add("itemize_changes", "itemizeChanges", (Object)false);
        this.m_OptionManager.add("out_format", "outFormat", (Object)"");
        this.m_OptionManager.add("log_file", "logFile", (Object)new PlaceholderFile());
        this.m_OptionManager.add("log_file_format", "logFileFormat", (Object)"");
        this.m_OptionManager.add("password_file", "passwordFile", (Object)"");
        this.m_OptionManager.add("list_only", "listOnly", (Object)false);
        this.m_OptionManager.add("bwlimit", "bwlimit", (Object)"");
        this.m_OptionManager.add("outbuf", "outbuf", (Object)"");
        this.m_OptionManager.add("write_batch", "writeBatch", (Object)new PlaceholderFile());
        this.m_OptionManager.add("only_write_batch", "onlyWriteBatch", (Object)new PlaceholderFile());
        this.m_OptionManager.add("read_batch", "readBatch", (Object)new PlaceholderFile());
        this.m_OptionManager.add("protocol", "protocol", (Object)-1);
        this.m_OptionManager.add("iconv", "iconv", (Object)"");
        this.m_OptionManager.add("checksum_seed", "checksumSeed", (Object)-1);
        this.m_OptionManager.add("ipv4", "ipv4", (Object)false);
        this.m_OptionManager.add("ipv6", "ipv6", (Object)false);
        this.m_OptionManager.add("version", "version", (Object)false);
        this.m_OptionManager.add("max_time", "maxTime", (Object)-1, (Number)-1, null);
        this.m_OptionManager.add("prefix-stdout", "prefixStdOut", (Object)"");
        this.m_OptionManager.add("prefix-stderr", "prefixStdErr", (Object)"");
    }

    public void setSource(String value) {
        this.m_Source = Binaries.convertPath((String)value);
        this.reset();
    }

    public String getSource() {
        return this.m_Source;
    }

    public String sourceTipText() {
        return "The local or remote source path (path or [user@]host:path)";
    }

    public void setDestination(String value) {
        this.m_Destination = Binaries.convertPath((String)value);
        this.reset();
    }

    public String getDestination() {
        return this.m_Destination;
    }

    public String destinationTipText() {
        return "The local or remote destination path (path or [user@]host:path)";
    }

    public void setOutputCommandline(boolean value) {
        this.m_OutputCommandline = value;
        this.reset();
    }

    public boolean getOutputCommandline() {
        return this.m_OutputCommandline;
    }

    public String outputCommandlineTipText() {
        return "output the command-line generated for the rsync binary";
    }

    public boolean isVerbose() {
        return this.m_Verbose;
    }

    public void setVerbose(boolean value) {
        this.m_Verbose = value;
        this.reset();
    }

    public String verboseTipText() {
        return "increase verbosity";
    }

    public String getInfo() {
        return this.m_Info;
    }

    public void setInfo(String value) {
        this.m_Info = value;
        this.reset();
    }

    public String infoTipText() {
        return "fine-grained informational verbosity";
    }

    public String getDebug() {
        return this.m_Debug;
    }

    public void setDebug(String value) {
        this.m_Debug = value;
        this.reset();
    }

    public String debugTipText() {
        return "fine-grained debug verbosity";
    }

    public boolean isMsgs2stderr() {
        return this.m_Msgs2stderr;
    }

    public void setMsgs2stderr(boolean value) {
        this.m_Msgs2stderr = value;
        this.reset();
    }

    public String msgs2stderrTipText() {
        return "special output handling for debugging";
    }

    public boolean isQuiet() {
        return this.m_Quiet;
    }

    public void setQuiet(boolean value) {
        this.m_Quiet = value;
        this.reset();
    }

    public String quietTipText() {
        return "suppress non-error messages";
    }

    public boolean isNoMotd() {
        return this.m_NoMotd;
    }

    public void setNoMotd(boolean value) {
        this.m_NoMotd = value;
        this.reset();
    }

    public String noMotdTipText() {
        return "suppress daemon-mode MOTD";
    }

    public boolean isChecksum() {
        return this.m_Checksum;
    }

    public void setChecksum(boolean value) {
        this.m_Checksum = value;
        this.reset();
    }

    public String checksumTipText() {
        return "skip based on checksum, not mod-time & size";
    }

    public boolean isArchive() {
        return this.m_Archive;
    }

    public void setArchive(boolean value) {
        this.m_Archive = value;
        this.reset();
    }

    public String archiveTipText() {
        return "archive mode; equals -rlptgoD (no -H,-A,-X)";
    }

    public boolean isRecursive() {
        return this.m_Recursive;
    }

    public void setRecursive(boolean value) {
        this.m_Recursive = value;
        this.reset();
    }

    public String recursiveTipText() {
        return "recurse into directories";
    }

    public boolean isRelative() {
        return this.m_Relative;
    }

    public void setRelative(boolean value) {
        this.m_Relative = value;
        this.reset();
    }

    public String relativeTipText() {
        return "use relative path names";
    }

    public boolean isNoImpliedDirs() {
        return this.m_NoImpliedDirs;
    }

    public void setNoImpliedDirs(boolean value) {
        this.m_NoImpliedDirs = value;
        this.reset();
    }

    public String noImpliedDirsTipText() {
        return "use relative path names";
    }

    public boolean isBackup() {
        return this.m_Backup;
    }

    public void setBackup(boolean value) {
        this.m_Backup = value;
        this.reset();
    }

    public String backupTipText() {
        return "make backups (see --suffix & --backup-dir)";
    }

    public String getBackupDir() {
        return this.m_BackupDir;
    }

    public void setBackupDir(String value) {
        this.m_BackupDir = value;
        this.reset();
    }

    public String backupDirTipText() {
        return "make backups into hierarchy based in DIR";
    }

    public String getSuffix() {
        return this.m_Suffix;
    }

    public void setSuffix(String value) {
        this.m_Suffix = value;
        this.reset();
    }

    public String suffixTipText() {
        return "set backup suffix (default ~ w/o --backup-dir)";
    }

    public boolean isUpdate() {
        return this.m_Update;
    }

    public void setUpdate(boolean value) {
        this.m_Update = value;
        this.reset();
    }

    public String updateTipText() {
        return "skip files that are newer on the receiver";
    }

    public boolean isInplace() {
        return this.m_Inplace;
    }

    public void setInplace(boolean value) {
        this.m_Inplace = value;
        this.reset();
    }

    public String inplaceTipText() {
        return "update destination files in-place";
    }

    public boolean isAppend() {
        return this.m_Append;
    }

    public void setAppend(boolean value) {
        this.m_Append = value;
        this.reset();
    }

    public String appendTipText() {
        return "append data onto shorter files";
    }

    public boolean isAppendVerify() {
        return this.m_AppendVerify;
    }

    public void setAppendVerify(boolean value) {
        this.m_AppendVerify = value;
        this.reset();
    }

    public String appendVerifyTipText() {
        return "like --append, but with old data in file checksum";
    }

    public boolean isDirs() {
        return this.m_Dirs;
    }

    public void setDirs(boolean value) {
        this.m_Dirs = value;
        this.reset();
    }

    public String dirsTipText() {
        return "transfer directories without recursing";
    }

    public boolean isLinks() {
        return this.m_Links;
    }

    public void setLinks(boolean value) {
        this.m_Links = value;
        this.reset();
    }

    public String linksTipText() {
        return "copy symlinks as symlinks";
    }

    public boolean isCopyLinks() {
        return this.m_CopyLinks;
    }

    public void setCopyLinks(boolean value) {
        this.m_CopyLinks = value;
        this.reset();
    }

    public String copyLinksTipText() {
        return "transform symlink into referent file/dir";
    }

    public boolean isCopyUnsafeLinks() {
        return this.m_CopyUnsafeLinks;
    }

    public void setCopyUnsafeLinks(boolean value) {
        this.m_CopyUnsafeLinks = value;
        this.reset();
    }

    public String copyUnsafeLinksTipText() {
        return "only \"unsafe\" symlinks are transformed";
    }

    public boolean isSafeLinks() {
        return this.m_SafeLinks;
    }

    public void setSafeLinks(boolean value) {
        this.m_SafeLinks = value;
        this.reset();
    }

    public String safeLinksTipText() {
        return "ignore symlinks that point outside the source tree";
    }

    public boolean isMungeLinks() {
        return this.m_MungeLinks;
    }

    public void setMungeLinks(boolean value) {
        this.m_MungeLinks = value;
        this.reset();
    }

    public String mungeLinksTipText() {
        return "munge symlinks to make them safer (but unusable)";
    }

    public boolean isCopyDirlinks() {
        return this.m_CopyDirlinks;
    }

    public void setCopyDirlinks(boolean value) {
        this.m_CopyDirlinks = value;
        this.reset();
    }

    public String copyDirlinksTipText() {
        return "transform symlink to a dir into referent dir";
    }

    public boolean isKeepDirlinks() {
        return this.m_KeepDirlinks;
    }

    public void setKeepDirlinks(boolean value) {
        this.m_KeepDirlinks = value;
        this.reset();
    }

    public String keepDirlinksTipText() {
        return "treat symlinked dir on receiver as dir";
    }

    public boolean isHardLinks() {
        return this.m_HardLinks;
    }

    public void setHardLinks(boolean value) {
        this.m_HardLinks = value;
        this.reset();
    }

    public String hardLinksTipText() {
        return "preserve hard links";
    }

    public boolean isPerms() {
        return this.m_Perms;
    }

    public void setPerms(boolean value) {
        this.m_Perms = value;
        this.reset();
    }

    public String permsTipText() {
        return "preserve permissions";
    }

    public boolean isExecutability() {
        return this.m_Executability;
    }

    public void setExecutability(boolean value) {
        this.m_Executability = value;
        this.reset();
    }

    public String executabilityTipText() {
        return "preserve the file's executability";
    }

    public String getChmod() {
        return this.m_Chmod;
    }

    public void setChmod(String value) {
        this.m_Chmod = value;
        this.reset();
    }

    public String chmodTipText() {
        return "affect file and/or directory permissions";
    }

    public boolean isXattrs() {
        return this.m_Xattrs;
    }

    public void setXattrs(boolean value) {
        this.m_Xattrs = value;
        this.reset();
    }

    public String xattrsTipText() {
        return "preserve extended attributes";
    }

    public boolean isOwner() {
        return this.m_Owner;
    }

    public void setOwner(boolean value) {
        this.m_Owner = value;
        this.reset();
    }

    public String ownerTipText() {
        return "preserve owner (super-user only)";
    }

    public boolean isGroup() {
        return this.m_Group;
    }

    public void setGroup(boolean value) {
        this.m_Group = value;
        this.reset();
    }

    public String groupTipText() {
        return "preserve group";
    }

    public boolean isDevices() {
        return this.m_Devices;
    }

    public void setDevices(boolean value) {
        this.m_Devices = value;
        this.reset();
    }

    public String devicesTipText() {
        return "preserve device files (super-user only)";
    }

    public boolean isSpecials() {
        return this.m_Specials;
    }

    public void setSpecials(boolean value) {
        this.m_Specials = value;
        this.reset();
    }

    public String specialsTipText() {
        return "preserve special files";
    }

    public boolean isTimes() {
        return this.m_Times;
    }

    public void setTimes(boolean value) {
        this.m_Times = value;
        this.reset();
    }

    public String timesTipText() {
        return "preserve modification times";
    }

    public boolean isOmitDirTimes() {
        return this.m_OmitDirTimes;
    }

    public void setOmitDirTimes(boolean value) {
        this.m_OmitDirTimes = value;
        this.reset();
    }

    public String omitDirTimesTipText() {
        return "omit directories from --times";
    }

    public boolean isOmitLinkTimes() {
        return this.m_OmitLinkTimes;
    }

    public void setOmitLinkTimes(boolean value) {
        this.m_OmitLinkTimes = value;
        this.reset();
    }

    public String omitLinkTimesTipText() {
        return "omit symlinks from --times";
    }

    public boolean isSuper_() {
        return this.m_Super_;
    }

    public void setSuper_(boolean super_) {
        this.m_Super_ = super_;
        this.reset();
    }

    public String super_TipText() {
        return "receiver attempts super-user activities";
    }

    public boolean isFakeSuper() {
        return this.m_FakeSuper;
    }

    public void setFakeSuper(boolean value) {
        this.m_FakeSuper = value;
        this.reset();
    }

    public String fakeSuperTipText() {
        return "store/recover privileged attrs using xattrs";
    }

    public boolean isSparse() {
        return this.m_Sparse;
    }

    public void setSparse(boolean value) {
        this.m_Sparse = value;
        this.reset();
    }

    public String sparseTipText() {
        return "handle sparse files efficiently";
    }

    public boolean isPreallocate() {
        return this.m_Preallocate;
    }

    public void setPreallocate(boolean value) {
        this.m_Preallocate = value;
        this.reset();
    }

    public String preallocateTipText() {
        return "allocate dest files before writing them";
    }

    public boolean isDryRun() {
        return this.m_DryRun;
    }

    public void setDryRun(boolean value) {
        this.m_DryRun = value;
        this.reset();
    }

    public String dryRunTipText() {
        return "perform a trial run with no changes made";
    }

    public boolean isWholeFile() {
        return this.m_WholeFile;
    }

    public void setWholeFile(boolean value) {
        this.m_WholeFile = value;
        this.reset();
    }

    public String wholeFileTipText() {
        return "copy files whole (without delta-xfer algorithm)";
    }

    public boolean isOneFileSystem() {
        return this.m_OneFileSystem;
    }

    public void setOneFileSystem(boolean value) {
        this.m_OneFileSystem = value;
        this.reset();
    }

    public String oneFileSystemTipText() {
        return "don't cross filesystem boundaries";
    }

    public String getBlockSize() {
        return this.m_BlockSize;
    }

    public void setBlockSize(String value) {
        this.m_BlockSize = value;
        this.reset();
    }

    public String blockSizeTipText() {
        return "force a fixed checksum block-size";
    }

    public String getRsh() {
        return this.m_Rsh;
    }

    public void setRsh(String value) {
        this.m_Rsh = value;
        this.reset();
    }

    public String rshTipText() {
        return "specify the remote shell to use";
    }

    public String getRsyncPath() {
        return this.m_RsyncPath;
    }

    public void setRsyncPath(String value) {
        this.m_RsyncPath = value;
        this.reset();
    }

    public String rsyncPathTipText() {
        return "specify the rsync to run on the remote machine";
    }

    public boolean isExisting() {
        return this.m_Existing;
    }

    public void setExisting(boolean value) {
        this.m_Existing = value;
        this.reset();
    }

    public String existingTipText() {
        return "skip creating new files on receiver";
    }

    public boolean isIgnoreExisting() {
        return this.m_IgnoreExisting;
    }

    public void setIgnoreExisting(boolean value) {
        this.m_IgnoreExisting = value;
        this.reset();
    }

    public String ignoreExistingTipText() {
        return "skip updating files that already exist on receiver";
    }

    public boolean isRemoveSourceFiles() {
        return this.m_RemoveSourceFiles;
    }

    public void setRemoveSourceFiles(boolean value) {
        this.m_RemoveSourceFiles = value;
        this.reset();
    }

    public String removeSourceFilesTipText() {
        return "sender removes synchronized files (non-dirs)";
    }

    public boolean isDelete() {
        return this.m_Delete;
    }

    public void setDelete(boolean value) {
        this.m_Delete = value;
        this.reset();
    }

    public String deleteTipText() {
        return "delete extraneous files from destination dirs";
    }

    public boolean isDeleteBefore() {
        return this.m_DeleteBefore;
    }

    public void setDeleteBefore(boolean value) {
        this.m_DeleteBefore = value;
        this.reset();
    }

    public String deleteBeforeTipText() {
        return "receiver deletes before transfer, not during";
    }

    public boolean isDeleteDuring() {
        return this.m_DeleteDuring;
    }

    public void setDeleteDuring(boolean value) {
        this.m_DeleteDuring = value;
        this.reset();
    }

    public String deleteDuringTipText() {
        return "receiver deletes during the transfer";
    }

    public boolean isDeleteDelay() {
        return this.m_DeleteDelay;
    }

    public void setDeleteDelay(boolean value) {
        this.m_DeleteDelay = value;
        this.reset();
    }

    public String deleteDelayTipText() {
        return "find deletions during, delete after";
    }

    public boolean isDeleteAfter() {
        return this.m_DeleteAfter;
    }

    public void setDeleteAfter(boolean value) {
        this.m_DeleteAfter = value;
        this.reset();
    }

    public String deleteAfterTipText() {
        return "receiver deletes after transfer, not during";
    }

    public boolean isDeleteExcluded() {
        return this.m_DeleteExcluded;
    }

    public void setDeleteExcluded(boolean value) {
        this.m_DeleteExcluded = value;
        this.reset();
    }

    public String deleteExcludedTipText() {
        return "also delete excluded files from destination dirs";
    }

    public boolean isIgnoreMissingArgs() {
        return this.m_IgnoreMissingArgs;
    }

    public void setIgnoreMissingArgs(boolean value) {
        this.m_IgnoreMissingArgs = value;
        this.reset();
    }

    public String ignoreMissingArgsTipText() {
        return "ignore missing source args without error";
    }

    public boolean isDeleteMissingArgs() {
        return this.m_DeleteMissingArgs;
    }

    public void setDeleteMissingArgs(boolean value) {
        this.m_DeleteMissingArgs = value;
        this.reset();
    }

    public String deleteMissingArgsTipText() {
        return "delete missing source args from destination";
    }

    public boolean isIgnoreErrors() {
        return this.m_IgnoreErrors;
    }

    public void setIgnoreErrors(boolean value) {
        this.m_IgnoreErrors = value;
        this.reset();
    }

    public String ignoreErrorsTipText() {
        return "delete even if there are I/O errors";
    }

    public boolean isForce() {
        return this.m_Force;
    }

    public void setForce(boolean value) {
        this.m_Force = value;
        this.reset();
    }

    public String forceTipText() {
        return "force deletion of directories even if not empty";
    }

    public int getMaxDelete() {
        return this.m_MaxDelete;
    }

    public void setMaxDelete(int value) {
        this.m_MaxDelete = value;
        this.reset();
    }

    public String maxDeleteTipText() {
        return "don't delete more than NUM files";
    }

    public String getMaxSize() {
        return this.m_MaxSize;
    }

    public void setMaxSize(String value) {
        this.m_MaxSize = value;
        this.reset();
    }

    public String maxSizeTipText() {
        return "don't transfer any file larger than SIZE";
    }

    public String getMinSize() {
        return this.m_MinSize;
    }

    public void setMinSize(String value) {
        this.m_MinSize = value;
        this.reset();
    }

    public String minSizeTipText() {
        return "don't transfer any file smaller than SIZE";
    }

    public boolean isPartial() {
        return this.m_Partial;
    }

    public void setPartial(boolean value) {
        this.m_Partial = value;
        this.reset();
    }

    public String partialTipText() {
        return "keep partially transferred files";
    }

    public String getPartialDir() {
        return this.m_PartialDir;
    }

    public void setPartialDir(String value) {
        this.m_PartialDir = value;
        this.reset();
    }

    public String partialDirTipText() {
        return "put a partially transferred file into DIR";
    }

    public boolean isDelayUpdates() {
        return this.m_DelayUpdates;
    }

    public void setDelayUpdates(boolean value) {
        this.m_DelayUpdates = value;
        this.reset();
    }

    public String delayUpdatesTipText() {
        return "put all updated files into place at transfer's end";
    }

    public boolean isPruneEmptyDirs() {
        return this.m_PruneEmptyDirs;
    }

    public void setPruneEmptyDirs(boolean value) {
        this.m_PruneEmptyDirs = value;
        this.reset();
    }

    public String pruneEmptyDirsTipText() {
        return "prune empty directory chains from the file-list";
    }

    public boolean isNumericIds() {
        return this.m_NumericIds;
    }

    public void setNumericIds(boolean value) {
        this.m_NumericIds = value;
        this.reset();
    }

    public String numericIdsTipText() {
        return "don't map uid/gid values by user/group name";
    }

    public String getUsermap() {
        return this.m_Usermap;
    }

    public void setUsermap(String value) {
        this.m_Usermap = value;
        this.reset();
    }

    public String usermapTipText() {
        return "custom username mapping";
    }

    public String getGroupmap() {
        return this.m_Groupmap;
    }

    public void setGroupmap(String value) {
        this.m_Groupmap = value;
        this.reset();
    }

    public String groupmapTipText() {
        return "custom groupname mapping";
    }

    public String getChown() {
        return this.m_Chown;
    }

    public void setChown(String value) {
        this.m_Chown = value;
        this.reset();
    }

    public String chownTipText() {
        return "simple username/groupname mapping";
    }

    public int getTimeout() {
        return this.m_Timeout;
    }

    public void setTimeout(int value) {
        this.m_Timeout = value;
        this.reset();
    }

    public String timeoutTipText() {
        return "set I/O timeout in seconds";
    }

    public int getContimeout() {
        return this.m_Contimeout;
    }

    public void setContimeout(int value) {
        this.m_Contimeout = value;
        this.reset();
    }

    public String contimeoutTipText() {
        return "set daemon connection timeout in seconds";
    }

    public boolean isIgnoreTimes() {
        return this.m_IgnoreTimes;
    }

    public void setIgnoreTimes(boolean value) {
        this.m_IgnoreTimes = value;
        this.reset();
    }

    public String ignoreTimesTipText() {
        return "don't skip files that match in size and mod-time";
    }

    public String getRemoteOption() {
        return this.m_RemoteOption;
    }

    public void setRemoteOption(String value) {
        this.m_RemoteOption = value;
        this.reset();
    }

    public String remoteOptionTipText() {
        return "send OPTION to the remote side only";
    }

    public boolean isSizeOnly() {
        return this.m_SizeOnly;
    }

    public void setSizeOnly(boolean value) {
        this.m_SizeOnly = value;
        this.reset();
    }

    public String sizeOnlyTipText() {
        return "skip files that match in size";
    }

    public int getModifyWindow() {
        return this.m_ModifyWindow;
    }

    public void setModifyWindow(int value) {
        this.m_ModifyWindow = value;
        this.reset();
    }

    public String modifyWindowTipText() {
        return "compare mod-times with reduced accuracy";
    }

    public String getTempDir() {
        return this.m_TempDir;
    }

    public void setTempDir(String value) {
        this.m_TempDir = value;
        this.reset();
    }

    public String tempDirTipText() {
        return "create temporary files in directory DIR";
    }

    public boolean isFuzzy() {
        return this.m_Fuzzy;
    }

    public void setFuzzy(boolean value) {
        this.m_Fuzzy = value;
        this.reset();
    }

    public String fuzzyTipText() {
        return "find similar file for basis if no dest file";
    }

    public BaseString[] getCompareDest() {
        return this.m_CompareDest;
    }

    public void setCompareDest(BaseString[] value) {
        this.m_CompareDest = value;
        this.reset();
    }

    public String compareDestTipText() {
        return "also compare destination files relative to DIR";
    }

    public BaseString[] getCopyDest() {
        return this.m_CopyDest;
    }

    public void setCopyDest(BaseString[] value) {
        this.m_CopyDest = value;
        this.reset();
    }

    public String copyDestTipText() {
        return "... and include copies of unchanged files";
    }

    public BaseString[] getLinkDest() {
        return this.m_LinkDest;
    }

    public void setLinkDest(BaseString[] value) {
        this.m_LinkDest = value;
        this.reset();
    }

    public String linkDestTipText() {
        return "hardlink to files in DIR when unchanged";
    }

    public boolean isCompress() {
        return this.m_Compress;
    }

    public void setCompress(boolean value) {
        this.m_Compress = value;
        this.reset();
    }

    public String compressTipText() {
        return "compress file data during the transfer";
    }

    public int getCompressLevel() {
        return this.m_CompressLevel;
    }

    public void setCompressLevel(int value) {
        this.m_CompressLevel = value;
        this.reset();
    }

    public String compressLevelTipText() {
        return "explicitly set compression level";
    }

    public String getSkipCompress() {
        return this.m_SkipCompress;
    }

    public void setSkipCompress(String value) {
        this.m_SkipCompress = value;
        this.reset();
    }

    public String skipCompressTipText() {
        return "skip compressing files with a suffix in LIST";
    }

    public boolean isCvsExclude() {
        return this.m_CvsExclude;
    }

    public void setCvsExclude(boolean value) {
        this.m_CvsExclude = value;
        this.reset();
    }

    public String cvsExcludeTipText() {
        return "auto-ignore files the same way CVS does";
    }

    public BaseString[] getFilter() {
        return this.m_Filter;
    }

    public void setFilter(BaseString[] value) {
        this.m_Filter = value;
        this.reset();
    }

    public String filterTipText() {
        return "add a file-filtering RULE";
    }

    public BaseString[] getExclude() {
        return this.m_Exclude;
    }

    public void setExclude(BaseString[] value) {
        this.m_Exclude = value;
        this.reset();
    }

    public String excludeTipText() {
        return "exclude files matching PATTERN";
    }

    public PlaceholderFile getExcludeFrom() {
        return this.m_ExcludeFrom;
    }

    public void setExcludeFrom(PlaceholderFile value) {
        this.m_ExcludeFrom = value;
        this.reset();
    }

    public String excludeFromTipText() {
        return "read exclude patterns from FILE";
    }

    public BaseString[] getInclude() {
        return this.m_Include;
    }

    public void setInclude(BaseString[] value) {
        this.m_Include = value;
        this.reset();
    }

    public String includeTipText() {
        return "include files matching PATTERN";
    }

    public PlaceholderFile getIncludeFrom() {
        return this.m_IncludeFrom;
    }

    public void setIncludeFrom(PlaceholderFile value) {
        this.m_IncludeFrom = value;
        this.reset();
    }

    public String includeFromTipText() {
        return "read include patterns from FILE";
    }

    public PlaceholderFile getFilesFrom() {
        return this.m_FilesFrom;
    }

    public void setFilesFrom(PlaceholderFile value) {
        this.m_FilesFrom = value;
        this.reset();
    }

    public String filesFromTipText() {
        return "read list of source-file names from FILE";
    }

    public boolean isFrom0() {
        return this.m_From0;
    }

    public void setFrom0(boolean value) {
        this.m_From0 = value;
        this.reset();
    }

    public String from0TipText() {
        return "all *-from/filter files are delimited by 0s";
    }

    public boolean isProtectArgs() {
        return this.m_ProtectArgs;
    }

    public void setProtectArgs(boolean value) {
        this.m_ProtectArgs = value;
        this.reset();
    }

    public String protectArgsTipText() {
        return "no space-splitting; only wildcard special-chars";
    }

    public String getAddress() {
        return this.m_Address;
    }

    public void setAddress(String value) {
        this.m_Address = value;
        this.reset();
    }

    public String addressTipText() {
        return "bind address for outgoing socket to daemon";
    }

    public int getPort() {
        return this.m_Port;
    }

    public void setPort(int value) {
        this.m_Port = value;
        this.reset();
    }

    public String portTipText() {
        return "specify double-colon alternate port number";
    }

    public String getSockopts() {
        return this.m_Sockopts;
    }

    public void setSockopts(String value) {
        this.m_Sockopts = value;
        this.reset();
    }

    public String sockoptsTipText() {
        return "specify custom TCP options";
    }

    public boolean isBlockingIO() {
        return this.m_BlockingIO;
    }

    public void setBlockingIO(boolean value) {
        this.m_BlockingIO = value;
        this.reset();
    }

    public String blockingIOTipText() {
        return "use blocking I/O for the remote shell";
    }

    public boolean isStats() {
        return this.m_Stats;
    }

    public void setStats(boolean value) {
        this.m_Stats = value;
        this.reset();
    }

    public String statsTipText() {
        return "give some file-transfer stats";
    }

    public boolean isEightBitOutput() {
        return this.m_EightBitOutput;
    }

    public void setEightBitOutput(boolean value) {
        this.m_EightBitOutput = value;
        this.reset();
    }

    public String eightBitOutputTipText() {
        return "leave high-bit chars unescaped in output";
    }

    public boolean isHumanReadable() {
        return this.m_HumanReadable;
    }

    public void setHumanReadable(boolean value) {
        this.m_HumanReadable = value;
        this.reset();
    }

    public String humanReadableTipText() {
        return "output numbers in a human-readable format";
    }

    public boolean isProgress() {
        return this.m_Progress;
    }

    public void setProgress(boolean value) {
        this.m_Progress = value;
        this.reset();
    }

    public String progressTipText() {
        return "show progress during transfer";
    }

    public boolean isItemizeChanges() {
        return this.m_ItemizeChanges;
    }

    public void setItemizeChanges(boolean value) {
        this.m_ItemizeChanges = value;
        this.reset();
    }

    public String itemizeChangesTipText() {
        return "output a change-summary for all updates";
    }

    public String getOutFormat() {
        return this.m_OutFormat;
    }

    public void setOutFormat(String value) {
        this.m_OutFormat = value;
        this.reset();
    }

    public String outFormatTipText() {
        return "output updates using the specified FORMAT";
    }

    public PlaceholderFile getLogFile() {
        return this.m_LogFile;
    }

    public void setLogFile(PlaceholderFile value) {
        this.m_LogFile = value;
        this.reset();
    }

    public String logFileTipText() {
        return "log what we're doing to the specified FILE";
    }

    public String getLogFileFormat() {
        return this.m_LogFileFormat;
    }

    public void setLogFileFormat(String value) {
        this.m_LogFileFormat = value;
        this.reset();
    }

    public String logFileFormatTipText() {
        return "log updates using the specified FMT";
    }

    public String getPasswordFile() {
        return this.m_PasswordFile;
    }

    public void setPasswordFile(String value) {
        this.m_PasswordFile = value;
        this.reset();
    }

    public String passwordFileTipText() {
        return "read daemon-access password from FILE";
    }

    public boolean isListOnly() {
        return this.m_ListOnly;
    }

    public void setListOnly(boolean value) {
        this.m_ListOnly = value;
        this.reset();
    }

    public String listOnlyTipText() {
        return "list the files instead of copying them";
    }

    public String getBwlimit() {
        return this.m_Bwlimit;
    }

    public void setBwlimit(String value) {
        this.m_Bwlimit = value;
        this.reset();
    }

    public String bwlimitTipText() {
        return "limit socket I/O bandwidth";
    }

    public String getOutbuf() {
        return this.m_Outbuf;
    }

    public void setOutbuf(String value) {
        this.m_Outbuf = value;
        this.reset();
    }

    public String outbufTipText() {
        return "set output buffering to None, Line, or Block (N|L|B)";
    }

    public PlaceholderFile getWriteBatch() {
        return this.m_WriteBatch;
    }

    public void setWriteBatch(PlaceholderFile value) {
        this.m_WriteBatch = value;
        this.reset();
    }

    public String writeBatchTipText() {
        return "write a batched update to FILE";
    }

    public PlaceholderFile getOnlyWriteBatch() {
        return this.m_OnlyWriteBatch;
    }

    public void setOnlyWriteBatch(PlaceholderFile value) {
        this.m_OnlyWriteBatch = value;
        this.reset();
    }

    public String onlyWriteBatchTipText() {
        return "like --write-batch but w/o updating destination";
    }

    public PlaceholderFile getReadBatch() {
        return this.m_ReadBatch;
    }

    public void setReadBatch(PlaceholderFile value) {
        this.m_ReadBatch = value;
        this.reset();
    }

    public String readBatchTipText() {
        return "read a batched update from FILE";
    }

    public int getProtocol() {
        return this.m_Protocol;
    }

    public void setProtocol(int value) {
        this.m_Protocol = value;
        this.reset();
    }

    public String protocolTipText() {
        return "force an older protocol version to be used";
    }

    public String getIconv() {
        return this.m_Iconv;
    }

    public void setIconv(String value) {
        this.m_Iconv = value;
        this.reset();
    }

    public String iconvTipText() {
        return "request charset conversion of filenames";
    }

    public int getChecksumSeed() {
        return this.m_ChecksumSeed;
    }

    public void setChecksumSeed(int value) {
        this.m_ChecksumSeed = value;
        this.reset();
    }

    public String checksumSeedTipText() {
        return "set block/file checksum seed (advanced)";
    }

    public boolean isIpv4() {
        return this.m_Ipv4;
    }

    public void setIpv4(boolean value) {
        this.m_Ipv4 = value;
        this.reset();
    }

    public String ipv4TipText() {
        return "prefer IPv4";
    }

    public boolean isIpv6() {
        return this.m_Ipv6;
    }

    public void setIpv6(boolean value) {
        this.m_Ipv6 = value;
        this.reset();
    }

    public String ipv6TipText() {
        return "prefer IPv6";
    }

    public boolean isVersion() {
        return this.m_Version;
    }

    public void setVersion(boolean value) {
        this.m_Version = value;
        this.reset();
    }

    public String versionTipText() {
        return "print version number";
    }

    public int getMaxTime() {
        return this.m_MaxTime;
    }

    public void setMaxTime(int value) {
        if (this.getOptionManager().isValid("maxTime", (Number)value)) {
            this.m_MaxTime = value;
            this.reset();
        }
    }

    public String maxTimeTipText() {
        return "time out in seconds, stopping rsync process once exceeded, ignored if less than 1";
    }

    public void setPrefixStdOut(String value) {
        this.m_PrefixStdOut = value;
        this.reset();
    }

    public String getPrefixStdOut() {
        return this.m_PrefixStdOut;
    }

    public String prefixStdOutTipText() {
        return "The (optional) prefix to use for output from stdout.";
    }

    public void setPrefixStdErr(String value) {
        this.m_PrefixStdErr = value;
        this.reset();
    }

    public String getPrefixStdErr() {
        return this.m_PrefixStdErr;
    }

    public String prefixStdErrTipText() {
        return "The (optional) prefix to use for output from stderr.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"source", (Object)(this.m_Source.isEmpty() ? "-none-" : this.m_Source), (String)"src: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"destination", (Object)(this.m_Destination.isEmpty() ? "-none-" : this.m_Destination), (String)", dst: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"recursive", (boolean)this.m_Recursive, (String)"recursive", (String)", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"dryRun", (boolean)this.m_DryRun, (String)"dry-run", (String)", ");
        return result;
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    public StreamingProcessOutputType getOutputType() {
        return StreamingProcessOutputType.BOTH;
    }

    public void processOutput(String line, boolean stdout) {
        if (!this.isStopped() && this.m_Queue != null) {
            this.m_Queue.add((stdout ? this.m_PrefixStdOut : this.m_PrefixStdErr) + line);
        }
    }

    protected String doExecute() {
        String result = null;
        this.m_Queue.clear();
        try {
            com.github.fracpete.rsync4j.RSync rsync = new com.github.fracpete.rsync4j.RSync();
            rsync.verbose(this.m_Verbose);
            rsync.info(this.m_Info);
            rsync.debug(this.m_Debug);
            rsync.msgs2stderr(this.m_Msgs2stderr);
            rsync.quiet(this.m_Quiet);
            rsync.noMotd(this.m_NoMotd);
            rsync.checksum(this.m_Checksum);
            rsync.archive(this.m_Archive);
            rsync.recursive(this.m_Recursive);
            rsync.relative(this.m_Relative);
            rsync.noImpliedDirs(this.m_NoImpliedDirs);
            rsync.backup(this.m_Backup);
            rsync.backupDir(this.m_BackupDir);
            rsync.suffix(this.m_Suffix);
            rsync.update(this.m_Update);
            rsync.inplace(this.m_Inplace);
            rsync.append(this.m_Append);
            rsync.appendVerify(this.m_AppendVerify);
            rsync.dirs(this.m_Dirs);
            rsync.links(this.m_Links);
            rsync.copyLinks(this.m_CopyLinks);
            rsync.copyUnsafeLinks(this.m_CopyUnsafeLinks);
            rsync.safeLinks(this.m_SafeLinks);
            rsync.mungeLinks(this.m_MungeLinks);
            rsync.copyDirlinks(this.m_CopyDirlinks);
            rsync.keepDirlinks(this.m_KeepDirlinks);
            rsync.hardLinks(this.m_HardLinks);
            rsync.perms(this.m_Perms);
            rsync.executability(this.m_Executability);
            rsync.chmod(this.m_Chmod);
            rsync.xattrs(this.m_Xattrs);
            rsync.owner(this.m_Owner);
            rsync.group(this.m_Group);
            rsync.devices(this.m_Devices);
            rsync.specials(this.m_Specials);
            rsync.times(this.m_Times);
            rsync.omitDirTimes(this.m_OmitDirTimes);
            rsync.omitLinkTimes(this.m_OmitLinkTimes);
            rsync.super_(this.m_Super_);
            rsync.fakeSuper(this.m_FakeSuper);
            rsync.sparse(this.m_Sparse);
            rsync.preallocate(this.m_Preallocate);
            rsync.dryRun(this.m_DryRun);
            rsync.wholeFile(this.m_WholeFile);
            rsync.oneFileSystem(this.m_OneFileSystem);
            rsync.blockSize(this.m_BlockSize);
            rsync.rsh(this.m_Rsh);
            rsync.rsyncPath(this.m_RsyncPath);
            rsync.existing(this.m_Existing);
            rsync.ignoreExisting(this.m_IgnoreExisting);
            rsync.removeSourceFiles(this.m_RemoveSourceFiles);
            rsync.delete(this.m_Delete);
            rsync.deleteBefore(this.m_DeleteBefore);
            rsync.deleteDuring(this.m_DeleteDuring);
            rsync.deleteDelay(this.m_DeleteDelay);
            rsync.deleteAfter(this.m_DeleteAfter);
            rsync.deleteExcluded(this.m_DeleteExcluded);
            rsync.ignoreMissingArgs(this.m_IgnoreMissingArgs);
            rsync.deleteMissingArgs(this.m_DeleteMissingArgs);
            rsync.ignoreErrors(this.m_IgnoreErrors);
            rsync.force(this.m_Force);
            rsync.maxDelete(this.m_MaxDelete);
            rsync.maxSize(this.m_MaxSize);
            rsync.minSize(this.m_MinSize);
            rsync.partial(this.m_Partial);
            rsync.delayUpdates(this.m_DelayUpdates);
            rsync.pruneEmptyDirs(this.m_PruneEmptyDirs);
            rsync.numericIds(this.m_NumericIds);
            rsync.usermap(this.m_Usermap);
            rsync.groupmap(this.m_Groupmap);
            rsync.chown(this.m_Chown);
            rsync.timeout(this.m_Timeout);
            rsync.contimeout(this.m_Contimeout);
            rsync.ignoreTimes(this.m_IgnoreTimes);
            rsync.remoteOption(this.m_RemoteOption);
            rsync.sizeOnly(this.m_SizeOnly);
            rsync.modifyWindow(this.m_ModifyWindow);
            rsync.tempDir(this.m_TempDir);
            rsync.fuzzy(this.m_Fuzzy);
            rsync.compareDest(BaseObject.toStringArray((BaseObject[])this.m_CompareDest));
            rsync.copyDest(BaseObject.toStringArray((BaseObject[])this.m_CopyDest));
            rsync.linkDest(BaseObject.toStringArray((BaseObject[])this.m_LinkDest));
            rsync.compress(this.m_Compress);
            rsync.compressLevel(this.m_CompressLevel);
            rsync.skipCompress(this.m_SkipCompress);
            rsync.cvsExclude(this.m_CvsExclude);
            rsync.filter(BaseObject.toStringArray((BaseObject[])this.m_Filter));
            rsync.exclude(BaseObject.toStringArray((BaseObject[])this.m_Exclude));
            if (!this.m_ExcludeFrom.isDirectory()) {
                rsync.excludeFrom(new String[]{this.m_ExcludeFrom.getAbsolutePath()});
            }
            rsync.include(BaseObject.toStringArray((BaseObject[])this.m_Include));
            if (!this.m_IncludeFrom.isDirectory()) {
                rsync.includeFrom(new String[]{this.m_IncludeFrom.getAbsolutePath()});
            }
            if (!this.m_FilesFrom.isDirectory()) {
                rsync.filesFrom(this.m_FilesFrom.getAbsolutePath());
            }
            rsync.from0(this.m_From0);
            rsync.protectArgs(this.m_ProtectArgs);
            rsync.address(this.m_Address);
            rsync.port(this.m_Port);
            rsync.sockopts(this.m_Sockopts);
            rsync.blockingIO(this.m_BlockingIO);
            rsync.stats(this.m_Stats);
            rsync.eightBitOutput(this.m_EightBitOutput);
            rsync.humanReadable(this.m_HumanReadable);
            rsync.progress(this.m_Progress);
            rsync.itemizeChanges(this.m_ItemizeChanges);
            rsync.outFormat(this.m_OutFormat);
            if (!this.m_LogFile.isDirectory()) {
                rsync.logFile(this.m_LogFile.getAbsolutePath());
            }
            rsync.logFileFormat(this.m_LogFileFormat);
            rsync.passwordFile(this.m_PasswordFile);
            rsync.listOnly(this.m_ListOnly);
            rsync.bwlimit(this.m_Bwlimit);
            if (this.m_Outbuf.length() == 1) {
                rsync.outbuf(this.m_Outbuf.charAt(0));
            }
            if (!this.m_WriteBatch.isDirectory()) {
                rsync.writeBatch(this.m_WriteBatch.getAbsolutePath());
            }
            if (!this.m_OnlyWriteBatch.isDirectory()) {
                rsync.onlyWriteBatch(this.m_OnlyWriteBatch.getAbsolutePath());
            }
            if (!this.m_ReadBatch.isDirectory()) {
                rsync.readBatch(this.m_ReadBatch.getAbsolutePath());
            }
            rsync.protocol(this.m_Protocol);
            rsync.iconv(this.m_Iconv);
            rsync.checksumSeed(this.m_ChecksumSeed);
            rsync.ipv4(this.m_Ipv4);
            rsync.ipv6(this.m_Ipv6);
            rsync.version(this.m_Version);
            rsync.maxTime(this.m_MaxTime);
            rsync.outputCommandline(this.m_OutputCommandline);
            rsync.source(this.m_Source);
            rsync.destination(this.m_Destination);
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Rsync:\n" + Utils.flatten((List)rsync.commandLineArgs(), (String)" "));
            }
            StreamingProcessOutput output = new StreamingProcessOutput((StreamingProcessOwner)this);
            output.monitor(rsync.builder());
            if (output.getExitCode() > 0) {
                result = "Exit code: " + output.getExitCode();
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to execute rsync!", e);
        }
        return result;
    }
}

