#!/bin/sh
# ----------------------------------------------------------------------------
#  Copyright 2001-2006 The Apache Software Foundation.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
# ----------------------------------------------------------------------------

#   Copyright (c) 2001-2002 The Apache Software Foundation.  All rights
#   reserved.

#   Copyright (C) 2011-2016 University of Waikato, Hamilton, NZ

BASEDIR=`dirname $0`/..
BASEDIR=`(cd "$BASEDIR"; pwd)`

# OS specific support.  $var _must_ be set to either true or false.
cygwin=false;
darwin=false;
case "`uname`" in
  CYGWIN*) cygwin=true ;;
  Darwin*) darwin=true
           if [ -z "$JAVA_VERSION" ] ; then
             JAVA_VERSION="CurrentJDK"
           else
             echo "Using Java version: $JAVA_VERSION"
           fi
           if [ -z "$JAVA_HOME" ] ; then
             JAVA_HOME=/System/Library/Frameworks/JavaVM.framework/Versions/${JAVA_VERSION}/Home
           fi
           ;;
esac

if [ -z "$JAVA_HOME" ] ; then
  if [ -r /etc/gentoo-release ] ; then
    JAVA_HOME=`java-config --jre-home`
  fi
fi

# For Cygwin, ensure paths are in UNIX format before anything is touched
if $cygwin ; then
  [ -n "$JAVA_HOME" ] && JAVA_HOME=`cygpath --unix "$JAVA_HOME"`
  [ -n "$CLASSPATH" ] && CLASSPATH=`cygpath --path --unix "$CLASSPATH"`
fi

# If a specific java binary isn't specified search for the standard 'java' binary
if [ -z "$JAVACMD" ] ; then
  if [ -n "$JAVA_HOME"  ] ; then
    if [ -x "$JAVA_HOME/jre/sh/java" ] ; then
      # IBM's JDK on AIX uses strange locations for the executables
      JCMD="$JAVA_HOME/jre/sh/java"
    else
      JCMD="$JAVA_HOME/bin/java"
    fi
  else
    JCMD=`which java`
  fi
else
  JCMD=$JAVACMD
fi

if [ ! -x "$JCMD" ] ; then
  echo "Error: JAVA_HOME is not defined correctly."
  echo "  We cannot execute $JCMD"
  exit 1
fi

REPO="$BASEDIR"/lib
RESOURCES="$BASEDIR"/resources
CLASSPATH="$RESOURCES":"$REPO/*"
AGENT="$REPO/sizeofag-1.0.0.jar"

# For Cygwin, switch paths to Windows format before running java
if $cygwin; then
  [ -n "$CLASSPATH" ] && CLASSPATH=`cygpath --path --windows "$CLASSPATH"`
  [ -n "$JAVA_HOME" ] && JAVA_HOME=`cygpath --path --windows "$JAVA_HOME"`
  [ -n "$HOME" ] && HOME=`cygpath --path --windows "$HOME"`
  [ -n "$BASEDIR" ] && BASEDIR=`cygpath --path --windows "$BASEDIR"`
  [ -n "$REPO" ] && REPO=`cygpath --path --windows "$REPO"`
  [ -n "$AGENT" ] && AGENT=`cygpath --path --windows "$AGENT"`
fi

# check options
MEMORY=512m
MAIN=adams.gui.Main
JVM=
CPA=
ENVVARS=
ARGS=
OPTION=
PRIORITY="-priority $REPO/java-cup-11b-2015.03.26.jar"
COLLAPSE="-collapse"
for ARG in "$@"
do
  if [ "$ARG" = "-memory" ] || [ "$ARG" = "-main" ] || [ "$ARG" = "-jvm" ] || [ "$ARG" = "-cpa" ] || [ "$ARG" = "-priority" ] || [ "$ARG" = "-env" ]
  then
  	OPTION=$ARG
  	continue
  fi

  if [ "$OPTION" = "-memory" ]
  then
    MEMORY=$ARG
    OPTION=""
    continue
  elif [ "$OPTION" = "-main" ]
  then
    MAIN=$ARG
    OPTION=""
    continue
  elif [ "$OPTION" = "-nocollapse" ]
  then
    COLLAPSE=""
    continue
  elif [ "$OPTION" = "-jvm" ]
  then
    JVM="$JVM -jvm \"$ARG\""
    OPTION=""
    continue
  elif [ "$OPTION" = "-cpa" ]
  then
    CPA="-cpa \"$ARG\""
    OPTION=""
    continue
  elif [ "$OPTION" = "-priority" ]
  then
    PRIORITY="-priority \"$ARG\""
    OPTION=""
    continue
  elif [ "$OPTION" = "-env" ]
  then
    ENVVARS="-env \"$ARG\""
    OPTION=""
    continue
  fi

  ARGS="$ARGS \"$ARG\""
done

# launch class
"$JCMD" $JAVA_OPTS \
  -classpath "$CLASSPATH" \
  -Dbasedir="$BASEDIR" \
  adams.core.management.Launcher \
  -memory $MEMORY \
  -javaagent "$AGENT" \
  $JVM \
  $CPA \
  $PRIORITY \
  $ENVVARS \
  $COLLAPSE \
  -main $MAIN \
  -doc-dir "$BASEDIR/docs" \
  $ARGS
