/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.QuickInfoHelper;
import adams.core.base.BasePassword;
import adams.core.io.ConsoleHelper;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.core.OptionalPasswordPrompt;
import adams.flow.core.StopHelper;
import adams.flow.core.StopMode;
import adams.flow.core.TrustManagerFactoryProvider;
import adams.flow.standalone.AbstractStandalone;
import adams.gui.dialog.PasswordDialog;
import java.awt.Dialog;
import java.awt.Window;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.ArrayList;
import javax.net.ssl.TrustManagerFactory;

public class TrustManager
extends AbstractStandalone
implements OptionalPasswordPrompt,
TrustManagerFactoryProvider {
    private static final long serialVersionUID = 3990761211470952210L;
    protected String m_KeystoreType;
    protected PlaceholderFile m_KeystoreFile;
    protected BasePassword m_KeystorePassphrase;
    protected BasePassword m_ActualPassphrase;
    protected boolean m_PromptForPassword;
    protected boolean m_StopFlowIfCanceled;
    protected String m_CustomStopMessage;
    protected StopMode m_StopMode;
    protected String m_Algorithm;
    protected transient TrustManagerFactory m_TrustManagerFactory;

    public String globalInfo() {
        return "Initializes a TrustManagerFactory instance using the specified keystore file and algorithm.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("keystore-type", "keystoreType", (Object)"JKS");
        this.m_OptionManager.add("keystore-file", "keystoreFile", (Object)new PlaceholderFile());
        this.m_OptionManager.add("keystore-passphrase", "keystorePassphrase", (Object)new BasePassword(""), false);
        this.m_OptionManager.add("prompt-for-password", "promptForPassword", (Object)false);
        this.m_OptionManager.add("stop-if-canceled", "stopFlowIfCanceled", (Object)false);
        this.m_OptionManager.add("custom-stop-message", "customStopMessage", (Object)"");
        this.m_OptionManager.add("stop-mode", "stopMode", (Object)StopMode.GLOBAL);
        this.m_OptionManager.add("algorithm", "algorithm", (Object)"SunX509");
    }

    protected void reset() {
        super.reset();
        this.m_TrustManagerFactory = null;
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"keystoreType", (Object)this.m_KeystoreType, (String)"type: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"keystoreFile", (Object)this.m_KeystoreFile, (String)", file: ");
        ArrayList options = new ArrayList();
        if (QuickInfoHelper.hasVariable((OptionHandler)this, (String)"promptForPassword") || this.m_PromptForPassword) {
            QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"promptForPassword", (boolean)this.m_PromptForPassword, (String)"prompt for password"));
            QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"stopFlowIfCanceled", (boolean)this.m_StopFlowIfCanceled, (String)"stop flow"));
        }
        result = result + QuickInfoHelper.flatten(options);
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"algorithm", (Object)this.m_Algorithm, (String)", algorithm: ");
        return result;
    }

    public void setKeystoreType(String value) {
        this.m_KeystoreType = value;
        this.reset();
    }

    public String getKeystoreType() {
        return this.m_KeystoreType;
    }

    public String keystoreTypeTipText() {
        return "The type of the keystore, eg PKCS12 or JKS.";
    }

    public void setKeystoreFile(PlaceholderFile value) {
        this.m_KeystoreFile = value;
        this.reset();
    }

    public PlaceholderFile getKeystoreFile() {
        return this.m_KeystoreFile;
    }

    public String keystoreFileTipText() {
        return "The location of the keystore.";
    }

    public void setKeystorePassphrase(BasePassword value) {
        this.m_KeystorePassphrase = value;
        this.reset();
    }

    public BasePassword getKeystorePassphrase() {
        return this.m_KeystorePassphrase;
    }

    public String keystorePassphraseTipText() {
        return "The passphrase for the keystore file, ignored if empty.";
    }

    public void setPromptForPassword(boolean value) {
        this.m_PromptForPassword = value;
        this.reset();
    }

    public boolean getPromptForPassword() {
        return this.m_PromptForPassword;
    }

    public String promptForPasswordTipText() {
        return "If enabled, the user gets prompted for enter a password if none has been provided in the setup.";
    }

    public void setStopFlowIfCanceled(boolean value) {
        this.m_StopFlowIfCanceled = value;
        this.reset();
    }

    public boolean getStopFlowIfCanceled() {
        return this.m_StopFlowIfCanceled;
    }

    public String stopFlowIfCanceledTipText() {
        return "If enabled, the flow gets stopped in case the user cancels the dialog.";
    }

    public void setCustomStopMessage(String value) {
        this.m_CustomStopMessage = value;
        this.reset();
    }

    public String getCustomStopMessage() {
        return this.m_CustomStopMessage;
    }

    public String customStopMessageTipText() {
        return "The custom stop message to use in case a user cancelation stops the flow (default is the full name of the actor)";
    }

    public void setStopMode(StopMode value) {
        this.m_StopMode = value;
        this.reset();
    }

    public StopMode getStopMode() {
        return this.m_StopMode;
    }

    public String stopModeTipText() {
        return "The stop mode to use.";
    }

    public void setAlgorithm(String value) {
        this.m_Algorithm = value;
        this.reset();
    }

    public String getAlgorithm() {
        return this.m_Algorithm;
    }

    public String algorithmTipText() {
        return "The algorithm to use.";
    }

    public boolean doInteract() {
        boolean result;
        PasswordDialog dlg = new PasswordDialog((Dialog)null, Dialog.ModalityType.DOCUMENT_MODAL);
        dlg.setLabelPassword("Keystore passphrase");
        dlg.setLocationRelativeTo(this.getParentComponent());
        ((Flow)this.getRoot()).registerWindow((Window)dlg, dlg.getTitle());
        dlg.setVisible(true);
        ((Flow)this.getRoot()).deregisterWindow((Window)dlg);
        boolean bl = result = dlg.getOption() == 0;
        if (result) {
            this.m_ActualPassphrase = dlg.getPassword();
        }
        return result;
    }

    public boolean supportsHeadlessInteraction() {
        return true;
    }

    public boolean doInteractHeadless() {
        boolean result = false;
        BasePassword password = ConsoleHelper.enterPassword((String)("Please enter keystore passphrase (" + this.getName() + "):"));
        if (password != null) {
            result = true;
            this.m_ActualPassphrase = password;
        }
        return result;
    }

    public TrustManagerFactory getTrustManagerFactory() {
        return this.m_TrustManagerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doExecute() {
        String result = null;
        if (this.m_TrustManagerFactory == null) {
            this.m_ActualPassphrase = this.m_KeystorePassphrase;
            if (this.m_PromptForPassword && this.m_KeystorePassphrase.getValue().length() == 0) {
                if (!this.isHeadless()) {
                    if (!this.doInteract() && this.m_StopFlowIfCanceled) {
                        if (this.m_CustomStopMessage == null || this.m_CustomStopMessage.trim().length() == 0) {
                            StopHelper.stop((Actor)this, (StopMode)this.m_StopMode, (String)("Flow canceled: " + this.getFullName()));
                        } else {
                            StopHelper.stop((Actor)this, (StopMode)this.m_StopMode, (String)this.m_CustomStopMessage);
                        }
                        result = this.getStopMessage();
                    }
                } else if (this.supportsHeadlessInteraction() && !this.doInteractHeadless() && this.m_StopFlowIfCanceled) {
                    if (this.m_CustomStopMessage == null || this.m_CustomStopMessage.trim().length() == 0) {
                        StopHelper.stop((Actor)this, (StopMode)this.m_StopMode, (String)("Flow canceled: " + this.getFullName()));
                    } else {
                        StopHelper.stop((Actor)this, (StopMode)this.m_StopMode, (String)this.m_CustomStopMessage);
                    }
                    result = this.getStopMessage();
                }
            }
            if (result == null) {
                FileInputStream fis = null;
                try {
                    KeyStore keystore = KeyStore.getInstance(this.m_KeystoreType);
                    fis = new FileInputStream(this.m_KeystoreFile.getAbsolutePath());
                    keystore.load(fis, this.m_ActualPassphrase.getValue().toCharArray());
                    this.m_TrustManagerFactory = TrustManagerFactory.getInstance(this.m_Algorithm);
                    this.m_TrustManagerFactory.init(keystore);
                    FileUtils.closeQuietly((InputStream)fis);
                }
                catch (Exception e) {
                    result = this.handleException("Failed to initialize the TrustManagerFactory!", e);
                }
                finally {
                    FileUtils.closeQuietly(fis);
                }
            }
        }
        return result;
    }
}

