/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.source.AbstractSimpleSource;
import java.nio.file.Files;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public class KeyPairFileReader
extends AbstractSimpleSource {
    private static final long serialVersionUID = -2399319754051534729L;
    protected String m_Type;
    protected PlaceholderFile m_PrivateKey;
    protected PlaceholderFile m_PublicKey;

    public String globalInfo() {
        return "Reads private and public keys in DER format from the specified files and forwards them as pair.\nFor algorithm types, see:\nhttps://docs.oracle.com/en/java/javase/11/docs/specs/security/standard-names.html#keygenerator-algorithms";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)"RSA");
        this.m_OptionManager.add("private-key", "privateKey", (Object)new PlaceholderFile());
        this.m_OptionManager.add("public-key", "publicKey", (Object)new PlaceholderFile());
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)this.m_Type, (String)"type: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"privateKey", (Object)this.m_PrivateKey, (String)", private: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"publicKey", (Object)this.m_PublicKey, (String)", public: ");
        return result;
    }

    public void setType(String value) {
        this.m_Type = value;
        this.reset();
    }

    public String getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of the key pair algorithm, eg RSA.";
    }

    public void setPrivateKey(PlaceholderFile value) {
        this.m_PrivateKey = value;
        this.reset();
    }

    public PlaceholderFile getPrivateKey() {
        return this.m_PrivateKey;
    }

    public String privateKeyTipText() {
        return "The file containing the private key.";
    }

    public void setPublicKey(PlaceholderFile value) {
        this.m_PublicKey = value;
        this.reset();
    }

    public PlaceholderFile getPublicKey() {
        return this.m_PublicKey;
    }

    public String publicKeyTipText() {
        return "The file containing the public key.";
    }

    public Class[] generates() {
        return new Class[]{KeyPair.class};
    }

    protected String doExecute() {
        String result = null;
        byte[] privateKey = null;
        try {
            privateKey = Files.readAllBytes(this.m_PrivateKey.getAbsoluteFile().toPath());
        }
        catch (Exception e) {
            result = this.handleException("Failed to read private key: " + this.m_PrivateKey, e);
        }
        byte[] publicKey = null;
        if (result == null) {
            try {
                publicKey = Files.readAllBytes(this.m_PublicKey.getAbsoluteFile().toPath());
            }
            catch (Exception e) {
                result = this.handleException("Failed to read public key: " + this.m_PublicKey, e);
            }
        }
        if (result == null) {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance(this.m_Type);
                X509EncodedKeySpec pubSpec = new X509EncodedKeySpec(publicKey);
                PublicKey pubKey = keyFactory.generatePublic(pubSpec);
                PKCS8EncodedKeySpec privSpec = new PKCS8EncodedKeySpec(privateKey);
                PrivateKey privKey = keyFactory.generatePrivate(privSpec);
                this.m_OutputToken = new Token((Object)new KeyPair(pubKey, privKey));
            }
            catch (Exception e) {
                result = this.handleException("Failed to decode keys as " + this.m_Type, e);
            }
        }
        return result;
    }
}

