/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.ClassCrossReference;
import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.flow.control.Tee;
import adams.flow.core.Token;
import adams.flow.source.EnterManyValues;
import adams.gui.core.PropertiesParameterPanel;

public class Keytool
extends Tee
implements ClassCrossReference {
    private static final long serialVersionUID = -4497496140953116320L;
    protected PlaceholderFile m_Executable;
    protected String m_AdditionalOptions;

    public String globalInfo() {
        return "Runs keytool whenever a token gets passed through. The generated output gets tee-ed off.\nIf a password should be required, it is recommended to prompt the user via the " + Utils.classToString(EnterManyValues.class) + " source, using the " + PropertiesParameterPanel.PropertyType.PASSWORD + " type for the parameter. The password can then be inserted via a variable in the additional options.";
    }

    public Class[] getClassCrossReferences() {
        return new Class[]{EnterManyValues.class};
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("executable", "executable", (Object)new PlaceholderFile(this.getKeytoolExecutablePath()), false);
        this.m_OptionManager.add("additional", "additionalOptions", (Object)"");
    }

    protected String getKeytoolExecutablePath() {
        return Utils.unDoubleQuote((String)adams.core.management.Keytool.getExecutablePath());
    }

    public void setExecutable(PlaceholderFile value) {
        this.m_Executable = value;
        this.reset();
    }

    public PlaceholderFile getExecutable() {
        return this.m_Executable;
    }

    public String executableTipText() {
        return "The full path to the keytool executable.";
    }

    public void setAdditionalOptions(String value) {
        this.m_AdditionalOptions = value;
        this.reset();
    }

    public String getAdditionalOptions() {
        return this.m_AdditionalOptions;
    }

    public String additionalOptionsTipText() {
        return "Additional options for the keytool execution, supports inline variables.";
    }

    protected boolean canProcessInput(Token token) {
        return super.canProcessInput(token);
    }

    protected Token createTeeToken(Token token) {
        String additional = this.getVariables().expand(this.m_AdditionalOptions);
        if (this.isLoggingEnabled()) {
            this.getLogger().info("additional options: " + additional);
        }
        String outputStr = adams.core.management.Keytool.execute((String)this.m_Executable.getAbsolutePath(), (String)additional);
        if (this.isLoggingEnabled()) {
            this.getLogger().info("output: " + outputStr);
        }
        Token result = new Token((Object)outputStr);
        return result;
    }
}

