/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.ActorUtils;
import adams.flow.core.KeyManagerFactoryProvider;
import adams.flow.core.SSLContextProvider;
import adams.flow.core.TrustManagerFactoryProvider;
import adams.flow.standalone.AbstractStandalone;

public class SSLContext
extends AbstractStandalone
implements SSLContextProvider {
    private static final long serialVersionUID = 3010371119440218991L;
    protected String m_Protocol;
    protected boolean m_UseDefaultContext;
    protected transient KeyManagerFactoryProvider m_KeyManager;
    protected transient TrustManagerFactoryProvider m_TrustManager;
    protected transient javax.net.ssl.SSLContext m_SSLContext;

    public String globalInfo() {
        return "Initializes an SSL context using the specified context.\nFor protocols, see:\nhttps://docs.oracle.com/en/java/javase/11/docs/specs/security/standard-names.html#sslcontext-algorithms\nRequires " + Utils.classToString(KeyManagerFactoryProvider.class) + " and " + Utils.classToString(TrustManagerFactoryProvider.class) + " standalones to be present.\nYou don't have to use these actors if you enable the 'useDefaultContext' option.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("protocol", "protocol", (Object)"TLSv1.2");
        this.m_OptionManager.add("use-default-context", "useDefaultContext", (Object)false);
    }

    public String getQuickInfo() {
        String result = this.m_UseDefaultContext ? "default context" : QuickInfoHelper.toString((OptionHandler)this, (String)"protocol", (Object)this.m_Protocol);
        return result;
    }

    public void setProtocol(String value) {
        this.m_Protocol = value;
        this.reset();
    }

    public String getProtocol() {
        return this.m_Protocol;
    }

    public String protocolTipText() {
        return "The protocol to use, eg TLSv1, TLSv1.1 or TLSv1.2.";
    }

    public void setUseDefaultContext(boolean value) {
        this.m_UseDefaultContext = value;
        this.reset();
    }

    public boolean getUseDefaultContext() {
        return this.m_UseDefaultContext;
    }

    public String useDefaultContextTipText() {
        return "If enabled, the default SSL context is used (doesn't require the keymanager/trustmanager).";
    }

    public String setUp() {
        String result = super.setUp();
        if (!this.m_UseDefaultContext) {
            if (result == null) {
                this.m_KeyManager = (KeyManagerFactoryProvider)ActorUtils.findClosestType((Actor)this, KeyManagerFactoryProvider.class, (boolean)true);
                if (this.m_KeyManager == null) {
                    result = "Failed to locate " + Utils.classToString(KeyManagerFactoryProvider.class) + " actor!";
                }
            }
            if (result == null) {
                this.m_TrustManager = (TrustManagerFactoryProvider)ActorUtils.findClosestType((Actor)this, TrustManagerFactoryProvider.class, (boolean)true);
                if (this.m_TrustManager == null) {
                    result = "Failed to locate " + Utils.classToString(TrustManagerFactoryProvider.class) + " actor!";
                }
            }
        }
        return result;
    }

    public javax.net.ssl.SSLContext getSSLContext() {
        return this.m_SSLContext;
    }

    protected String doExecute() {
        String result = null;
        this.m_SSLContext = null;
        try {
            if (this.m_UseDefaultContext) {
                this.getLogger().warning("Using default SSL context!");
                this.m_SSLContext = javax.net.ssl.SSLContext.getDefault();
            } else {
                this.m_SSLContext = javax.net.ssl.SSLContext.getInstance(this.m_Protocol);
                this.m_SSLContext.init(this.m_KeyManager.getKeyManagerFactory().getKeyManagers(), this.m_TrustManager.getTrustManagerFactory().getTrustManagers(), null);
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to instantiate SSL context!", e);
        }
        return result;
    }
}

