/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.io.FileUtils;
import adams.core.option.OptionHandler;
import adams.flow.core.KeyPairElement;
import adams.flow.sink.AbstractFileWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.KeyPair;

public class KeyPairFileWriter
extends AbstractFileWriter {
    private static final long serialVersionUID = 6251487815648451979L;
    protected KeyPairElement m_Type;

    public String globalInfo() {
        return "Writes either the private or public key of a key pair to disk using the binary DER format.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)KeyPairElement.PUBLIC);
    }

    public String getQuickInfo() {
        Object result = super.getQuickInfo();
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)((Object)this.m_Type), (String)", type: ");
        return result;
    }

    public void setType(KeyPairElement value) {
        this.m_Type = value;
        this.reset();
    }

    public KeyPairElement getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The key type to write to disk.";
    }

    public String outputFileTipText() {
        return "The file to write the key to.";
    }

    public Class[] accepts() {
        return new Class[]{KeyPair.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doExecute() {
        String result = null;
        KeyPair pair = (KeyPair)this.m_InputToken.getPayload(KeyPair.class);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.m_OutputFile.getAbsolutePath());
            switch (this.m_Type) {
                case PUBLIC: {
                    fos.write(pair.getPublic().getEncoded());
                    break;
                }
                case PRIVATE: {
                    fos.write(pair.getPrivate().getEncoded());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled key type: " + this.m_Type);
                }
            }
            fos.close();
        }
        catch (Exception e) {
            try {
                result = this.handleException("Failed to write key to file: " + this.m_OutputFile, e);
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(fos);
                throw throwable;
            }
            FileUtils.closeQuietly((OutputStream)fos);
        }
        FileUtils.closeQuietly((OutputStream)fos);
        return result;
    }
}

