/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.source.AbstractSimpleSource;
import java.security.KeyPair;
import java.security.SecureRandom;

public class KeyPairGenerator
extends AbstractSimpleSource {
    private static final long serialVersionUID = 262803436200996578L;
    protected String m_Type;
    protected int m_Size;
    protected String m_PRNG;

    public String globalInfo() {
        return "Generates a private/public key pair.\nFor algorithm types, see:\nhttps://docs.oracle.com/en/java/javase/11/docs/specs/security/standard-names.html#keygenerator-algorithms\nFor PRNG types, see:\nhttps://docs.oracle.com/en/java/javase/11/docs/specs/security/standard-names.html#securerandom-number-generation-algorithms";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)"RSA");
        this.m_OptionManager.add("size", "size", (Object)4096, (Number)1, null);
        this.m_OptionManager.add("prng", "PRNG", (Object)"");
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)this.m_Type, (String)"type: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"size", (Object)this.m_Size, (String)", size: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"PRNG", (Object)(this.m_PRNG.isEmpty() ? "strong, determined by system" : this.m_PRNG), (String)", prng: ");
        return result;
    }

    public void setType(String value) {
        this.m_Type = value;
        this.reset();
    }

    public String getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of the key pair algorithm, eg RSA.";
    }

    public void setSize(int value) {
        this.m_Size = value;
        this.reset();
    }

    public int getSize() {
        return this.m_Size;
    }

    public String sizeTipText() {
        return "The size of the key in bits.";
    }

    public void setPRNG(String value) {
        this.m_PRNG = value;
        this.reset();
    }

    public String getPRNG() {
        return this.m_PRNG;
    }

    public String PRNGTipText() {
        return "The pseudo random number generator to use, leave empty to let the system choose a strong one.";
    }

    public Class[] generates() {
        return new Class[]{KeyPair.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            java.security.KeyPairGenerator generator = java.security.KeyPairGenerator.getInstance(this.m_Type);
            generator.initialize(this.m_Size, this.m_PRNG.isEmpty() ? SecureRandom.getInstanceStrong() : SecureRandom.getInstance(this.m_PRNG));
            this.m_OutputToken = new Token((Object)generator.generateKeyPair());
        }
        catch (Exception e) {
            result = this.handleException("Failed to generate key pair!", e);
        }
        return result;
    }
}

