/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.KeyPairElement;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.security.Key;
import java.security.KeyPair;

public class GetKeyFromKeyPair
extends AbstractTransformer {
    private static final long serialVersionUID = 8559568660139311333L;
    protected KeyPairElement m_Type;

    public String globalInfo() {
        return "Retrieves the specified key from the key pair.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)KeyPairElement.PUBLIC);
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)((Object)this.m_Type), (String)"type: ");
    }

    public void setType(KeyPairElement value) {
        this.m_Type = value;
        this.reset();
    }

    public KeyPairElement getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The key type to retrieve.";
    }

    public Class[] accepts() {
        return new Class[]{KeyPair.class};
    }

    public Class[] generates() {
        return new Class[]{Key.class};
    }

    protected String doExecute() {
        KeyPair pair = (KeyPair)this.m_InputToken.getPayload(KeyPair.class);
        switch (this.m_Type) {
            case PUBLIC: {
                this.m_OutputToken = new Token((Object)pair.getPublic());
                break;
            }
            case PRIVATE: {
                this.m_OutputToken = new Token((Object)pair.getPrivate());
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled key type: " + this.m_Type);
            }
        }
        return null;
    }
}

