/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.io.SpreadSheet;
import adams.data.conversion.AbstractConversion;

public class TransposeSpreadSheet
extends AbstractConversion {
    private static final long serialVersionUID = 4733940137387662202L;
    protected boolean m_OnlyData;

    public String globalInfo() {
        return "Transposes a spreadsheet, i.e., swaps columns with rows.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("only-data", "onlyData", (Object)false);
    }

    public void setOnlyData(boolean value) {
        this.m_OnlyData = value;
        this.reset();
    }

    public boolean getOnlyData() {
        return this.m_OnlyData;
    }

    public String onlyDataTipText() {
        return "If enabled, only the data gets transposed and not the header row as well.";
    }

    public Class accepts() {
        return SpreadSheet.class;
    }

    public Class generates() {
        return SpreadSheet.class;
    }

    protected Object doConvert() throws Exception {
        String value;
        SpreadSheet.Row rowIn;
        int n;
        int i;
        SpreadSheet result = new SpreadSheet();
        SpreadSheet input = (SpreadSheet)this.getInput();
        SpreadSheet.Row rowOut = result.getHeaderRow();
        for (i = 0; i < input.getRowCount(); ++i) {
            if (!this.m_OnlyData && i == 0) {
                rowOut.addCell("Header").setContent("Header");
            }
            rowOut.addCell("Row-" + (i + 1)).setContent("Row-" + (i + 1));
        }
        for (n = 0; n < input.getColumnCount(); ++n) {
            rowOut = result.addRow("Col-" + (result.getRowCount() + 1));
            for (i = 0; i < input.getRowCount(); ++i) {
                if (!this.m_OnlyData && i == 0) {
                    rowOut.addCell("Header").setContent("Header");
                }
                rowOut.addCell("Row-" + (i + 1));
            }
        }
        if (!this.m_OnlyData) {
            rowIn = input.getHeaderRow();
            for (n = 0; n < rowIn.getCellCount(); ++n) {
                value = rowIn.getCell(n).getContent();
                rowOut = result.getRow(n);
                rowOut.getCell("Header").setContent(value);
            }
        }
        for (i = 0; i < input.getRowCount(); ++i) {
            rowIn = input.getRow(i);
            for (n = 0; n < rowIn.getCellCount(); ++n) {
                value = rowIn.getCell(n).getContent();
                rowOut = result.getRow(n);
                rowOut.getCell("Row-" + (i + 1)).setContent(value);
            }
        }
        return result;
    }
}

