/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.core.Properties;
import adams.core.io.AbstractSpreadSheetReader;
import adams.core.io.CsvSpreadSheetReader;
import adams.core.io.CsvSpreadSheetWriter;
import adams.core.io.PlaceholderFile;
import adams.core.io.SpreadSheet;
import adams.env.Environment;
import adams.gui.chooser.SpreadSheetFileChooser;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseTabbedPane;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.core.RecentFilesHandler;
import adams.gui.core.SpreadSheetTable;
import adams.gui.event.RecentFileEvent;
import adams.gui.event.RecentFileListener;
import adams.gui.sendto.SendToActionSupporter;
import adams.gui.sendto.SendToActionUtils;
import com.googlecode.vfsjfilechooser2.VFSJFileChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SpreadSheetViewerPanel
extends BasePanel
implements MenuBarProvider,
SendToActionSupporter {
    private static final long serialVersionUID = -7759194648757624838L;
    public static final String FILENAME = "SpreadSheetViewer.props";
    public static final String SESSION_FILE = "CSVViewerSession.props";
    protected static Properties m_Properties;
    protected TabbedPane m_TabbedPane;
    protected JMenuBar m_MenuBar;
    protected JMenuItem m_MenuItemFileOpen;
    protected JMenu m_MenuItemFileOpenRecent;
    protected JMenuItem m_MenuItemFileClose;
    protected JMenuItem m_MenuItemFileExit;
    protected JMenuItem m_MenuItemViewDisplayedDecimals;
    protected JMenuItem m_MenuItemViewDisplayedDecimalsAll;
    protected SpreadSheetFileChooser m_FileChooser;
    protected RecentFilesHandler m_RecentFilesHandler;

    protected void initialize() {
        super.initialize();
        this.m_FileChooser = new SpreadSheetFileChooser();
        this.m_FileChooser.setMultiSelectionEnabled(true);
        this.m_RecentFilesHandler = null;
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_TabbedPane = new TabbedPane();
        this.m_TabbedPane.setCloseTabsWithMiddelMouseButton(true);
        this.add((Component)((Object)this.m_TabbedPane), "Center");
    }

    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            result = new JMenuBar();
            JMenu menu = new JMenu("File");
            result.add(menu);
            menu.setMnemonic('F');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    SpreadSheetViewerPanel.this.updateMenu();
                }
            });
            JMenuItem menuitem = new JMenuItem("Open...");
            menu.add(menuitem);
            menuitem.setMnemonic('O');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed O"));
            menuitem.setIcon(GUIHelper.getIcon((String)"open.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadSheetViewerPanel.this.open();
                }
            });
            this.m_MenuItemFileOpen = menuitem;
            JMenu submenu = new JMenu("Open recent");
            menu.add(submenu);
            this.m_RecentFilesHandler = new RecentFilesHandler(SESSION_FILE, SpreadSheetViewerPanel.getProperties().getInteger("MaxRecentFiles", Integer.valueOf(5)).intValue(), submenu);
            this.m_RecentFilesHandler.addRecentFileListener(new RecentFileListener(){

                public void recentFileAdded(RecentFileEvent e) {
                }

                public void recentFileSelected(RecentFileEvent e) {
                    SpreadSheetViewerPanel.this.load(e.getFile());
                }
            });
            this.m_MenuItemFileOpenRecent = submenu;
            menuitem = new JMenuItem("Close tab");
            menu.add(menuitem);
            menuitem.setMnemonic('t');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed W"));
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadSheetViewerPanel.this.closeFile();
                }
            });
            this.m_MenuItemFileClose = menuitem;
            menu.addSeparator();
            if (SendToActionUtils.addSendToSubmenu((SendToActionSupporter)this, (JMenu)menu)) {
                menu.addSeparator();
            }
            menuitem = new JMenuItem("Close");
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed Q"));
            menuitem.setIcon(GUIHelper.getIcon((String)"exit.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadSheetViewerPanel.this.close();
                }
            });
            this.m_MenuItemFileExit = menuitem;
            menu = new JMenu("View");
            result.add(menu);
            menu.setMnemonic('V');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    SpreadSheetViewerPanel.this.updateMenu();
                }
            });
            menuitem = new JMenuItem("Displayed decimals (current file)...");
            menu.add(menuitem);
            menuitem.setMnemonic('d');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed D"));
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String valueStr = JOptionPane.showInputDialog("Please enter the number of decimals to display (-1 to display all):", (Object)SpreadSheetViewerPanel.this.m_TabbedPane.getNumDecimalsAt(SpreadSheetViewerPanel.this.m_TabbedPane.getSelectedIndex()));
                    if (valueStr == null) {
                        return;
                    }
                    int decimals = Integer.parseInt(valueStr);
                    SpreadSheetViewerPanel.this.m_TabbedPane.setNumDecimalsAt(SpreadSheetViewerPanel.this.m_TabbedPane.getSelectedIndex(), decimals);
                }
            });
            this.m_MenuItemViewDisplayedDecimals = menuitem;
            menuitem = new JMenuItem("Displayed decimals (all open files)...");
            menu.add(menuitem);
            menuitem.setMnemonic('i');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl shift pressed D"));
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String valueStr = JOptionPane.showInputDialog("Please enter the number of decimals to display (-1 to display all):");
                    if (valueStr == null) {
                        return;
                    }
                    int decimals = Integer.parseInt(valueStr);
                    SpreadSheetViewerPanel.this.m_TabbedPane.setNumDecimals(decimals);
                }
            });
            this.m_MenuItemViewDisplayedDecimalsAll = menuitem;
            this.m_MenuBar = result;
            this.updateMenu();
        } else {
            result = this.m_MenuBar;
        }
        return result;
    }

    protected void updateMenu() {
        if (this.m_MenuBar == null) {
            return;
        }
        this.m_MenuItemFileClose.setEnabled(this.m_TabbedPane.getTabCount() > 0 && this.m_TabbedPane.getSelectedIndex() != -1);
    }

    protected void open() {
        PlaceholderFile[] files;
        VFSJFileChooser.RETURN_TYPE retVal = this.m_FileChooser.showOpenDialog((Component)((Object)this));
        if (retVal != VFSJFileChooser.RETURN_TYPE.APPROVE) {
            return;
        }
        for (PlaceholderFile file : files = this.m_FileChooser.getSelectedPlaceholderFiles()) {
            this.load(this.m_FileChooser.getReader(), (File)file);
        }
    }

    public void load(File file) {
        this.load(this.m_FileChooser.getReaderForFile(file), file);
    }

    public void load(AbstractSpreadSheetReader reader, File file) {
        SpreadSheet sheet;
        if (reader == null) {
            reader = new CsvSpreadSheetReader();
        }
        if ((sheet = reader.read(file.getAbsolutePath())) == null) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Error loading spreadsheet file:\n" + file));
        } else {
            this.m_TabbedPane.addTab(file.getName(), (Component)new BaseScrollPane((Component)new SpreadSheetTable(sheet)));
            this.m_TabbedPane.setSelectedIndex(this.m_TabbedPane.getTabCount() - 1);
            this.m_FileChooser.setCurrentDirectory(file.getParentFile());
            if (this.m_RecentFilesHandler != null) {
                this.m_RecentFilesHandler.addRecentFile(file);
            }
        }
    }

    protected void closeFile() {
        int index = this.m_TabbedPane.getSelectedIndex();
        if (index == -1) {
            return;
        }
        this.m_TabbedPane.remove(index);
    }

    protected void close() {
        this.closeParent();
    }

    public Class[] getSendToClasses() {
        return new Class[]{PlaceholderFile.class, JTable.class};
    }

    public boolean hasSendToItem(Class[] cls) {
        return SendToActionUtils.isAvailable((Class[])new Class[]{PlaceholderFile.class, JTable.class}, (Class[])cls) && this.m_TabbedPane.getSelectedIndex() != -1;
    }

    public Object getSendToItem(Class[] cls) {
        int index = this.m_TabbedPane.getSelectedIndex();
        if (index == -1) {
            return null;
        }
        SpreadSheetTable result = null;
        if (SendToActionUtils.isAvailable(PlaceholderFile.class, (Class[])cls)) {
            CsvSpreadSheetWriter writer = new CsvSpreadSheetWriter();
            SpreadSheet sheet = this.m_TabbedPane.getTableAt(index).getSheet();
            if (!writer.write(sheet, (File)((PlaceholderFile)(result = SendToActionUtils.nextTmpFile((String)"spreadsheetviewer", (String)"csv"))))) {
                result = null;
            }
        } else if (SendToActionUtils.isAvailable(JTable.class, (Class[])cls)) {
            result = this.m_TabbedPane.getTableAt(index);
        }
        return result;
    }

    public static synchronized Properties getProperties() {
        if (m_Properties == null) {
            m_Properties = Environment.getInstance().read("spreadsheet viewer panel");
        }
        return m_Properties;
    }

    public static class TabbedPane
    extends BaseTabbedPane {
        private static final long serialVersionUID = -2048229771213837710L;

        public SpreadSheetTable getTableAt(int index) {
            SpreadSheetTable result;
            if (this.getComponentAt(index) instanceof JScrollPane) {
                JScrollPane pane = (JScrollPane)this.getComponentAt(index);
                result = (SpreadSheetTable)pane.getViewport().getView();
            } else {
                result = (SpreadSheetTable)this.getComponentAt(index);
            }
            return result;
        }

        public void setNumDecimalsAt(int index, int numDec) {
            this.getTableAt(index).setNumDecimals(numDec);
        }

        public int getNumDecimalsAt(int index) {
            return this.getTableAt(index).getNumDecimals();
        }

        public void setNumDecimals(int numDec) {
            for (int i = 0; i < this.getTabCount(); ++i) {
                this.setNumDecimalsAt(i, numDec);
            }
        }
    }
}

