/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * Invert.java
 * Copyright (C) 2012 University of Waikato, Hamilton, New Zealand
 */
package adams.data.spreadsheet.columnfinder;

import java.util.ArrayList;
import java.util.HashSet;

import adams.core.Utils;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;

/**
 * Inverts the selected columns of the provided sub-column-filter.
 * 
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 6066 $
 */
public class Invert
  extends AbstractFilteredColumnFinder {

  /** for serialization. */
  private static final long serialVersionUID = -3635836960365586341L;

  /**
   * Returns a string describing the object.
   *
   * @return 			a description suitable for displaying in the gui
   */
  @Override
  public String globalInfo() {
    return "Inverts the columns of the provided sub-column-filter.";
  }

  /**
   * Returns the columns of interest in the spreadsheet.
   * 
   * @param data	the spreadsheet to inspect
   * @return		the columns of interest
   */
  @Override
  protected int[] doFindColumns(SpreadSheet data) {
    int[]		result;
    HashSet<Integer>	set;
    int[]		indices;
    ArrayList<Integer>	list;
    int			i;
    Row			header;
    
    indices = m_ColumnFinder.findColumns(data);
    set     = new HashSet<Integer>(Utils.toList(indices));
    list    = new ArrayList<Integer>();
    header  = data.getHeaderRow();
    for (i = 0; i < header.getCellCount(); i++) {
      if (!set.contains(i))
	list.add(i);
    }
    result = Utils.toIntArray(list);
    
    return result;
  }
}
