/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * SpreadSheet.java
 * Copyright (C) 2012 University of Waikato, Hamilton, New Zealand
 */
package adams.gui.visualization.debug.inspectionhandler;

import java.util.ArrayList;
import java.util.Hashtable;

import adams.core.ClassLocator;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.Row;

/**
 * Provides further insight into spreadsheets.
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 6122 $
 */
public class SpreadSheet
  extends AbstractInspectionHandler {

  /**
   * Checks whether the handler can handle the specified class.
   *
   * @param cls		the class to check
   * @return		true if the handler can handle this type of object
   */
  @Override
  public boolean handles(Class cls) {
    return 
	   ClassLocator.isSubclass(adams.data.spreadsheet.SpreadSheet.class, cls)
	|| ClassLocator.hasInterface(Row.class, cls)
	|| ClassLocator.isSubclass(Cell.class, cls);
  }

  /**
   * Returns further inspection values.
   *
   * @param obj		the object to further inspect
   * @return		the named inspected values
   */
  @Override
  public Hashtable<String,Object> inspect(Object obj) {
    Hashtable<String,Object>		result;
    ArrayList				data;
    adams.data.spreadsheet.SpreadSheet	sheet;
    Row					row;
    Cell				cell;
    int					index;

    result = new Hashtable<String,Object>();

    if (obj instanceof adams.data.spreadsheet.SpreadSheet) {
      sheet = (adams.data.spreadsheet.SpreadSheet) obj;
      data  = new ArrayList(sheet.rows());
      result.put("Rows", data.toArray());
    }
    else if (obj instanceof Row) {
      row  = (Row) obj;
      data = new ArrayList(row.cells());
      result.put("Cells", data.toArray());
    }
    else if (obj instanceof Cell) {
      cell  = ((Cell) obj);
      index = cell.index();
      result.put("Name",    cell.getSpreadSheet().getHeaderRow().getCell(index).getContent());
      result.put("Index",   index);
      result.put("Type",    cell.getContentType());
      result.put("Content", cell.getContent());
    }

    return result;
  }
}
