/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Range;
import adams.core.io.PlaceholderFile;
import adams.core.option.AbstractArgumentOption;
import adams.data.io.input.AbstractSpreadSheetReader;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.ArrayProcess;
import adams.flow.control.Flow;
import adams.flow.control.Trigger;
import adams.flow.core.AbstractActor;
import adams.flow.sink.DumpFile;
import adams.flow.source.MultiFileSupplier;
import adams.flow.source.Start;
import adams.flow.transformer.SpreadSheetDifference;
import adams.flow.transformer.SpreadSheetFileReader;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SpreadSheetDifferenceTest
extends AbstractFlowTest {
    public SpreadSheetDifferenceTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("bolts.csv");
        this.m_TestHelper.copyResourceToTmp("simple1.csv");
        this.m_TestHelper.copyResourceToTmp("simple2.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.csv");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("bolts.csv");
        this.m_TestHelper.deleteFileFromTmp("simple1.csv");
        this.m_TestHelper.deleteFileFromTmp("simple2.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.csv");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.csv")});
    }

    public static Test suite() {
        return new TestSuite(SpreadSheetDifferenceTest.class);
    }

    public AbstractActor getActor() {
        Flow flow = new Flow();
        try {
            AbstractActor[] tmp1 = new AbstractActor[4];
            MultiFileSupplier tmp2 = new MultiFileSupplier();
            tmp2.setOutputArray(true);
            AbstractArgumentOption argOption = (AbstractArgumentOption)tmp2.getOptionManager().findByProperty("files");
            PlaceholderFile[] tmp3 = new PlaceholderFile[]{(PlaceholderFile)argOption.valueOf("${TMP}/bolts.csv"), (PlaceholderFile)argOption.valueOf("${TMP}/bolts.csv")};
            tmp2.setFiles(tmp3);
            tmp1[0] = tmp2;
            ArrayProcess tmp4 = new ArrayProcess();
            argOption = (AbstractArgumentOption)tmp4.getOptionManager().findByProperty("actors");
            AbstractActor[] tmp5 = new AbstractActor[1];
            SpreadSheetFileReader tmp6 = new SpreadSheetFileReader();
            argOption = (AbstractArgumentOption)tmp6.getOptionManager().findByProperty("reader");
            CsvSpreadSheetReader tmp8 = new CsvSpreadSheetReader();
            tmp6.setReader((AbstractSpreadSheetReader)tmp8);
            tmp5[0] = tmp6;
            tmp4.setActors(tmp5);
            tmp1[1] = tmp4;
            SpreadSheetDifference tmp9 = new SpreadSheetDifference();
            argOption = (AbstractArgumentOption)tmp9.getOptionManager().findByProperty("keyColumns");
            tmp9.setKeyColumns((Range)argOption.valueOf(""));
            tmp1[2] = tmp9;
            DumpFile tmp11 = new DumpFile();
            argOption = (AbstractArgumentOption)tmp11.getOptionManager().findByProperty("outputFile");
            tmp11.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile.csv"));
            tmp1[3] = tmp11;
            Trigger t1 = new Trigger();
            t1.setActors(tmp1);
            tmp1 = new AbstractActor[4];
            MultiFileSupplier tmp22 = new MultiFileSupplier();
            tmp22.setOutputArray(true);
            argOption = (AbstractArgumentOption)tmp22.getOptionManager().findByProperty("files");
            PlaceholderFile[] tmp32 = new PlaceholderFile[]{(PlaceholderFile)argOption.valueOf("${TMP}/simple1.csv"), (PlaceholderFile)argOption.valueOf("${TMP}/simple2.csv")};
            tmp22.setFiles(tmp32);
            tmp1[0] = tmp22;
            ArrayProcess tmp42 = new ArrayProcess();
            argOption = (AbstractArgumentOption)tmp42.getOptionManager().findByProperty("actors");
            AbstractActor[] tmp52 = new AbstractActor[1];
            SpreadSheetFileReader tmp62 = new SpreadSheetFileReader();
            argOption = (AbstractArgumentOption)tmp62.getOptionManager().findByProperty("reader");
            CsvSpreadSheetReader tmp82 = new CsvSpreadSheetReader();
            tmp62.setReader((AbstractSpreadSheetReader)tmp82);
            tmp52[0] = tmp62;
            tmp42.setActors(tmp52);
            tmp1[1] = tmp42;
            SpreadSheetDifference tmp92 = new SpreadSheetDifference();
            argOption = (AbstractArgumentOption)tmp92.getOptionManager().findByProperty("keyColumns");
            tmp92.setKeyColumns((Range)argOption.valueOf("1"));
            tmp1[2] = tmp92;
            DumpFile tmp112 = new DumpFile();
            argOption = (AbstractArgumentOption)tmp112.getOptionManager().findByProperty("outputFile");
            tmp112.setAppend(true);
            tmp112.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile.csv"));
            tmp1[3] = tmp112;
            Trigger t2 = new Trigger();
            t2.setActors(tmp1);
            flow.setActors(new AbstractActor[]{new Start(), t1, t2});
        }
        catch (Exception e) {
            SpreadSheetDifferenceTest.fail((String)("Failed to set up actor: " + e));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SpreadSheetDifferenceTest.runTest((Test)SpreadSheetDifferenceTest.suite());
    }
}

