/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Range;
import adams.core.io.PlaceholderFile;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Branch;
import adams.flow.control.Flow;
import adams.flow.control.Sequence;
import adams.flow.core.AbstractActor;
import adams.flow.core.GlobalActorReference;
import adams.flow.sink.DumpFile;
import adams.flow.sink.GlobalSink;
import adams.flow.source.SingleFileSupplier;
import adams.flow.standalone.GlobalActors;
import adams.flow.transformer.SpreadSheetFileReader;
import adams.flow.transformer.SpreadSheetSubset;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class SpreadSheetSubsetTest
extends AbstractFlowTest {
    public SpreadSheetSubsetTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("iris.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("iris.csv");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public AbstractActor getActor() {
        DumpFile df = new DumpFile();
        df.setName("out");
        df.setAppend(true);
        df.setOutputFile((PlaceholderFile)new TmpFile("dumpfile.txt"));
        GlobalActors ga = new GlobalActors();
        ga.setActors(new AbstractActor[]{df});
        SingleFileSupplier sfs = new SingleFileSupplier();
        sfs.setFile((PlaceholderFile)new TmpFile("iris.csv"));
        SpreadSheetFileReader ssr = new SpreadSheetFileReader();
        SpreadSheetSubset ssc1 = new SpreadSheetSubset();
        ssc1.setRows(new Range("10-20"));
        ssc1.setColumns(new Range("1,3,last"));
        GlobalSink gs1 = new GlobalSink();
        gs1.setGlobalName(new GlobalActorReference("out"));
        Sequence seq1 = new Sequence();
        seq1.setActors(new AbstractActor[]{ssc1, gs1});
        SpreadSheetSubset ssc2 = new SpreadSheetSubset();
        ssc2.setRows(new Range("20-30"));
        ssc2.setColumns(new Range("2,4,last"));
        GlobalSink gs2 = new GlobalSink();
        gs2.setGlobalName(new GlobalActorReference("out"));
        Sequence seq2 = new Sequence();
        seq2.setActors(new AbstractActor[]{ssc2, gs2});
        SpreadSheetSubset ssc3 = new SpreadSheetSubset();
        ssc3.setRows(new Range("30-40"));
        ssc3.setColumns(new Range("1,2,last"));
        GlobalSink gs3 = new GlobalSink();
        gs3.setGlobalName(new GlobalActorReference("out"));
        Sequence seq3 = new Sequence();
        seq3.setActors(new AbstractActor[]{ssc3, gs3});
        Branch br = new Branch();
        br.setNumThreads(0);
        br.setBranches(new AbstractActor[]{seq1, seq2, seq3});
        Flow flow = new Flow();
        flow.setActors(new AbstractActor[]{ga, sfs, ssr, br});
        return flow;
    }

    public void testRegression() {
        this.performRegressionTest((File)new TmpFile("dumpfile.txt"));
    }

    public static Test suite() {
        return new TestSuite(SpreadSheetSubsetTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        SpreadSheetSubsetTest.runTest((Test)SpreadSheetSubsetTest.suite());
    }
}

