/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.Range;
import adams.data.conversion.AbstractSpreadSheetConversion;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import java.util.HashSet;

public class MergeSpreadSheetColumns
extends AbstractSpreadSheetConversion {
    private static final long serialVersionUID = -5364554292793461868L;
    protected Range m_Columns;
    protected String m_Glue;

    public String globalInfo() {
        return "Merges two or more columns in a spreadsheet into a single column.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("columns", "columns", (Object)new Range("first-last"));
        this.m_OptionManager.add("glue", "glue", (Object)"");
    }

    public void setColumns(Range value) {
        this.m_Columns = value;
        this.reset();
    }

    public Range getColumns() {
        return this.m_Columns;
    }

    public String columnsTipText() {
        return "The range of columns to merge into a single one; " + this.m_Columns.getExample();
    }

    public void setGlue(String value) {
        this.m_Glue = value;
        this.reset();
    }

    public String getGlue() {
        return this.m_Glue;
    }

    public String glueTipText() {
        return "The 'glue' string to use between two values that get merged.";
    }

    @Override
    protected SpreadSheet convert(SpreadSheet input) throws Exception {
        int i;
        this.m_Columns.setMax(input.getColumnCount());
        int[] indicesMerge = this.m_Columns.getIntIndices();
        if (indicesMerge.length < 2) {
            this.getSystemErr().println("Need at least two column indices to merge!");
            return input;
        }
        HashSet<Integer> hashMerge = new HashSet<Integer>();
        for (int index : indicesMerge) {
            hashMerge.add(index);
        }
        SpreadSheet result = input.getHeader();
        result.getHeaderRow().clear();
        int indexMerged = -1;
        String headerMerged = "";
        for (i = 0; i < indicesMerge.length; ++i) {
            if (i > 0) {
                headerMerged = headerMerged + this.m_Glue;
            }
            headerMerged = headerMerged + input.getHeaderRow().getCell(indicesMerge[i]);
        }
        HeaderRow headerInput = input.getHeaderRow();
        HeaderRow headerOutput = result.getHeaderRow();
        int n = 0;
        boolean first = true;
        for (i = 0; i < input.getColumnCount(); ++i) {
            if (hashMerge.contains(i)) {
                if (headerMerged != null) {
                    indexMerged = n;
                    headerOutput.addCell("" + n).setContentAsString(headerMerged);
                    headerMerged = null;
                }
                if (!first) continue;
                first = false;
                ++n;
                continue;
            }
            headerOutput.addCell("" + n).setContent(headerInput.getCell(i).getContent());
            ++n;
        }
        for (DataRow rowInput : input.rows()) {
            DataRow rowOutput = result.addRow();
            first = true;
            n = 0;
            for (i = 0; i < input.getColumnCount(); ++i) {
                if (hashMerge.contains(i)) {
                    String content = "?";
                    if (rowInput.hasCell(i) && !rowInput.getCell(i).isMissing()) {
                        content = rowInput.getCell(i).getContent();
                    }
                    if (!rowOutput.hasCell(indexMerged) || rowOutput.getCell(indexMerged).isMissing()) {
                        rowOutput.addCell("" + n).setContentAsString(content);
                    } else {
                        rowOutput.getCell(indexMerged).setContentAsString(rowOutput.getCell(indexMerged).getContent() + this.m_Glue + content);
                    }
                    if (!first) continue;
                    first = false;
                    ++n;
                    continue;
                }
                if (rowInput.hasCell(i) && !rowInput.getCell(i).isMissing()) {
                    rowOutput.addCell("" + n).setContent(rowInput.getCell(i).getContent());
                }
                ++n;
            }
        }
        return result;
    }
}

