/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.columnfinder;

import adams.core.Utils;
import adams.core.base.BaseRegExp;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.columnfinder.AbstractColumnFinder;
import java.util.ArrayList;

public class ByName
extends AbstractColumnFinder {
    private static final long serialVersionUID = 2989233908194930918L;
    protected BaseRegExp m_RegExp;

    public String globalInfo() {
        return "Returns the indices of columns which names match the provided regular expression.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("reg-exp", "regExp", (Object)new BaseRegExp(".*"));
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression to match the attribute names against.";
    }

    @Override
    protected int[] doFindColumns(SpreadSheet data) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        HeaderRow header = data.getHeaderRow();
        for (int i = 0; i < header.getCellCount(); ++i) {
            if (!this.m_RegExp.isMatch(header.getCell(i).getContent())) continue;
            result.add(i);
        }
        return Utils.toIntArray(result);
    }
}

