/*
 * Decompiled with CFR 0.152.
 */
package adams.data.spreadsheet.rowfinder;

import adams.core.Index;
import adams.core.Utils;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.rowfinder.AbstractRowFinder;
import java.util.ArrayList;

public class ByNumericValue
extends AbstractRowFinder {
    private static final long serialVersionUID = 235661615457187608L;
    public static final String NAN = "NaN";
    protected Index m_AttributeIndex;
    protected double m_Minimum;
    protected double m_Maximum;

    public String globalInfo() {
        return "Returns the indices of rows of columns which values fall inside the minimum and maximum (included).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("att-index", "attributeIndex", (Object)new Index("last"));
        this.m_OptionManager.add("minimum", "minimum", (Object)Double.NaN);
        this.m_OptionManager.add("maximum", "maximum", (Object)Double.NaN);
    }

    public void setAttributeIndex(Index value) {
        this.m_AttributeIndex = value;
        this.reset();
    }

    public Index getAttributeIndex() {
        return this.m_AttributeIndex;
    }

    public String attributeIndexTipText() {
        return "The index of the column to use for matching; " + this.m_AttributeIndex.getExample();
    }

    public void setMinimum(double value) {
        this.m_Minimum = value;
        this.reset();
    }

    public double getMinimum() {
        return this.m_Minimum;
    }

    public String minimumTipText() {
        return "The minimum value that the values must satisfy; use NaN (not a number) to ignore minimum.";
    }

    public void setMaximum(double value) {
        this.m_Maximum = value;
        this.reset();
    }

    public double getMaximum() {
        return this.m_Maximum;
    }

    public String maximumTipText() {
        return "The maximum value that the values must satisfy; use NaN (not a number) to ignore maximum.";
    }

    @Override
    protected int[] doFindRows(SpreadSheet data) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        this.m_AttributeIndex.setMax(data.getColumnCount());
        int index = this.m_AttributeIndex.getIntIndex();
        if (index == -1) {
            throw new IllegalStateException("Invalid index '" + this.m_AttributeIndex.getIndex() + "'?");
        }
        if (!data.isNumeric(index)) {
            throw new IllegalStateException("Column at index '" + this.m_AttributeIndex.getIndex() + "' is not numeric!");
        }
        for (int i = 0; i < data.getRowCount(); ++i) {
            Cell cell;
            DataRow row = data.getRow(i);
            if (!row.hasCell(index) || (cell = row.getCell(index)).isMissing() || !cell.isNumeric()) continue;
            double value = cell.toDouble();
            boolean add = true;
            if (!Double.isNaN(this.m_Minimum) && value < this.m_Minimum) {
                add = false;
            }
            if (!Double.isNaN(this.m_Maximum) && value > this.m_Maximum) {
                add = false;
            }
            if (!add) continue;
            result.add(i);
        }
        return Utils.toIntArray(result);
    }
}

