/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.db.AbstractDatabaseConnection;
import adams.db.SQL;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.sink.AbstractSink;
import adams.flow.standalone.DatabaseConnection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.HashSet;

public class SpreadSheetDbWriter
extends AbstractSink {
    private static final long serialVersionUID = 393925191813730213L;
    public static final String PLACEHOLDER_MAX = "@MAX";
    protected AbstractDatabaseConnection m_DatabaseConnection;
    protected String m_Table;
    protected Cell.ContentType[] m_Types;
    protected int m_MaxColumnLength;
    protected String[] m_ColumnNames;
    protected ColumnNameConversion m_ColumnNameConversion;
    protected String m_StringColumnSQL;
    protected int m_MaxStringLength;

    public String globalInfo() {
        return "Transfers a SpreadSheet object into a database.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("table", "table", (Object)"blah");
        this.m_OptionManager.add("column-name-conversion", "columnNameConversion", (Object)ColumnNameConversion.UPPER_CASE);
        this.m_OptionManager.add("max-string-length", "maxStringLength", (Object)50, (Number)1, null);
        this.m_OptionManager.add("string-column-sql", "stringColumnSQL", (Object)"VARCHAR(@MAX)");
    }

    public String getQuickInfo() {
        String result = "table: ";
        String variable = this.getOptionManager().getVariableForProperty("table");
        result = variable != null ? result + variable : result + this.m_Table;
        result = result + ", conversion: ";
        variable = this.getOptionManager().getVariableForProperty("columnNameConversion");
        result = variable != null ? result + variable : result + (Object)((Object)this.m_ColumnNameConversion);
        result = result + ", max string: ";
        variable = this.getOptionManager().getVariableForProperty("maxStringLength");
        result = variable != null ? result + variable : result + this.m_MaxStringLength;
        result = result + ", string type: ";
        variable = this.getOptionManager().getVariableForProperty("stringColumnSQL");
        result = variable != null ? result + variable : result + this.m_StringColumnSQL;
        return result;
    }

    public void setTable(String value) {
        this.m_Table = value;
        this.reset();
    }

    public String getTable() {
        return this.m_Table;
    }

    public String tableTipText() {
        return "The table to write the data to (gets automatically created).";
    }

    public void setColumnNameConversion(ColumnNameConversion value) {
        this.m_ColumnNameConversion = value;
        this.reset();
    }

    public ColumnNameConversion getColumnNameConversion() {
        return this.m_ColumnNameConversion;
    }

    public String columnNameConversionTipText() {
        return "How to convert the column headers into SQL table column names.";
    }

    public void setMaxStringLength(int value) {
        this.m_MaxStringLength = value;
        this.reset();
    }

    public int getMaxStringLength() {
        return this.m_MaxStringLength;
    }

    public String maxStringLengthTipText() {
        return "The maximum length for strings to enforce; can be used as @MAX in the 'stringColumnsSQL' property.";
    }

    public void setStringColumnSQL(String value) {
        this.m_StringColumnSQL = value;
        this.reset();
    }

    public String getStringColumnSQL() {
        return this.m_StringColumnSQL;
    }

    public String stringColumnSQLTipText() {
        return "The SQL type to use for STRING columns in the CREATE statement; you can use the @MAX placeholder to tie the type to the 'naxStringLength' property; see also: http://en.wikipedia.org/wiki/SQL";
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    protected AbstractDatabaseConnection getDatabaseConnection() {
        return ActorUtils.getDatabaseConnection((AbstractActor)this, DatabaseConnection.class, (AbstractDatabaseConnection)adams.db.DatabaseConnection.getSingleton());
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_DatabaseConnection = this.getDatabaseConnection();
        }
        return result;
    }

    protected String fixColumnName(String s) {
        String result = "";
        for (int i = 0; i < s.length(); ++i) {
            char chr = s.charAt(i);
            if (chr >= 'A' && chr <= 'Z') {
                result = result + chr;
            } else if (chr >= 'a' && chr <= 'z') {
                result = result + chr;
            }
            if (i < 0) continue;
            if (chr >= '0' && chr <= '9') {
                result = result + chr;
                continue;
            }
            if (chr != '_') continue;
            result = result + chr;
        }
        if (result.length() > this.m_MaxColumnLength) {
            result = result.substring(0, this.m_MaxColumnLength);
        }
        switch (this.m_ColumnNameConversion) {
            case AS_IS: {
                break;
            }
            case LOWER_CASE: {
                result = result.toLowerCase();
                break;
            }
            case UPPER_CASE: {
                result = result.toUpperCase();
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled conversion type: " + (Object)((Object)this.m_ColumnNameConversion));
            }
        }
        return result;
    }

    protected String determineSetup(SpreadSheet sheet) {
        int i;
        String result = null;
        this.m_MaxColumnLength = -1;
        try {
            DatabaseMetaData meta = this.m_DatabaseConnection.getConnection(false).getMetaData();
            this.m_MaxColumnLength = meta.getMaxColumnNameLength();
            if (this.m_MaxColumnLength == 0) {
                this.m_MaxColumnLength = Integer.MAX_VALUE;
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to obtain database meta-data!", e);
        }
        this.m_Types = new Cell.ContentType[sheet.getColumnCount()];
        if (result == null) {
            for (i = 0; i < sheet.getColumnCount(); ++i) {
                Cell.ContentType type;
                this.m_Types[i] = Cell.ContentType.STRING;
                if (sheet.isNumeric(i)) {
                    type = sheet.getContentType(i);
                    if (type == Cell.ContentType.LONG) {
                        this.m_Types[i] = Cell.ContentType.LONG;
                        continue;
                    }
                    if (type != Cell.ContentType.DOUBLE) continue;
                    this.m_Types[i] = Cell.ContentType.DOUBLE;
                    continue;
                }
                type = sheet.getContentType(i);
                if (type == null) {
                    type = Cell.ContentType.STRING;
                }
                switch (type) {
                    case TIME: 
                    case DATE: {
                        this.m_Types[i] = type;
                    }
                }
            }
        }
        this.m_ColumnNames = new String[sheet.getColumnCount()];
        if (result == null) {
            HashSet<String> names = new HashSet<String>();
            for (i = 0; i < sheet.getColumnCount(); ++i) {
                String name = sheet.getHeaderRow().getCell(i).getContent();
                String prefix = name = this.fixColumnName(name);
                int count = 0;
                while (names.contains(name)) {
                    if (new String(prefix + ++count).length() > this.m_MaxColumnLength) {
                        prefix = prefix.substring(0, prefix.length() - 1);
                    }
                    name = prefix + count;
                }
                names.add(name);
                this.m_ColumnNames[i] = name;
            }
        }
        if (this.isDebugOn()) {
            for (i = 0; i < sheet.getColumnCount(); ++i) {
                this.debug(sheet.getHeaderRow().getCell(i).getContent() + ": " + this.m_ColumnNames[i] + ", " + this.m_Types[i]);
            }
        }
        return result;
    }

    protected String createTable(SQL sql, SpreadSheet sheet) {
        String result = null;
        String stringType = this.m_StringColumnSQL.replace(PLACEHOLDER_MAX, "" + this.m_MaxStringLength);
        StringBuilder query = new StringBuilder("CREATE TABLE " + this.m_Table + "(");
        block8: for (int i = 0; i < sheet.getColumnCount(); ++i) {
            if (i > 0) {
                query.append(", ");
            }
            switch (this.m_Types[i]) {
                case LONG: {
                    query.append(this.m_ColumnNames[i] + " INTEGER");
                    continue block8;
                }
                case DOUBLE: {
                    query.append(this.m_ColumnNames[i] + " DOUBLE PRECISION");
                    continue block8;
                }
                case DATE: {
                    query.append(this.m_ColumnNames[i] + " TIMESTAMP");
                    continue block8;
                }
                case TIME: {
                    query.append(this.m_ColumnNames[i] + " TIME");
                    continue block8;
                }
                default: {
                    query.append(this.m_ColumnNames[i] + " " + stringType);
                }
            }
        }
        query.append(");");
        try {
            Boolean rs;
            if (this.isDebugOn()) {
                this.debug("Creating table: " + query);
            }
            if ((rs = sql.execute(query.toString())) == null) {
                result = "Failed to create table, check console!";
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to create table '" + this.m_Table + "' using: " + query, e);
        }
        return result;
    }

    protected String writeData(SQL sql, SpreadSheet sheet) {
        PreparedStatement stmt;
        int i;
        String result = null;
        StringBuilder query = new StringBuilder("INSERT INTO " + this.m_Table + "(");
        for (i = 0; i < sheet.getColumnCount(); ++i) {
            if (i > 0) {
                query.append(", ");
            }
            query.append(this.m_ColumnNames[i]);
        }
        query.append(") VALUES (");
        for (i = 0; i < sheet.getColumnCount(); ++i) {
            if (i > 0) {
                query.append(", ");
            }
            query.append("?");
        }
        query.append(");");
        try {
            stmt = sql.prepareStatement(query.toString());
        }
        catch (Exception e) {
            result = this.handleException("Failed to prepare statement: " + query, e);
            stmt = null;
        }
        if (result == null) {
            int count = 0;
            for (DataRow row : sheet.rows()) {
                if (this.m_Stopped) break;
                ++count;
                try {
                    block19: for (i = 0; i < sheet.getColumnCount(); ++i) {
                        Cell cell = row.getCell(i);
                        if (cell == null || cell.isMissing()) {
                            int type;
                            switch (this.m_Types[i]) {
                                case DATE: {
                                    type = 93;
                                    break;
                                }
                                case TIME: {
                                    type = 92;
                                    break;
                                }
                                case DOUBLE: {
                                    type = 8;
                                    break;
                                }
                                case LONG: {
                                    type = 4;
                                    break;
                                }
                                default: {
                                    type = 12;
                                }
                            }
                            stmt.setNull(i + 1, type);
                            continue;
                        }
                        switch (this.m_Types[i]) {
                            case DATE: {
                                stmt.setDate(i + 1, new Date(cell.toDate().getTime()));
                                continue block19;
                            }
                            case TIME: {
                                stmt.setTime(i + 1, cell.toTime());
                                continue block19;
                            }
                            case DOUBLE: {
                                stmt.setDouble(i + 1, cell.toDouble());
                                continue block19;
                            }
                            case LONG: {
                                stmt.setInt(i + 1, cell.toLong().intValue());
                                continue block19;
                            }
                            default: {
                                String str = cell.getContent();
                                if (str.length() > this.m_MaxStringLength) {
                                    str = str.substring(0, this.m_MaxStringLength);
                                }
                                stmt.setString(i + 1, str);
                            }
                        }
                    }
                    stmt.execute();
                }
                catch (Exception e) {
                    result = this.handleException("Failed to insert data: " + row + "\nusing: " + stmt, e);
                    break;
                }
                if (count % 1000 != 0) continue;
                this.getSystemOut().println(count + " rows processed");
            }
        }
        SQL.close((Statement)stmt);
        return result;
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        SQL sql = new SQL(this.m_DatabaseConnection);
        result = this.determineSetup(sheet);
        if (result == null && !sql.tableExists(this.m_Table)) {
            result = this.createTable(sql, sheet);
        }
        if (result == null) {
            result = this.writeData(sql, sheet);
        }
        return result;
    }

    public void wrapUp() {
        this.m_DatabaseConnection = null;
        super.wrapUp();
    }

    public static enum ColumnNameConversion {
        AS_IS,
        LOWER_CASE,
        UPPER_CASE;

    }
}

