/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.DateUtils;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.sink.AbstractDisplayPanel;
import adams.flow.sink.AbstractTextDisplayPanel;
import adams.flow.sink.AbstractTextualDisplay;
import adams.flow.sink.DisplayPanelProvider;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.ColorHelper;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.SpreadSheetTableModel;
import adams.gui.sendto.SendToActionUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.Date;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.TableModel;

public class SpreadSheetDisplay
extends AbstractTextualDisplay
implements DisplayPanelProvider {
    private static final long serialVersionUID = 3247255046513744115L;
    protected SpreadSheetTable m_Table;
    protected SpreadSheetTableModel m_TableModel;
    protected int m_NumDecimals;
    protected boolean m_UseCustomNegativeBackground;
    protected Color m_NegativeBackground;
    protected boolean m_UseCustomPositiveBackground;
    protected Color m_PositiveBackground;

    public String globalInfo() {
        return "Actor for displaying a spreadsheet.\nCustom background for negative/positive values can be specified as well.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-decimals", "numDecimals", (Object)3, (Number)-1, null);
        this.m_OptionManager.add("use-custom-negative-background", "useCustomNegativeBackground", (Object)false);
        this.m_OptionManager.add("negative-background", "negativeBackground", (Object)Color.WHITE);
        this.m_OptionManager.add("use-custom-positive-background", "useCustomPositiveBackground", (Object)false);
        this.m_OptionManager.add("positive-background", "positiveBackground", (Object)Color.WHITE);
    }

    public String getQuickInfo() {
        String result = super.getQuickInfo();
        String variable = this.getOptionManager().getVariableForProperty("numDecimals");
        result = result + ", decimals: ";
        result = variable != null ? result + variable : result + this.m_NumDecimals;
        if (this.m_UseCustomNegativeBackground) {
            result = result + ", negative: ";
            variable = this.getOptionManager().getVariableForProperty("negativeBackground");
            result = variable != null ? result + variable : result + ColorHelper.toHex((Color)this.m_NegativeBackground);
        }
        if (this.m_UseCustomPositiveBackground) {
            result = result + ", positive: ";
            variable = this.getOptionManager().getVariableForProperty("positiveBackground");
            result = variable != null ? result + variable : result + ColorHelper.toHex((Color)this.m_PositiveBackground);
        }
        return result;
    }

    public void setNumDecimals(int value) {
        this.m_NumDecimals = value;
        this.reset();
    }

    public int getNumDecimals() {
        return this.m_NumDecimals;
    }

    public String numDecimalsTipText() {
        return "The number of decimals for numeric values.";
    }

    public void setUseCustomNegativeBackground(boolean value) {
        this.m_UseCustomNegativeBackground = value;
        this.reset();
    }

    public boolean getUseCustomNegativeBackground() {
        return this.m_UseCustomNegativeBackground;
    }

    public String useCustomNegativeBackgroundTipText() {
        return "Whether to use a custom background color for negative values.";
    }

    public void setNegativeBackground(Color value) {
        this.m_NegativeBackground = value;
        this.reset();
    }

    public Color getNegativeBackground() {
        return this.m_NegativeBackground;
    }

    public String negativeBackgroundTipText() {
        return "The custom background for negative values (must be enabled).";
    }

    public void setUseCustomPositiveBackground(boolean value) {
        this.m_UseCustomPositiveBackground = value;
        this.reset();
    }

    public boolean getUseCustomPositiveBackground() {
        return this.m_UseCustomPositiveBackground;
    }

    public String useCustomPositiveBackgroundTipText() {
        return "Whether to use a custom background color for positive values.";
    }

    public void setPositiveBackground(Color value) {
        this.m_PositiveBackground = value;
        this.reset();
    }

    public Color getPositiveBackground() {
        return this.m_PositiveBackground;
    }

    public String positiveBackgroundTipText() {
        return "The custom background for positive values (must be enabled).";
    }

    protected int getDefaultWidth() {
        return 640;
    }

    protected int getDefaultHeight() {
        return 480;
    }

    public void clearPanel() {
        this.m_TableModel = new SpreadSheetTableModel(new SpreadSheet());
        this.m_Table = new SpreadSheetTable(this.m_TableModel);
    }

    public BasePanel newPanel() {
        BasePanel result = new BasePanel((LayoutManager)new BorderLayout());
        this.m_TableModel = new SpreadSheetTableModel(new SpreadSheet());
        this.m_Table = new SpreadSheetTable(this.m_TableModel);
        result.add((Component)new BaseScrollPane((Component)this.m_Table), (Object)"Center");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    protected void display(Token token) {
        this.m_TableModel = new SpreadSheetTableModel((SpreadSheet)token.getPayload());
        this.m_Table.setModel((TableModel)this.m_TableModel);
        this.m_Table.setNumDecimals(this.m_NumDecimals);
        if (this.m_UseCustomNegativeBackground) {
            this.m_Table.setNegativeBackground(this.m_NegativeBackground);
        } else {
            this.m_Table.setNegativeBackground(null);
        }
        if (this.m_UseCustomPositiveBackground) {
            this.m_Table.setPositiveBackground(this.m_PositiveBackground);
        } else {
            this.m_Table.setPositiveBackground(null);
        }
    }

    public AbstractDisplayPanel createDisplayPanel(Token token) {
        AbstractTextDisplayPanel result = new AbstractTextDisplayPanel("SpreadSheet"){
            private static final long serialVersionUID = 3524967045456783678L;
            protected SpreadSheetTable m_Table;
            protected SpreadSheetTableModel m_TableModel;

            protected void initGUI() {
                super.initGUI();
                this.setLayout(new BorderLayout());
                this.m_TableModel = new SpreadSheetTableModel(new SpreadSheet());
                this.m_Table = new SpreadSheetTable(this.m_TableModel);
                this.add((Component)new BaseScrollPane((Component)this.m_Table), "Center");
            }

            public void display(Token token) {
                this.m_TableModel = new SpreadSheetTableModel((SpreadSheet)token.getPayload());
                this.m_Table.setModel((TableModel)this.m_TableModel);
                this.m_Table.setNumDecimals(SpreadSheetDisplay.this.m_NumDecimals);
                if (SpreadSheetDisplay.this.m_UseCustomNegativeBackground) {
                    this.m_Table.setNegativeBackground(SpreadSheetDisplay.this.m_NegativeBackground);
                } else {
                    this.m_Table.setNegativeBackground(null);
                }
                if (SpreadSheetDisplay.this.m_UseCustomPositiveBackground) {
                    this.m_Table.setPositiveBackground(SpreadSheetDisplay.this.m_PositiveBackground);
                } else {
                    this.m_Table.setPositiveBackground(null);
                }
            }

            public ExtensionFileFilter getCustomTextFileFilter() {
                return ExtensionFileFilter.getCsvFileFilter();
            }

            public String supplyText() {
                return this.m_TableModel.getSheet().toString();
            }

            public void clearPanel() {
                this.m_TableModel = new SpreadSheetTableModel();
                this.m_Table.setModel((TableModel)this.m_TableModel);
            }

            public void cleanUp() {
            }
        };
        result.display(token);
        return result;
    }

    public boolean displayPanelRequiresScrollPane() {
        return false;
    }

    protected String doExecute() {
        String result = null;
        if (this.m_Headless) {
            this.getSystemOut().println("\n--> " + DateUtils.getTimestampFormatterMsecs().format(new Date()) + "\n");
            this.getSystemOut().println(this.m_InputToken.getPayload());
        } else {
            result = super.doExecute();
        }
        return result;
    }

    public ExtensionFileFilter getCustomTextFileFilter() {
        return ExtensionFileFilter.getCsvFileFilter();
    }

    public String supplyText() {
        String result = null;
        if (this.m_TableModel != null) {
            result = this.m_TableModel.getSheet().toString();
        }
        return result;
    }

    public Class[] getSendToClasses() {
        Vector<Class> result = new Vector<Class>(Arrays.asList(super.getSendToClasses()));
        if (!result.contains(JTable.class)) {
            result.add(JTable.class);
        }
        return result.toArray(new Class[result.size()]);
    }

    public Object getSendToItem(Class[] cls) {
        Object result = null;
        if (SendToActionUtils.isAvailable(JTable.class, (Class[])cls)) {
            result = this.m_Table;
            if (this.m_Table.getRowCount() == 0) {
                result = null;
            }
        } else {
            result = super.getSendToItem(cls);
        }
        return result;
    }
}

