/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.Utils;
import adams.data.spreadsheet.DataRowType;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.db.AbstractDatabaseConnection;
import adams.db.SQL;
import adams.db.SQLStatement;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.Token;
import adams.flow.source.AbstractSource;
import adams.flow.standalone.DatabaseConnection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Date;

public class SpreadSheetDbReader
extends AbstractSource {
    private static final long serialVersionUID = 494594301273926225L;
    protected SQLStatement m_Query;
    protected DataRowType m_DataRowType;
    protected Token m_OutputToken;
    protected AbstractDatabaseConnection m_DatabaseConnection;

    public String globalInfo() {
        return "Returns a spreadsheet object generated from an SQL query.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("query", "query", (Object)new SQLStatement("select * from blah"));
        this.m_OptionManager.add("data-row-type", "dataRowType", (Object)DataRowType.DENSE);
    }

    protected void reset() {
        super.reset();
        this.m_OutputToken = null;
    }

    public String getQuickInfo() {
        String result = "query: ";
        String variable = this.getOptionManager().getVariableForProperty("query");
        result = variable != null ? result + variable : result + Utils.shorten((String)this.m_Query.stringValue(), (int)40);
        result = result + ",row type: ";
        variable = this.getOptionManager().getVariableForProperty("dataRowType");
        result = variable != null ? result + variable : result + this.m_DataRowType;
        return result;
    }

    public void setQuery(SQLStatement value) {
        this.m_Query = value;
        this.reset();
    }

    public SQLStatement getQuery() {
        return this.m_Query;
    }

    public String queryTipText() {
        return "The SQL query to use for generating the spreadsheet.";
    }

    public void setDataRowType(DataRowType value) {
        this.m_DataRowType = value;
        this.reset();
    }

    public DataRowType getDataRowType() {
        return this.m_DataRowType;
    }

    public String dataRowTypeTipText() {
        return "The type of row to use for the data.";
    }

    protected AbstractDatabaseConnection getDatabaseConnection() {
        return ActorUtils.getDatabaseConnection((AbstractActor)this, DatabaseConnection.class, (AbstractDatabaseConnection)adams.db.DatabaseConnection.getSingleton());
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_DatabaseConnection = this.getDatabaseConnection();
        }
        return result;
    }

    public Class[] generates() {
        return new Class[]{SpreadSheet.class};
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet sheet = null;
        ResultSet rs = null;
        try {
            int i;
            sheet = new SpreadSheet();
            sheet.setDataRowClass(this.m_DataRowType.getRowClass());
            SQL sql = new SQL(this.m_DatabaseConnection);
            rs = sql.getResultSet(this.m_Query.getValue());
            HeaderRow row = sheet.getHeaderRow();
            ResultSetMetaData meta = rs.getMetaData();
            int[] type = new int[meta.getColumnCount()];
            for (i = 1; i <= meta.getColumnCount(); ++i) {
                row.addCell("" + i).setContentAsString(meta.getColumnName(i));
                type[i - 1] = meta.getColumnType(i);
            }
            while (rs.next() && !this.m_Stopped) {
                row = sheet.addRow();
                for (i = 1; i <= sheet.getColumnCount(); ++i) {
                    switch (type[i - 1]) {
                        case 92: {
                            row.addCell(i - 1).setContent(rs.getTime(i));
                            break;
                        }
                        case 91: {
                            row.addCell(i - 1).setContent((Date)rs.getDate(i));
                            break;
                        }
                        case 93: {
                            row.addCell(i - 1).setContent((Date)rs.getTimestamp(i));
                            break;
                        }
                        case 4: {
                            row.addCell(i - 1).setContent(Integer.valueOf(rs.getInt(i)));
                            break;
                        }
                        case 6: {
                            row.addCell(i - 1).setContent(Float.valueOf(rs.getFloat(i)));
                            break;
                        }
                        case 8: {
                            row.addCell(i - 1).setContent(Double.valueOf(rs.getDouble(i)));
                            break;
                        }
                        default: {
                            row.addCell(i - 1).setContent(rs.getString(i));
                        }
                    }
                    if (!rs.wasNull()) continue;
                    row.getCell(i - 1).setMissing();
                }
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to retrieve data from database", e);
        }
        SQL.closeAll(rs);
        if (this.m_Stopped) {
            result = null;
        }
        if (result == null) {
            this.m_OutputToken = new Token((Object)sheet);
        }
        return result;
    }

    public Token output() {
        Token result = this.m_OutputToken;
        this.m_OutputToken = null;
        return result;
    }

    public boolean hasPendingOutput() {
        return this.m_OutputToken != null;
    }

    public void wrapUp() {
        this.m_DatabaseConnection = null;
        super.wrapUp();
    }
}

