/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.control.Storage;
import adams.flow.control.StorageName;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractSpreadSheetTransformer;
import java.util.Hashtable;

public class SpreadSheetAppend
extends AbstractSpreadSheetTransformer {
    private static final long serialVersionUID = -253714973019682939L;
    protected StorageName m_StorageName;

    public String globalInfo() {
        return "Appends the incoming spreadsheet to one in storage.\nIf there is none in storage yet, the incoming spreadsheet will simply get stored in storage.\nThe spreadsheets need not have the same structure, but it is assumed that column names are unique within a spreadsheet.\nThe combined spreadsheet is then forwarded.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", (Object)new StorageName());
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("storageName");
        String result = variable != null ? variable : this.m_StorageName.getValue();
        return result;
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name of the stored spreadsheet to append the incoming one.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doExecute() {
        String result = null;
        Storage storage = this.getStorageHandler().getStorage();
        synchronized (storage) {
            SpreadSheet stored = null;
            if (this.getStorageHandler().getStorage().has(this.m_StorageName)) {
                stored = (SpreadSheet)this.getStorageHandler().getStorage().get(this.m_StorageName);
            }
            if (this.isDebugOn()) {
                this.debug("Spreadsheet '" + this.m_StorageName + "' available from storage: " + (stored != null));
            }
            SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
            if (stored == null) {
                int i;
                stored = new SpreadSheet();
                HeaderRow headerStored = stored.getHeaderRow();
                HeaderRow headerSheet = sheet.getHeaderRow();
                for (i = 0; i < headerSheet.getCellCount(); ++i) {
                    headerStored.addCell("" + headerStored.getCellCount()).setContent(headerSheet.getCell(i).getContent());
                }
                for (int n = 0; n < sheet.getRowCount(); ++n) {
                    DataRow row = sheet.getRow(n);
                    DataRow newRow = stored.addRow();
                    for (i = 0; i < headerSheet.getCellCount(); ++i) {
                        String key = headerSheet.getCellKey(i);
                        if (row.getCell(key) == null) continue;
                        newRow.addCell(headerStored.getCellKey(i)).setContent(row.getCell(key).getContent());
                    }
                }
                this.getStorageHandler().getStorage().put(this.m_StorageName, (Object)stored);
                this.m_OutputToken = new Token((Object)sheet);
                if (this.isDebugOn()) {
                    this.debug("Spreadsheet added to storage: " + this.m_StorageName);
                }
            } else {
                int i;
                stored = stored.getClone();
                HeaderRow headerStored = stored.getHeaderRow();
                HeaderRow headerSheet = sheet.getHeaderRow();
                Hashtable<String, Integer> headerIndex = new Hashtable<String, Integer>();
                for (i = 0; i < headerStored.getCellCount(); ++i) {
                    headerIndex.put(headerStored.getCell(i).getContent(), i);
                }
                for (i = 0; i < headerSheet.getCellCount(); ++i) {
                    String key = headerSheet.getCell(i).getContent();
                    if (headerIndex.containsKey(key)) continue;
                    headerStored.addCell("" + headerStored.getCellCount()).setContent(key);
                    headerIndex.put(key, headerStored.getCellCount() - 1);
                }
                for (int n = 0; n < sheet.getRowCount(); ++n) {
                    DataRow row = sheet.getRow(n);
                    DataRow newRow = stored.addRow();
                    for (i = 0; i < headerSheet.getCellCount(); ++i) {
                        Integer index = (Integer)headerIndex.get(headerSheet.getCell(i).getContent());
                        if (index == null || !row.hasCell(headerSheet.getCellKey(i))) continue;
                        newRow.addCell(headerStored.getCellKey(index.intValue())).setContent(row.getCell(headerSheet.getCellKey(i)).getContent());
                    }
                }
                this.getStorageHandler().getStorage().put(this.m_StorageName, (Object)stored);
                this.m_OutputToken = new Token((Object)stored);
                if (this.isDebugOn()) {
                    this.debug("Appended #" + sheet.getRowCount() + " rows to stored one: " + this.m_StorageName);
                }
            }
        }
        return result;
    }
}

