/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.columnfinder.ColumnFinder;
import adams.data.spreadsheet.columnfinder.NullFinder;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractSpreadSheetTransformer;

public class SpreadSheetColumnFilter
extends AbstractSpreadSheetTransformer {
    private static final long serialVersionUID = 4527040722924866539L;
    protected ColumnFinder m_Finder;

    public String globalInfo() {
        return "Filters spreadsheets using the specified column finder.\nThe output contains all the columns that the specified finder selected.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("finder", "finder", (Object)new NullFinder());
    }

    public void setFinder(ColumnFinder value) {
        this.m_Finder = value;
        this.reset();
    }

    public ColumnFinder getFinder() {
        return this.m_Finder;
    }

    public String finderTipText() {
        return "The column finder to use for identifying columns for the output.";
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("finder");
        if (variable != null) {
            return variable;
        }
        if (this.m_Finder != null) {
            return this.m_Finder.getClass().getName();
        }
        return null;
    }

    protected String doExecute() {
        int i;
        String result = null;
        SpreadSheet input = (SpreadSheet)this.m_InputToken.getPayload();
        int[] indices = this.m_Finder.findColumns(input);
        SpreadSheet output = input.getHeader();
        HeaderRow header = output.getHeaderRow();
        header.clear();
        for (i = 0; i < indices.length; ++i) {
            header.addCell("" + indices[i]).setContent(input.getHeaderRow().getCell(indices[i]).getContent());
        }
        for (int n = 0; n < input.getRowCount(); ++n) {
            DataRow rowIn = input.getRow(n);
            DataRow rowOut = output.addRow();
            for (i = 0; i < indices.length; ++i) {
                if (!rowIn.hasCell(indices[i])) continue;
                rowOut.addCell(i).setContent(rowIn.getContent(indices[i]));
            }
        }
        this.m_OutputToken = new Token((Object)output);
        return result;
    }
}

