/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Index;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;

public class SpreadSheetGetCell
extends AbstractTransformer {
    private static final long serialVersionUID = -253714973019682939L;
    protected Index m_Row;
    protected Index m_Column;
    protected String m_Empty;

    public String globalInfo() {
        return "Extracts a single value from a spreadsheet.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("row", "row", (Object)new Index("1"));
        this.m_OptionManager.add("col", "column", (Object)new Index("1"));
        this.m_OptionManager.add("empty", "empty", (Object)"");
    }

    protected void initialize() {
        super.initialize();
        this.m_Row = new Index();
        this.m_Column = new Index();
    }

    public String getQuickInfo() {
        String variableRow = this.getOptionManager().getVariableForProperty("row");
        String variableCol = this.getOptionManager().getVariableForProperty("column");
        String variableEmpty = this.getOptionManager().getVariableForProperty("empty");
        String result = "row: ";
        result = variableRow != null ? result + variableRow : result + this.m_Row.getIndex();
        result = result + "/";
        result = result + "col: ";
        result = variableCol != null ? result + variableCol : result + this.m_Column.getIndex();
        if (variableEmpty != null) {
            result = result + ", empty: " + variableEmpty;
        } else if (this.m_Empty.length() > 0) {
            result = result + ", empty: " + this.m_Empty;
        }
        return result;
    }

    public void setRow(Index value) {
        this.m_Row = value;
        this.reset();
    }

    public Index getRow() {
        return this.m_Row;
    }

    public String rowTipText() {
        return "The row of the cell to retrieve; " + this.m_Row.getExample();
    }

    public void setColumn(Index value) {
        this.m_Column = value;
        this.reset();
    }

    public Index getColumn() {
        return this.m_Column;
    }

    public String columnTipText() {
        return "The column of the cell to retrieve; " + this.m_Column.getExample();
    }

    public void setEmpty(String value) {
        this.m_Empty = value;
        this.reset();
    }

    public String getEmpty() {
        return this.m_Empty;
    }

    public String emptyTipText() {
        return "The value to return in case the cell is empty.";
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        this.m_Row.setMax(sheet.getRowCount());
        this.m_Column.setMax(sheet.getColumnCount());
        if (this.m_Row.getIntIndex() == -1) {
            result = "Illegal row index ('" + this.m_Row.getIndex() + "')?";
        } else if (this.m_Column.getIntIndex() == -1) {
            result = "Illegal column index ('" + this.m_Column.getIndex() + "')?";
        } else {
            Cell cell = sheet.getCell(this.m_Row.getIntIndex(), this.m_Column.getIntIndex());
            String value = cell == null ? this.m_Empty : (cell.isMissing() ? "?" : cell.getContent());
            this.m_OutputToken = new Token((Object)value);
        }
        return result;
    }
}

