/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Index;
import adams.core.Placeholders;
import adams.core.Utils;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractInPlaceSpreadSheetTransformer;

public class SpreadSheetInsertColumn
extends AbstractInPlaceSpreadSheetTransformer {
    private static final long serialVersionUID = 9030574317512531337L;
    protected Index m_Position;
    protected boolean m_After;
    protected String m_Header;
    protected String m_Value;
    protected boolean m_ValueContainsPlaceholder;
    protected boolean m_ValueContainsVariable;

    public String globalInfo() {
        return "Inserts a column at a specific position into spreadsheets coming through.\nThe cells are initialized with a pre-defined value.";
    }

    protected void initialize() {
        super.initialize();
        this.m_Position = new Index();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("position", "position", (Object)new Index("last"));
        this.m_OptionManager.add("after", "after", (Object)false);
        this.m_OptionManager.add("header", "header", (Object)"New");
        this.m_OptionManager.add("value", "value", (Object)"?");
        this.m_OptionManager.add("placeholder", "valueContainsPlaceholder", (Object)false);
        this.m_OptionManager.add("variable", "valueContainsVariable", (Object)false);
    }

    public String getQuickInfo() {
        String result = "header: ";
        String variable = this.getOptionManager().getVariableForProperty("header");
        result = variable != null ? result + variable : result + "'" + this.getHeader() + "'";
        result = this.m_After ? result + ", after: " : result + ", at: ";
        variable = this.getOptionManager().getVariableForProperty("position");
        result = variable != null ? result + variable : result + this.m_Position.getIndex();
        result = result + ", insert: ";
        variable = this.getOptionManager().getVariableForProperty("value");
        result = variable != null ? result + variable : result + "'" + this.getValue() + "'";
        if (this.m_ValueContainsPlaceholder || this.m_ValueContainsVariable) {
            result = result + " [";
            if (this.m_ValueContainsPlaceholder) {
                result = result + "PH";
            }
            if (this.m_ValueContainsVariable) {
                if (!result.endsWith("[")) {
                    result = result + ", ";
                }
                result = result + "Var";
            }
            result = result + "]";
        }
        return result;
    }

    public void setPosition(Index value) {
        this.m_Position = value;
        this.reset();
    }

    public Index getPosition() {
        return this.m_Position;
    }

    public String positionTipText() {
        return "The position where to insert the column; " + this.m_Position.getExample();
    }

    public void setAfter(boolean value) {
        this.m_After = value;
        this.reset();
    }

    public boolean getAfter() {
        return this.m_After;
    }

    public String afterTipText() {
        return "If enabled, the column is inserted after the position instead of at the position.";
    }

    public void setHeader(String value) {
        this.m_Header = value;
        this.reset();
    }

    public String getHeader() {
        return this.m_Header;
    }

    public String headerTipText() {
        return "The name of the new column.";
    }

    public void setValue(String value) {
        this.m_Value = Utils.unbackQuoteChars((String)value);
        this.reset();
    }

    public String getValue() {
        return Utils.backQuoteChars((String)this.m_Value);
    }

    public String valueTipText() {
        return "The value to intialize the cells with; you can use '\\t' for tab, '\\n' for line-feed and '\\r' for carriage-return.";
    }

    public void setValueContainsPlaceholder(boolean value) {
        this.m_ValueContainsPlaceholder = value;
        this.reset();
    }

    public boolean getValueContainsPlaceholder() {
        return this.m_ValueContainsPlaceholder;
    }

    public String valueContainsPlaceholderTipText() {
        return "Set this to true to enable automatic placeholder expansion for the value string.";
    }

    public void setValueContainsVariable(boolean value) {
        this.m_ValueContainsVariable = value;
        this.reset();
    }

    public boolean getValueContainsVariable() {
        return this.m_ValueContainsVariable;
    }

    public String valueContainsVariableTipText() {
        return "Set this to true to enable automatic variable expansion for the value string.";
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet sheetOld = (SpreadSheet)this.m_InputToken.getPayload();
        String value = this.m_Value;
        if (this.m_ValueContainsVariable) {
            value = this.getVariables().expand(value);
        }
        if (this.m_ValueContainsPlaceholder) {
            value = Placeholders.getSingleton().expand(value).replace("\\", "/");
        }
        this.m_Position.setMax(sheetOld.getColumnCount());
        int pos = this.m_Position.getIntIndex();
        if (this.m_After) {
            ++pos;
        }
        SpreadSheet sheetNew = this.m_NoCopy ? sheetOld : sheetOld.getClone();
        sheetNew.insertColumn(pos, this.m_Header, value);
        this.m_OutputToken = new Token((Object)sheetNew);
        return result;
    }
}

