/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.Index;
import adams.core.Range;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.Row;
import adams.data.spreadsheet.SpreadSheet;
import adams.flow.container.SequencePlotterContainer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.util.Hashtable;
import java.util.Vector;

public class SpreadSheetPlotGenerator
extends AbstractTransformer {
    private static final long serialVersionUID = 1147935218531182101L;
    public static final String MISSING_CELL_VALUE = "MISSING";
    protected Range m_PlotColumns;
    protected Index m_XColumn;
    protected double m_DefaultCellValue;
    protected Range m_PrefixColumns;
    protected Vector<SequencePlotterContainer> m_Containers;

    public String globalInfo() {
        return "Outputs plot containers generated from a spreadsheet.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("columns", "plotColumns", (Object)"");
        this.m_OptionManager.add("x-column", "XColumn", (Object)"");
        this.m_OptionManager.add("default-cell-value", "defaultCellValue", (Object)-1.0);
        this.m_OptionManager.add("prefix-columns", "prefixColumns", (Object)new Range());
    }

    protected void initialize() {
        super.initialize();
        this.m_Containers = new Vector();
        this.m_PlotColumns = new Range();
        this.m_XColumn = new Index();
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("plotColumns");
        if (variable != null) {
            return variable;
        }
        if (this.m_PlotColumns.getRange().length() > 0) {
            return this.m_PlotColumns.getRange();
        }
        return null;
    }

    public void setPlotColumns(String value) {
        this.m_PlotColumns.setRange(value);
        this.reset();
    }

    public String getPlotColumns() {
        return this.m_PlotColumns.getRange();
    }

    public String plotColumnsTipText() {
        return "The range of columns to include in the plot; " + this.m_PlotColumns.getExample();
    }

    public void setXColumn(String value) {
        this.m_XColumn.setIndex(value);
        this.reset();
    }

    public String getXColumn() {
        return this.m_XColumn.getIndex();
    }

    public String XColumnTipText() {
        return "The (optional) index of the column which values to use as X values in the plot; " + this.m_XColumn.getExample();
    }

    public void setDefaultCellValue(double value) {
        this.m_DefaultCellValue = value;
        this.reset();
    }

    public double getDefaultCellValue() {
        return this.m_DefaultCellValue;
    }

    public String defaultCellValueTipText() {
        return "The default value for missing or non-numeric cells.";
    }

    public void setPrefixColumns(Range value) {
        this.m_PrefixColumns = value;
        this.reset();
    }

    public Range getPrefixColumns() {
        return this.m_PrefixColumns;
    }

    public String prefixColumnsTipText() {
        return "The range of columns to prefix the plot name with; " + this.m_PlotColumns.getExample();
    }

    public Class[] accepts() {
        return new Class[]{SpreadSheet.class};
    }

    protected String getCellString(Row row, int index) {
        String result = MISSING_CELL_VALUE;
        Cell cell = row.getCell(index);
        if (cell != null && !cell.isMissing()) {
            result = cell.getContent();
        }
        return result;
    }

    protected double getCellValue(Row row, int index) {
        double result = this.m_DefaultCellValue;
        Cell cell = row.getCell(index);
        if (cell != null && !cell.isMissing() && cell.isNumeric()) {
            result = Double.parseDouble(cell.getContent());
        }
        return result;
    }

    protected String doExecute() {
        int i;
        String result = null;
        SpreadSheet sheet = (SpreadSheet)this.m_InputToken.getPayload();
        this.m_PlotColumns.setMax(sheet.getColumnCount());
        this.m_XColumn.setMax(sheet.getColumnCount());
        this.m_PrefixColumns.setMax(sheet.getColumnCount());
        int xIndex = this.m_XColumn.getIntIndex();
        Hashtable<String, Integer> xIndexString = null;
        if (xIndex != -1 && !sheet.isNumeric(xIndex)) {
            xIndexString = new Hashtable<String, Integer>();
        }
        this.m_Containers.clear();
        int[] plotCols = this.m_PlotColumns.getIntIndices();
        String[] plotNames = new String[plotCols.length];
        int[] prefixCols = this.m_PrefixColumns.getIntIndices();
        for (i = 0; i < plotNames.length; ++i) {
            plotNames[i] = sheet.getHeaderRow().getCell(plotCols[i]).getContent();
        }
        for (i = 0; i < sheet.getRowCount(); ++i) {
            int n;
            DataRow row = sheet.getRow(i);
            String prefix = "";
            if (prefixCols.length > 0) {
                for (n = 0; n < prefixCols.length; ++n) {
                    if (n > 0) {
                        prefix = prefix + " ";
                    }
                    prefix = row.hasCell(prefixCols[n]) ? prefix + row.getCell(prefixCols[n]).getContent() : prefix + "?";
                }
                prefix = prefix + " ";
            }
            for (n = 0; n < plotCols.length; ++n) {
                SequencePlotterContainer cont;
                if (xIndex == -1) {
                    cont = new SequencePlotterContainer(prefix + plotNames[n], new Double(i), Double.valueOf(this.getCellValue((Row)row, plotCols[n])));
                } else {
                    if (xIndex == plotCols[n]) continue;
                    if (xIndexString == null) {
                        cont = new SequencePlotterContainer(prefix + plotNames[n], Double.valueOf(this.getCellValue((Row)row, xIndex)), Double.valueOf(this.getCellValue((Row)row, plotCols[n])));
                    } else {
                        if (!xIndexString.containsKey(row.getCell(xIndex).getContent())) {
                            xIndexString.put(row.getCell(xIndex).getContent(), xIndexString.size() + 1);
                        }
                        cont = new SequencePlotterContainer(prefix + plotNames[n], Double.valueOf(((Integer)xIndexString.get(row.getCell(xIndex).getContent())).intValue()), Double.valueOf(this.getCellValue((Row)row, plotCols[n])));
                    }
                }
                this.m_Containers.add(cont);
            }
        }
        return result;
    }

    public Class[] generates() {
        return new Class[]{SequencePlotterContainer.class};
    }

    public boolean hasPendingOutput() {
        return this.m_Containers.size() > 0;
    }

    public Token output() {
        Token result = new Token((Object)this.m_Containers.get(0));
        this.m_InputToken = null;
        this.m_Containers.remove(0);
        return result;
    }
}

