/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.HeaderRow;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.rowfinder.NullFinder;
import adams.data.spreadsheet.rowfinder.RowFinder;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractSpreadSheetTransformer;

public class SpreadSheetRowFilter
extends AbstractSpreadSheetTransformer {
    private static final long serialVersionUID = 3754073511732133649L;
    protected RowFinder m_Finder;

    public String globalInfo() {
        return "Filters spreadsheets using the specified row finder.\nThe output contains all the rows that the specified finder selected.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("finder", "finder", (Object)new NullFinder());
    }

    public void setFinder(RowFinder value) {
        this.m_Finder = value;
        this.reset();
    }

    public RowFinder getFinder() {
        return this.m_Finder;
    }

    public String finderTipText() {
        return "The row finder to use for identifying rows for the output.";
    }

    public String getQuickInfo() {
        String variable = this.getOptionManager().getVariableForProperty("finder");
        if (variable != null) {
            return variable;
        }
        if (this.m_Finder != null) {
            return this.m_Finder.getClass().getName();
        }
        return null;
    }

    protected String doExecute() {
        String result = null;
        SpreadSheet input = (SpreadSheet)this.m_InputToken.getPayload();
        int[] indices = this.m_Finder.findRows(input);
        SpreadSheet output = input.getHeader();
        HeaderRow header = output.getHeaderRow();
        for (int n = 0; n < indices.length; ++n) {
            DataRow rowIn = input.getRow(indices[n]);
            DataRow rowOut = output.addRow();
            for (int i = 0; i < header.getCellCount(); ++i) {
                if (!rowIn.hasCell(i)) continue;
                rowOut.addCell(i).setContent(rowIn.getContent(i));
            }
        }
        this.m_OutputToken = new Token((Object)output);
        return result;
    }
}

