/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools;

import adams.core.Properties;
import adams.core.Range;
import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.data.conversion.AbstractSpreadSheetConversion;
import adams.data.conversion.Conversion;
import adams.data.conversion.TransposeSpreadSheet;
import adams.data.io.input.AbstractSpreadSheetReader;
import adams.data.io.input.CsvSpreadSheetReader;
import adams.data.io.output.AbstractSpreadSheetWriter;
import adams.data.io.output.CsvSpreadSheetWriter;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.columnfinder.ByName;
import adams.data.spreadsheet.columnfinder.ColumnFinder;
import adams.data.spreadsheet.rowfinder.ByValue;
import adams.data.spreadsheet.rowfinder.RowFinder;
import adams.env.Environment;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorUtils;
import adams.flow.transformer.AbstractSpreadSheetTransformer;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.Convert;
import adams.flow.transformer.SpreadSheetColumnFilter;
import adams.flow.transformer.SpreadSheetDifference;
import adams.flow.transformer.SpreadSheetRowFilter;
import adams.flow.transformer.SpreadSheetSubset;
import adams.gui.chooser.SpreadSheetFileChooser;
import adams.gui.core.BasePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.core.ParameterPanel;
import adams.gui.core.RecentFilesHandler;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.SpreadSheetTableModel;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.event.RecentFileEvent;
import adams.gui.event.RecentFileListener;
import adams.gui.goe.GenericObjectEditorDialog;
import adams.gui.sendto.SendToActionSupporter;
import adams.gui.sendto.SendToActionUtils;
import adams.gui.tools.spreadsheetviewer.AbstractDataPlugin;
import adams.gui.tools.spreadsheetviewer.AbstractViewPlugin;
import adams.gui.tools.spreadsheetviewer.TabbedPane;
import com.googlecode.vfsjfilechooser2.VFSJFileChooser;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableModel;

public class SpreadSheetViewerPanel
extends BasePanel
implements MenuBarProvider,
SendToActionSupporter {
    private static final long serialVersionUID = -7759194648757624838L;
    public static final String FILENAME = "SpreadSheetViewer.props";
    public static final String SESSION_FILE = "CSVViewerSession.props";
    protected static Properties m_Properties;
    protected TabbedPane m_TabbedPane;
    protected JMenuBar m_MenuBar;
    protected JMenuItem m_MenuItemFileOpen;
    protected JMenu m_MenuItemFileOpenRecent;
    protected JMenuItem m_MenuItemFileSaveAs;
    protected JMenuItem m_MenuItemFileClose;
    protected JMenuItem m_MenuItemFileExit;
    protected JMenuItem m_MenuItemDataFilterColumns;
    protected JMenuItem m_MenuItemDataFilterRows;
    protected JMenuItem m_MenuItemDataComputeDifference;
    protected JMenuItem m_MenuItemDataConvert;
    protected JMenuItem m_MenuItemDataTransform;
    protected JCheckBoxMenuItem m_MenuItemViewApplyToAll;
    protected JMenuItem m_MenuItemViewDisplayedDecimals;
    protected JMenuItem m_MenuItemViewNegativeBackground;
    protected JMenuItem m_MenuItemViewPositiveBackground;
    protected JMenu m_MenuDataPlugins;
    protected JMenu m_MenuViewPlugins;
    protected SpreadSheetFileChooser m_FileChooser;
    protected RecentFilesHandler m_RecentFilesHandler;
    protected int m_NumDecimals;
    protected Color m_BackgroundNegative;
    protected Color m_BackgroundPositive;
    protected GenericObjectEditorDialog m_GOEColumnFinder;
    protected GenericObjectEditorDialog m_GOERowFinder;
    protected GenericObjectEditorDialog m_GOEConversion;
    protected GenericObjectEditorDialog m_GOETransformer;

    protected void initialize() {
        super.initialize();
        this.m_FileChooser = new SpreadSheetFileChooser();
        this.m_FileChooser.setMultiSelectionEnabled(true);
        this.m_RecentFilesHandler = null;
        this.m_NumDecimals = -1;
        this.m_BackgroundNegative = null;
        this.m_BackgroundPositive = null;
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_TabbedPane = new TabbedPane();
        this.m_TabbedPane.setCloseTabsWithMiddelMouseButton(true);
        this.add((Component)((Object)this.m_TabbedPane), "Center");
    }

    public JMenuBar getMenuBar() {
        JMenuBar result;
        if (this.m_MenuBar == null) {
            result = new JMenuBar();
            JMenu menu = new JMenu("File");
            result.add(menu);
            menu.setMnemonic('F');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    SpreadSheetViewerPanel.this.updateMenu();
                }
            });
            JMenuItem menuitem = new JMenuItem("Open...");
            menu.add(menuitem);
            menuitem.setMnemonic('O');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed O"));
            menuitem.setIcon(GUIHelper.getIcon((String)"open.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadSheetViewerPanel.this.open();
                }
            });
            this.m_MenuItemFileOpen = menuitem;
            JMenu submenu = new JMenu("Open recent");
            menu.add(submenu);
            this.m_RecentFilesHandler = new RecentFilesHandler(SESSION_FILE, SpreadSheetViewerPanel.getProperties().getInteger("MaxRecentFiles", Integer.valueOf(5)).intValue(), submenu);
            this.m_RecentFilesHandler.addRecentFileListener(new RecentFileListener(){

                public void recentFileAdded(RecentFileEvent e) {
                }

                public void recentFileSelected(RecentFileEvent e) {
                    SpreadSheetViewerPanel.this.load(e.getFile());
                }
            });
            this.m_MenuItemFileOpenRecent = submenu;
            menuitem = new JMenuItem("Save as...");
            menu.add(menuitem);
            menuitem.setMnemonic('S');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl shift pressed S"));
            menuitem.setIcon(GUIHelper.getIcon((String)"save.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadSheetViewerPanel.this.saveAs();
                }
            });
            this.m_MenuItemFileSaveAs = menuitem;
            menuitem = new JMenuItem("Close tab");
            menu.add(menuitem);
            menuitem.setMnemonic('t');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed W"));
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadSheetViewerPanel.this.closeFile();
                }
            });
            this.m_MenuItemFileClose = menuitem;
            menu.addSeparator();
            if (SendToActionUtils.addSendToSubmenu((SendToActionSupporter)this, (JMenu)menu)) {
                menu.addSeparator();
            }
            menuitem = new JMenuItem("Close");
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed Q"));
            menuitem.setIcon(GUIHelper.getIcon((String)"exit.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadSheetViewerPanel.this.close();
                }
            });
            this.m_MenuItemFileExit = menuitem;
            menu = new JMenu("Data");
            result.add(menu);
            menu.setMnemonic('D');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    SpreadSheetViewerPanel.this.updateMenu();
                }
            });
            menuitem = new JMenuItem("Filter columns...");
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setIcon(GUIHelper.getIcon((String)"filter_columns.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadSheetViewerPanel.this.findColumns();
                }
            });
            this.m_MenuItemDataFilterColumns = menuitem;
            menuitem = new JMenuItem("Filter rows...");
            menu.add(menuitem);
            menuitem.setMnemonic('R');
            menuitem.setIcon(GUIHelper.getIcon((String)"filter_rows.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadSheetViewerPanel.this.findRows();
                }
            });
            this.m_MenuItemDataFilterRows = menuitem;
            menuitem = new JMenuItem("Convert...");
            menu.add(menuitem);
            menuitem.setMnemonic('v');
            menuitem.setIcon(GUIHelper.getIcon((String)"convert_sheet.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadSheetViewerPanel.this.convert();
                }
            });
            this.m_MenuItemDataConvert = menuitem;
            menuitem = new JMenuItem("Transform...");
            menu.add(menuitem);
            menuitem.setMnemonic('T');
            menuitem.setIcon(GUIHelper.getIcon((String)"flow.gif"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadSheetViewerPanel.this.transform();
                }
            });
            this.m_MenuItemDataTransform = menuitem;
            menuitem = new JMenuItem("Compute difference...");
            menu.add(menuitem);
            menuitem.setMnemonic('C');
            menuitem.setIcon(GUIHelper.getIcon((String)"diff.png"));
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadSheetViewerPanel.this.computeDifference();
                }
            });
            this.m_MenuItemDataComputeDifference = menuitem;
            String[] classes = AbstractDataPlugin.getPlugins();
            if (classes.length > 0) {
                submenu = new JMenu("Plugin");
                menu.add(submenu);
                submenu.setMnemonic('P');
                submenu.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        SpreadSheetViewerPanel.this.updateMenu();
                    }
                });
                this.m_MenuDataPlugins = submenu;
                for (String cls : classes) {
                    try {
                        final AbstractDataPlugin data = (AbstractDataPlugin)((Object)Class.forName(cls).newInstance());
                        menuitem = data.getMenuIcon() == null ? new JMenuItem(data.getMenuText(), GUIHelper.getEmptyIcon()) : new JMenuItem(data.getMenuText(), GUIHelper.getIcon((String)data.getMenuIcon()));
                        menuitem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                SpreadSheetViewerPanel.this.process(data);
                            }
                        });
                        submenu.add(menuitem);
                    }
                    catch (Exception e) {
                        System.err.println("Failed to generate menu item for data plugin: " + cls);
                        e.printStackTrace();
                    }
                }
            }
            menu = new JMenu("View");
            result.add(menu);
            menu.setMnemonic('V');
            menu.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    SpreadSheetViewerPanel.this.updateMenu();
                }
            });
            menuitem = new JCheckBoxMenuItem("Apply to all");
            menu.add(menuitem);
            menuitem.setMnemonic('a');
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            this.m_MenuItemViewApplyToAll = (JCheckBoxMenuItem)menuitem;
            menuitem = new JMenuItem("Decimals...");
            menu.add(menuitem);
            menuitem.setMnemonic('d');
            menuitem.setAccelerator(GUIHelper.getKeyStroke((String)"ctrl pressed D"));
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadSheetViewerPanel.this.enterNumDecimals(SpreadSheetViewerPanel.this.m_MenuItemViewApplyToAll.isSelected());
                }
            });
            this.m_MenuItemViewDisplayedDecimals = menuitem;
            menuitem = new JMenuItem("Negative background...");
            menu.add(menuitem);
            menuitem.setMnemonic('n');
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadSheetViewerPanel.this.selectBackground(true, SpreadSheetViewerPanel.this.m_MenuItemViewApplyToAll.isSelected());
                }
            });
            this.m_MenuItemViewNegativeBackground = menuitem;
            menuitem = new JMenuItem("Positive background...");
            menu.add(menuitem);
            menuitem.setMnemonic('p');
            menuitem.setIcon(GUIHelper.getEmptyIcon());
            menuitem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpreadSheetViewerPanel.this.selectBackground(false, SpreadSheetViewerPanel.this.m_MenuItemViewApplyToAll.isSelected());
                }
            });
            this.m_MenuItemViewPositiveBackground = menuitem;
            classes = AbstractViewPlugin.getPlugins();
            if (classes.length > 0) {
                submenu = new JMenu("Plugin");
                menu.addSeparator();
                menu.add(submenu);
                submenu.setMnemonic('P');
                submenu.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        SpreadSheetViewerPanel.this.updateMenu();
                    }
                });
                this.m_MenuViewPlugins = submenu;
                for (String cls : classes) {
                    try {
                        final AbstractViewPlugin view = (AbstractViewPlugin)((Object)Class.forName(cls).newInstance());
                        menuitem = view.getMenuIcon() == null ? new JMenuItem(view.getMenuText(), GUIHelper.getEmptyIcon()) : new JMenuItem(view.getMenuText(), GUIHelper.getIcon((String)view.getMenuIcon()));
                        menuitem.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                SpreadSheetViewerPanel.this.view(view);
                            }
                        });
                        submenu.add(menuitem);
                    }
                    catch (Exception e) {
                        System.err.println("Failed to generate menu item for view plugin: " + cls);
                        e.printStackTrace();
                    }
                }
            }
            this.m_MenuBar = result;
            this.updateMenu();
        } else {
            result = this.m_MenuBar;
        }
        return result;
    }

    protected void enterNumDecimals(boolean applyAll) {
        int decimals = applyAll ? -1 : this.m_TabbedPane.getNumDecimalsAt(this.m_TabbedPane.getSelectedIndex());
        String valueStr = JOptionPane.showInputDialog("Please enter the number of decimals to display (-1 to display all):", (Object)decimals);
        if (valueStr == null) {
            return;
        }
        decimals = Integer.parseInt(valueStr);
        if (applyAll) {
            this.m_NumDecimals = decimals;
            this.m_TabbedPane.setNumDecimals(decimals);
        } else {
            this.m_NumDecimals = -1;
            this.m_TabbedPane.setNumDecimalsAt(this.m_TabbedPane.getSelectedIndex(), decimals);
        }
    }

    protected void selectBackground(boolean negative, boolean applyAll) {
        Color color = applyAll ? Color.WHITE : (negative ? this.m_TabbedPane.getNegativeBackgroundAt(this.m_TabbedPane.getSelectedIndex()) : this.m_TabbedPane.getPositiveBackgroundAt(this.m_TabbedPane.getSelectedIndex()));
        color = negative ? JColorChooser.showDialog((Component)((Object)this), "Background for negative values", color) : JColorChooser.showDialog((Component)((Object)this), "Background for positive values", color);
        if (color == null) {
            return;
        }
        if (negative) {
            if (applyAll) {
                this.m_BackgroundNegative = color;
                this.m_TabbedPane.setNegativeBackground(color);
            } else {
                this.m_BackgroundNegative = null;
                this.m_TabbedPane.setNegativeBackgroundAt(this.m_TabbedPane.getSelectedIndex(), color);
            }
        } else if (applyAll) {
            this.m_BackgroundPositive = color;
            this.m_TabbedPane.setPositiveBackground(color);
        } else {
            this.m_BackgroundPositive = null;
            this.m_TabbedPane.setPositiveBackgroundAt(this.m_TabbedPane.getSelectedIndex(), color);
        }
    }

    protected void updateMenu() {
        if (this.m_MenuBar == null) {
            return;
        }
        boolean sheetSelected = this.m_TabbedPane.getTabCount() > 0 && this.m_TabbedPane.getSelectedIndex() != -1;
        this.m_MenuItemFileSaveAs.setEnabled(sheetSelected);
        this.m_MenuItemFileClose.setEnabled(sheetSelected);
        this.m_MenuItemDataFilterColumns.setEnabled(sheetSelected);
        this.m_MenuItemDataFilterRows.setEnabled(sheetSelected);
        this.m_MenuItemDataConvert.setEnabled(sheetSelected);
        this.m_MenuItemDataTransform.setEnabled(sheetSelected);
        this.m_MenuItemDataComputeDifference.setEnabled(this.m_TabbedPane.getTabCount() >= 2);
        if (this.m_MenuDataPlugins != null) {
            this.m_MenuDataPlugins.setEnabled(sheetSelected);
        }
        this.m_MenuItemViewDisplayedDecimals.setEnabled(this.m_TabbedPane.getTabCount() > 0);
        this.m_MenuItemViewNegativeBackground.setEnabled(this.m_TabbedPane.getTabCount() > 0);
        this.m_MenuItemViewPositiveBackground.setEnabled(this.m_TabbedPane.getTabCount() > 0);
        if (this.m_MenuViewPlugins != null) {
            this.m_MenuViewPlugins.setEnabled(sheetSelected);
        }
    }

    protected void open() {
        PlaceholderFile[] files;
        VFSJFileChooser.RETURN_TYPE retVal = this.m_FileChooser.showOpenDialog((Component)((Object)this));
        if (retVal != VFSJFileChooser.RETURN_TYPE.APPROVE) {
            return;
        }
        for (PlaceholderFile file : files = this.m_FileChooser.getSelectedPlaceholderFiles()) {
            this.load(this.m_FileChooser.getReader(), (File)file);
        }
    }

    public void load(File file) {
        this.load(this.m_FileChooser.getReaderForFile(file), file);
    }

    protected SpreadSheetTable createTable(SpreadSheet sheet) {
        SpreadSheetTable result = new SpreadSheetTable(sheet);
        result.setNumDecimals(this.m_NumDecimals);
        result.setNegativeBackground(this.m_BackgroundNegative);
        result.setPositiveBackground(this.m_BackgroundPositive);
        return result;
    }

    public void load(AbstractSpreadSheetReader reader, File file) {
        SpreadSheet sheet;
        if (reader == null) {
            reader = new CsvSpreadSheetReader();
        }
        if ((sheet = reader.read(file.getAbsolutePath())) == null) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Error loading spreadsheet file:\n" + file));
        } else {
            this.m_TabbedPane.addTab(file.getName(), this.createTable(sheet));
            this.m_FileChooser.setCurrentDirectory(file.getParentFile());
            if (this.m_RecentFilesHandler != null) {
                this.m_RecentFilesHandler.addRecentFile(file);
            }
        }
    }

    public void write(AbstractSpreadSheetWriter writer, File file) {
        SpreadSheetTable table = this.m_TabbedPane.getCurrentTable();
        if (table == null) {
            return;
        }
        if (!writer.write(table.getSheet(), file)) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to write spreadsheet to '" + file + "'!"));
        }
    }

    protected void saveAs() {
        VFSJFileChooser.RETURN_TYPE retVal = this.m_FileChooser.showSaveDialog((Component)((Object)this));
        if (retVal != VFSJFileChooser.RETURN_TYPE.APPROVE) {
            return;
        }
        PlaceholderFile file = this.m_FileChooser.getSelectedPlaceholderFile();
        this.write(this.m_FileChooser.getWriter(), (File)file);
    }

    protected void closeFile() {
        int index = this.m_TabbedPane.getSelectedIndex();
        if (index == -1) {
            return;
        }
        this.m_TabbedPane.remove(index);
    }

    protected void close() {
        this.closeParent();
    }

    public Class[] getSendToClasses() {
        return new Class[]{PlaceholderFile.class, JTable.class};
    }

    public boolean hasSendToItem(Class[] cls) {
        return SendToActionUtils.isAvailable((Class[])new Class[]{PlaceholderFile.class, JTable.class}, (Class[])cls) && this.m_TabbedPane.getSelectedIndex() != -1;
    }

    public Object getSendToItem(Class[] cls) {
        int index = this.m_TabbedPane.getSelectedIndex();
        if (index == -1) {
            return null;
        }
        SpreadSheetTable result = null;
        if (SendToActionUtils.isAvailable(PlaceholderFile.class, (Class[])cls)) {
            CsvSpreadSheetWriter writer = new CsvSpreadSheetWriter();
            SpreadSheet sheet = this.m_TabbedPane.getTableAt(index).getSheet();
            if (!writer.write(sheet, (File)((PlaceholderFile)(result = SendToActionUtils.nextTmpFile((String)"spreadsheetviewer", (String)"csv"))))) {
                result = null;
            }
        } else if (SendToActionUtils.isAvailable(JTable.class, (Class[])cls)) {
            result = this.m_TabbedPane.getTableAt(index);
        }
        return result;
    }

    protected GenericObjectEditorDialog getColumnFinderDialog() {
        if (this.m_GOEColumnFinder == null) {
            this.m_GOEColumnFinder = this.getParentDialog() != null ? new GenericObjectEditorDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(this.getParentFrame(), true);
            this.m_GOEColumnFinder.setTitle("Column finder");
            this.m_GOEColumnFinder.getGOEEditor().setClassType(ColumnFinder.class);
            this.m_GOEColumnFinder.getGOEEditor().setCanChangeClassInDialog(true);
            this.m_GOEColumnFinder.getGOEEditor().setValue((Object)new ByName());
            this.m_GOEColumnFinder.setLocationRelativeTo((Component)((Object)this));
        }
        return this.m_GOEColumnFinder;
    }

    protected GenericObjectEditorDialog getRowFinderDialog() {
        if (this.m_GOERowFinder == null) {
            this.m_GOERowFinder = this.getParentDialog() != null ? new GenericObjectEditorDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(this.getParentFrame(), true);
            this.m_GOERowFinder.setTitle("Row finder");
            this.m_GOERowFinder.getGOEEditor().setClassType(RowFinder.class);
            this.m_GOERowFinder.getGOEEditor().setCanChangeClassInDialog(true);
            this.m_GOERowFinder.getGOEEditor().setValue((Object)new ByValue());
            this.m_GOERowFinder.setLocationRelativeTo((Component)((Object)this));
        }
        return this.m_GOERowFinder;
    }

    protected GenericObjectEditorDialog getConversionDialog() {
        if (this.m_GOEConversion == null) {
            this.m_GOEConversion = this.getParentDialog() != null ? new GenericObjectEditorDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(this.getParentFrame(), true);
            this.m_GOEConversion.setTitle("Conversion");
            this.m_GOEConversion.getGOEEditor().setClassType(AbstractSpreadSheetConversion.class);
            this.m_GOEConversion.getGOEEditor().setCanChangeClassInDialog(true);
            this.m_GOEConversion.getGOEEditor().setValue((Object)new TransposeSpreadSheet());
            this.m_GOEConversion.setLocationRelativeTo((Component)((Object)this));
        }
        return this.m_GOEConversion;
    }

    protected GenericObjectEditorDialog getTransformerDialog() {
        if (this.m_GOETransformer == null) {
            this.m_GOETransformer = this.getParentDialog() != null ? new GenericObjectEditorDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new GenericObjectEditorDialog(this.getParentFrame(), true);
            this.m_GOETransformer.setTitle("Transformer");
            this.m_GOETransformer.getGOEEditor().setClassType(AbstractSpreadSheetTransformer.class);
            this.m_GOETransformer.getGOEEditor().setCanChangeClassInDialog(true);
            this.m_GOETransformer.getGOEEditor().setValue((Object)new SpreadSheetSubset());
            this.m_GOETransformer.setLocationRelativeTo((Component)((Object)this));
        }
        return this.m_GOETransformer;
    }

    protected void filterData(String oldTitle, Object input, AbstractActor filter) {
        try {
            List processed = ActorUtils.transform((AbstractActor)filter, (Object)input);
            for (Object obj : processed) {
                if (!(obj instanceof SpreadSheet)) {
                    GUIHelper.showErrorMessage((Component)((Object)this), (String)("Generated non-spreadsheet object??\n" + obj.getClass().getName()));
                    return;
                }
                SpreadSheetTable table = this.createTable((SpreadSheet)obj);
                this.m_TabbedPane.addTab(oldTitle + "'", table);
            }
        }
        catch (Exception e) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)("Failed to filter data:\n" + Utils.throwableToString((Throwable)e)));
        }
    }

    protected void findColumns() {
        SpreadSheet sheet = this.m_TabbedPane.getCurrentSheet();
        if (sheet == null) {
            return;
        }
        this.getColumnFinderDialog().setVisible(true);
        if (this.getColumnFinderDialog().getResult() != 0) {
            return;
        }
        ColumnFinder finder = (ColumnFinder)this.getColumnFinderDialog().getGOEEditor().getValue();
        SpreadSheetColumnFilter filter = new SpreadSheetColumnFilter();
        filter.setFinder(finder);
        this.filterData(this.m_TabbedPane.getTitleAt(this.m_TabbedPane.getSelectedIndex()), sheet, (AbstractActor)filter);
    }

    protected void findRows() {
        SpreadSheet sheet = this.m_TabbedPane.getCurrentSheet();
        if (sheet == null) {
            return;
        }
        this.getRowFinderDialog().setVisible(true);
        if (this.getRowFinderDialog().getResult() != 0) {
            return;
        }
        RowFinder finder = (RowFinder)this.getRowFinderDialog().getGOEEditor().getValue();
        SpreadSheetRowFilter filter = new SpreadSheetRowFilter();
        filter.setFinder(finder);
        this.filterData(this.m_TabbedPane.getTitleAt(this.m_TabbedPane.getSelectedIndex()), sheet, (AbstractActor)filter);
    }

    protected void convert() {
        SpreadSheet sheet = this.m_TabbedPane.getCurrentSheet();
        if (sheet == null) {
            return;
        }
        this.getConversionDialog().setVisible(true);
        if (this.getConversionDialog().getResult() != 0) {
            return;
        }
        Conversion conversion = (Conversion)this.getConversionDialog().getGOEEditor().getValue();
        Convert filter = new Convert();
        filter.setConversion(conversion);
        this.filterData(this.m_TabbedPane.getTitleAt(this.m_TabbedPane.getSelectedIndex()), sheet, (AbstractActor)filter);
    }

    protected void transform() {
        SpreadSheet sheet = this.m_TabbedPane.getCurrentSheet();
        if (sheet == null) {
            return;
        }
        this.getTransformerDialog().setVisible(true);
        if (this.getTransformerDialog().getResult() != 0) {
            return;
        }
        AbstractTransformer transformer = (AbstractTransformer)this.getTransformerDialog().getGOEEditor().getValue();
        this.filterData(this.m_TabbedPane.getTitleAt(this.m_TabbedPane.getSelectedIndex()), sheet, (AbstractActor)transformer);
    }

    protected void computeDifference(SpreadSheet sheet1, SpreadSheet sheet2, Range keyCols) {
        if (sheet1 == null || sheet2 == null) {
            return;
        }
        SpreadSheetDifference filter = new SpreadSheetDifference();
        filter.setKeyColumns(keyCols);
        this.filterData(this.m_TabbedPane.newTitle(), new SpreadSheet[]{sheet1, sheet2}, (AbstractActor)filter);
    }

    protected void computeDifference() {
        ApprovalDialog dialog = this.getParentDialog() != null ? new ApprovalDialog(this.getParentDialog(), Dialog.ModalityType.DOCUMENT_MODAL) : new ApprovalDialog(this.getParentFrame(), true);
        dialog.setTitle("Compute difference");
        ParameterPanel params = new ParameterPanel();
        dialog.getContentPane().add((Component)params, "Center");
        List<String> titles = this.m_TabbedPane.getTabTitles();
        JComboBox<String> sheet1 = new JComboBox<String>(titles.toArray(new String[titles.size()]));
        params.addParameter("First sheet", sheet1);
        params.addParameter("", (Component)new JLabel("minus"));
        JComboBox<String> sheet2 = new JComboBox<String>(titles.toArray(new String[titles.size()]));
        params.addParameter("Second sheet", sheet2);
        params.addParameter("", (Component)new JLabel("using"));
        JTextField range = new JTextField(10);
        range.setText("");
        range.setToolTipText(new Range().getExample());
        params.addParameter("Key columns", (Component)range);
        dialog.pack();
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
        if (dialog.getOption() != 0) {
            return;
        }
        if (sheet1.getSelectedIndex() == sheet2.getSelectedIndex()) {
            GUIHelper.showErrorMessage((Component)((Object)this), (String)"You must select two different spreadsheets!");
            return;
        }
        this.computeDifference(this.m_TabbedPane.getSheetAt(sheet1.getSelectedIndex()), this.m_TabbedPane.getSheetAt(sheet2.getSelectedIndex()), new Range(range.getText()));
    }

    protected void process(AbstractDataPlugin plugin) {
        SpreadSheet input = this.m_TabbedPane.getCurrentSheet();
        if (input == null) {
            return;
        }
        SpreadSheet output = plugin.process(input);
        if (plugin.isInPlace()) {
            this.m_TabbedPane.getCurrentTable().setModel((TableModel)new SpreadSheetTableModel(output));
        } else {
            this.m_TabbedPane.addTab(this.m_TabbedPane.newTitle(), this.createTable(output));
        }
    }

    protected void view(AbstractViewPlugin plugin) {
        SpreadSheet sheet = this.m_TabbedPane.getCurrentSheet();
        if (sheet == null) {
            return;
        }
        BasePanel panel = plugin.generate(sheet);
        ApprovalDialog dialog = this.getParentDialog() != null ? new ApprovalDialog(this.getParentDialog(), Dialog.ModalityType.MODELESS) : new ApprovalDialog(this.getParentFrame(), false);
        dialog.setTitle(plugin.getMenuText());
        if (plugin.getMenuIcon() != null) {
            dialog.setIconImage(GUIHelper.getIcon((String)plugin.getMenuIcon()).getImage());
        }
        dialog.getContentPane().add((Component)panel, "Center");
        dialog.pack();
        dialog.setLocationRelativeTo((Component)((Object)this));
        dialog.setVisible(true);
    }

    public static synchronized Properties getProperties() {
        if (m_Properties == null) {
            m_Properties = Environment.getInstance().read("spreadsheet viewer panel");
        }
        return m_Properties;
    }
}

