/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.spreadsheetviewer;

import adams.core.ClassLister;
import adams.core.ShallowCopySupporter;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.core.BasePanel;

public abstract class AbstractViewPlugin
extends AbstractOptionHandler
implements ShallowCopySupporter<AbstractViewPlugin> {
    private static final long serialVersionUID = 5139934776170019552L;

    public abstract String getMenuText();

    public abstract String getMenuIcon();

    protected String check(SpreadSheet sheet) {
        if (sheet == null) {
            return "No spreadsheet supplied!";
        }
        return null;
    }

    protected abstract BasePanel doGenerate(SpreadSheet var1);

    public BasePanel generate(SpreadSheet sheet) {
        String msg = this.check(sheet);
        if (msg != null) {
            throw new IllegalArgumentException(msg);
        }
        return this.doGenerate(sheet);
    }

    public AbstractViewPlugin shallowCopy() {
        return this.shallowCopy(false);
    }

    public AbstractViewPlugin shallowCopy(boolean expand) {
        return (AbstractViewPlugin)OptionUtils.shallowCopy((OptionHandler)this, (boolean)expand);
    }

    public static String[] getPlugins() {
        return ClassLister.getSingleton().getClassnames(AbstractViewPlugin.class);
    }
}

